/*********************************************************************
			   TSTRNDTC.C
  Visual demonstration of the pseudorandom number generator from
  the TurboC 2.0 runtime library. Compiled using the tiny memory model.
  See the READ.ME file for further details.
 =====================================================================
  Implementation by: R.F. Genovese, Ph.D.
             TEKNOMETRIKA
             L-15, S-123
             11160 Veirs Mill Road
             Wheaton, MD 20902
 =====================================================================
**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <dos.h>

main(){
  union REGS regs;
  struct text_info initial;

  int frequency[80],last,max,cursor,spot=178;
  unsigned char curslow,curshigh,page=0;

  /* check, get, and save, user's display characteristics */
  gettextinfo(&initial);
  if((initial.currmode!=7)&&(initial.currmode!=2)&&(initial.currmode!=3)){
    cprintf("\n\rSorry, I need an 80 column video mode (i.e. 2, 3, or 7).");
    exit(1);
    }
  if(initial.currmode==3)
    textattr(31);
  else
    textattr(7);
  regs.h.ah=15;
  page=regs.h.bh;
  int86(0x10,&regs,&regs);
  page=regs.h.bh;
  /* cursor off */
  regs.h.ah=3;
  regs.h.bh=page;
  int86(0x10,&regs,&regs);
  curslow=regs.h.cl;
  curshigh=regs.h.ch;
  regs.h.ah=1;
  regs.h.ch=curshigh|0x20;
  regs.h.cl=curslow;
  int86(0x10,&regs,&regs);
  /* print a welcome message */
  clrscr();
  gotoxy(1,1);
  cprintf("\n\r\n\r\n\r");
  cprintf("   TSTRNDTC is a simple visual demonstration of the TurboC ");
  cprintf("pseudorandom number\n\r   generator.  We plot columns on the ");
  cprintf("screen representing the pseudorandom\n\r   number sequences.  ");
  cprintf("The program will run continuously.\n\r\n\r\n\r\n\r");
  cprintf("\n\r                 Press a key to begin and another to end.");
  (void)getch();
  randomize();	/* only seed the generator once */
  while(!kbhit()){
    clrscr();
    gotoxy(1,1);
    /* clear column counter array */
    for(last=0;last<80;last++)
      frequency[last]=0;
    max=0;
    /* generate and plot values until a column reaches the display top */
    while(max!=24){
      last=random(80);
      frequency[last]++;
      max=frequency[last];
      gotoxy(last+1,25-frequency[last]);
      putch(spot);
     }
    /* we finished a screen, wait a bit and do it again */
    delay(1800);
   }
   /* user has terminated the program, fix up some stuff and leave */
   textattr(initial.attribute);
   gotoxy(1,1);
   clrscr();
   /* cursor on */
   regs.h.ah=1;
   regs.h.ch=curshigh&0xdf;
   regs.h.cl=curslow;
   int86(0x10,&regs,&regs);
   /* webedone */
   (void)getch();
   exit(0);
}
