# EXAMPLE.MAK
# default memory model = compact
#
#  Example command line:  make -fexample -DMDL=s -DX=3
#
#    which means compile and link example3 using small memory model
#
#    This makefile assumes the correct memory model
#    RedBlack library has already been built.
#

!if !$d(MDL)
MDL=c
!endif

!if !$d(X)
!error Select example by defining X=n
!endif

example$(X).exe: example$(X).obj
	tlink c0$(MDL) example$(X), example$(X),, \
	      emu.lib math$(MDL).lib c$(MDL).lib rb_$(MDL).lib

.c.obj:
	bcc -c -a -P-c -m$(MDL) {$* }

#  switches:
#    -c   : compile to OBJ only
#    -a   : word alignment
#    -P-c : default file extension = .C
#    -m   : memory model
