/*
 *: program Example4
 *: purpose: Test shell for threaded RedBlack tree. Demonstrates alternate
 *:	     identifier functions, alternate compare functions.
 *
 *: Usage:  EXAMPLE4 <filename>
 *
 *  Copyright (c) 1993	Bert C. Hughes
 *			200 N. Saratoga
 *			St.Paul, MN 55104
 *			Compuserve 71211,577
 */

#if defined NDEBUG
#error Compile EXAMPLE1.C with NDEBUG undefined.
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "redblack.h"

#if defined __TURBOC__
#include <conio.h>
#else
#define cprintf printf
#endif

void pause(void)
{
    int c;
    cprintf("\r\nPress <ENTER> to continue...");
    while (getchar() != '\n');
    cprintf("\r\n");
}

typedef struct datarecord {
	  long	EmpID;
	  long	salary;
	  char	Name[20];
	} DataRecord, *DRptr;


void *NameID(void *x)
{
    DRptr rec = x;
    return (rec->Name);
}

void *Employee(void *x)
{
    DRptr rec = x;
    return (&rec->EmpID);
}

int IDcmp(void *x1, void *x2)
{
    DRptr x = x1;
    DRptr y = x2;
    return (x->EmpID > y->EmpID ? -1 : (x->EmpID < y->EmpID ? +1 : 0));
}


void *copy_rec(const void *x)
{
    DRptr p = malloc(sizeof(DataRecord));
    if (p)
	memcpy(p,x,sizeof(DataRecord));
    return(p);
}

void *read_rec(void *dest, const void *src)
{
    return(memcpy(dest,src,sizeof(DataRecord)));
}

#pragma warn -pia

main (int argc, char *argv[])
{
    RB_treeptr tree1, tree2;
    RB_nodeptr p;
    DataRecord InpR, *Dta;

    int (*cmp)() = strcmp;  /* use C library function "strcmp" to compare */
			    /* DataRecord.Name identifiers */

    int (*numcmp)() = IDcmp; /* Employee Idenitifier */

    FILE *fp;

#if defined __TURBOC__
    directvideo = 0;   /* change to 1 if there is "snow" on your monitor */
#endif

    if (argc < 2)
	assert(fp = fopen("EMPLDATA","r"));
    else
	assert(fp = fopen(argv[1],"r"));

    assert((tree1 = rb_init(cmp,NameID,copy_rec,free,read_rec,malloc,free)));
    assert((tree2 = rb_init(numcmp,Employee,copy_rec,free,read_rec,malloc,free)));

    cprintf("Input will be echoed...\r\n");

    while (fscanf(fp,"%ld %ld %s",&InpR.EmpID,&InpR.salary,InpR.Name) != EOF) {
	/* echo input */
	cprintf("%-10.ld %-10ld %+20s\r\n",InpR.EmpID,InpR.salary,InpR.Name);
	/* insert into trees */
	if (!rb_insert(tree1,&InpR,0)) {
	    cprintf("\r\nOut of memory!");
	    return EXIT_FAILURE;
	}
	if (!rb_insert(tree2,&InpR,0)) {
	    cprintf("\r\nOut of memory!");
	    return EXIT_FAILURE;
	}
    } /* end while - input loop */

    fclose(fp);

    pause();

    cprintf("Listed by NAME\r\n");

    p = rb_reset(tree1);

    while (p = rb_succ(p)) {
	Dta = p->dataptr;
	cprintf("%ld    %-23.20s   %ld\r\n",Dta->EmpID,Dta->Name,Dta->salary);
    }

    pause();

    cprintf("Listed by Employee_ID (descending)\r\n");

    p = rb_reset(tree2);

    while (p = rb_succ(p)) {
	Dta = p->dataptr;
	cprintf("%ld    %-23.20s   %ld\r\n",Dta->EmpID,Dta->Name,Dta->salary);
    }

    return EXIT_SUCCESS;
}
