#  Create RedBlack library.  
#
#    Unlike the library source code, which is "Standard C" (here's hoping) 
#    and does not depend on any particular compiler, this MAKEFILE is geared 
#    to Borland C++, Borland's MAKE and Borland's library utility "TLIB", 
#    and is included purely as a convenience and for illustrative purposes.  
#
#    Naming convention: rb_t.lib    -  TINY    memory model library
#                       rb_s.lib    -  SMALL   memory model library
#                       rb_m.lib    -  MEDIUM  memory model library
#                       rb_c.lib    -  COMPACT memory model library
#                       rb_l.lib    -  LARGE   memory model library
#                       rb_h.lib    -  HUGE    memory model library
#
#
#    Example command line to create compact memory model library:
#        MAKE -DMDL=c -frb_bcc
#
!if !$d(MDL)
MDL=s
!endif
#
#
rb_$(MDL).lib:   rb_init.obj rb_pred.obj rb_succ.obj rb_sdt.obj \
                 rb_reset.obj rb_free.obj rb_find.obj rb_priv.obj \
                 rb_ins.obj rb_del.obj rb_gdt.obj rb_dall.obj rb_rmv.obj
#                 
  tlib rb_$(MDL) +rb_init +rb_pred +rb_succ +rb_sdt +rb_reset +rb_dall
  tlib rb_$(MDL) +rb_free +rb_find +rb_priv +rb_ins +rb_del +rb_gdt +rb_rmv
#
#  Don't leave the object files lying around; they will interfere
#  with creating other memory model libraries.
#
  del rb_*.obj
#
#
.c.obj:
   bcc -c -m$(MDL) -A -a -P-c -DNDEBUG -G -O -Z {$* }
#
#  - compiler options:
#
#  -c              compile only (REQUIRED)
#  -m$(MDL)        memory model (REQUIRED)
#  -P-c            default file name extension is ".C"
#  -DNDEBUG        NDEBUG defined - removes assertions (RECOMMENDED)
#  -A              ANSI keywords only
#  -G              optimize for speed
#  -a              word alignment
#  -Z              register optimization ON
#  -O              optimize jumps
#
#  Change the options to suit your needs - these are mine.
#
