/*: RB_DALL.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype: void rb_delete_all(RB_treeptr)
 *: Purpose:   Remove all data nodes, freeing dynamic memory, leave tree empty.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *			    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

void rb_delete_all(RB_treeptr tree)
{
    register RB_nodeptr q;
    register RB_nodeptr p = rb_succ(rb_reset(tree));

    while (p) {
	p = rb_succ(q = p);
	(*tree->free_item)(q->dataptr);
	(*tree->dealloc)(q);
    }
    /* fix up the head node */
    tree->head.Lbit = THREAD;
    tree->head.Lptr = &tree->head;
}
