/*: REDBLACK.H	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype:	int rb_delete(RB_treeptr, void *identifier)
 *: Purpose:	Delete from RedBlack tree the node whose identifier
 *:		equals "*identifier", if such a node exists. Returns
 *:		non-zero if & only if a node is deleted.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		 author:    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"

int rb_delete (RB_treeptr tree, void *key)
{
     register RB_nodeptr p = rb_find(tree,key);
     return (p ? rb_remove(tree,p), 1 : 0);
}
