/*: RB_FIND.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype:	RB_nodeptr rb_find(RB_treeptr, void *identifier)
 *: Purpose:	Find id:item in tree
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		 author:    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

RB_nodeptr rb_find(RB_treeptr tree, void *key)
		/* Return pointer to tree node containing data-item
		   identified by "key"; returns NULL if not found */
{
    register RB_nodeptr p = Leftchild(&tree->head);
    register int side;
    while (p)
    {
	side = (*tree->cmp)(key,(*tree->key_of)(p->dataptr));
	if (side > 0)
	    p = Rightchild(p);
	else if (side < 0)
	    p = Leftchild(p);
	else
	    return p;
    }
    return NULL;
}
