/*: RB_FREE.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype:	void rb_destroy(RB_treeptr)
 *: Purpose:	Destroy a RedBlack tree - free all dynamic memory used.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		author:     Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"

void rb_destroy(RB_treeptr tree)
{
    register RB_nodeptr q;
    register RB_nodeptr p = rb_succ(rb_reset(tree));

    while (p) {
	p = rb_succ(q = p);
	(*tree->free_item)(q->dataptr);
	(*tree->dealloc)(q);
    }
    (*tree->dealloc)(tree);
}
