/*: RB_INIT.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype: RB_treeptr(int (*compare)(void *,void *),
 *.			  void *(*key_of)(void *),
 *.			  void *(*make_item)(const void *),
 *.			  void (*free_item)(void *),
 *.			  void *(*copy_item)(void *, const void *),
 *.			  void *(*alloc)(size_t),
 *.			  void (*dealloc)(void *))
 *
 *: Purpose:   Initialize Red-Black tree. Must be called before tree
 *:	       can be used.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		 author:    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

RB_treeptr rb_init(    /* pointers to user-supplied functions */
     int (*compare)(void *, void *),
     void *(*key_of)(void *),
     void *(*make_item)(const void *),
     void (*free_item)(void *),
     void *(*copy_item)(void *, const void *),
     void *(*alloc)(size_t),
     void (*dealloc)(void *))
{
    RB_treeptr tree = (*alloc)(sizeof(RB_TREE));

    if (tree)	{
	  tree->cmp = compare;
	  tree->key_of = key_of;
	  tree->make_item = make_item;
	  tree->free_item = free_item;
	  tree->copy_item = copy_item;
	  tree->alloc = alloc;
	  tree->dealloc = dealloc;
	  tree->head.color = BLACK;
	  tree->head.Lbit = THREAD;
	  tree->head.Rbit = LINK;
	  tree->head.dataptr = NULL;
	  tree->head.Lptr = &tree->head;
	  tree->head.Rptr = &tree->head;
    }
    return tree;
}
