/*: RB_PRED.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype: RB_nodeptr rb_pred(RB_nodeptr p)
 *: Purpose:   return in-order predeccessor of "p"
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		author:     Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

RB_nodeptr rb_pred(RB_nodeptr p)
{
    register RB_nodeptr q;

    if (!p)
	return NULL;

    q = p->Lptr;

    if (LLINK(p))
	while (RLINK(q))
	    q = q->Rptr;

    return (Is_Head(q) ? NULL : q);
}
