/*: RB_PRIV.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Module : rb_priv: minOf(),maxOf(),parentOf(),rotateRight(),rotateLeft()
 *: Purpose: private functions for threaded RedBlack tree library internal use.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		author:     Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

RB_nodeptr minOf(RB_nodeptr t)
{
    while (LLINK(t)) t = t->Lptr;
    return t;
}

RB_nodeptr maxOf(RB_nodeptr t)
{
     while (RLINK(t)) t = t->Rptr;
     return t;
}

RB_nodeptr parentOf(RB_nodeptr t)
{
     return (t->rchild ? minOf(t)->Lptr : maxOf(t)->Rptr);
}

void rotateRight(RB_nodeptr p) {
     RB_nodeptr a = p->Lptr;
     RB_nodeptr q = parentOf(p);

     if (p->rchild)
	  { q->Rptr = a;  a->rchild = 1; }
     else
	  { q->Lptr = a;  p->rchild = 1; }

     if (RLINK(a)) {
	  p->Lptr = a->Rptr;
	  p->Lptr->rchild = 0;
	  a->Rptr = p;
     }
     else {
	  a->Rbit = LINK;
	  p->Lbit = THREAD;
     }
}/*rotateRight*/

void rotateLeft(RB_nodeptr p) {
     RB_nodeptr a = p->Rptr;
     RB_nodeptr q = parentOf(p);

     if (p->rchild)
	  { q->Rptr = a;  p->rchild = 0; }
     else
	  { q->Lptr = a;  a->rchild = 0; }

     if (LLINK(a)) {
	  p->Rptr = a->Lptr;
	  p->Rptr->rchild = 1;
	  a->Lptr = p;
     }
     else {
	  a->Lbit = LINK;
	  p->Rbit = THREAD;
     }
}/*rotateLeft*/
