#if !defined RBPRIV_H
#define RBPRIV_H
/*: RB_PRIV.H	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: module: RB_PRIV.H
 *: purpose: Internal stuff for threaded RedBlack tree library functions.
 *.          None of the definitions or prototypes in this header
 *.          are for "public" use - this header is for the private
 *.          use of the RB_tree library only. This header must be present
 *.          when the RB_tree library functions are compiled, but "rb_priv.h"
 *.          never needs to be included in any application, nor should it be.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *	   author:	Bert C. Hughes
 *			200 N. Saratoga
 *			St.Paul, MN 55104
 *			Compuserve 71211,577
 */

#define RED    0
#define BLACK  1
#define RIGHT	-1
#define LEFT	+1
#define THREAD	0
#define LINK	1
#define LLINK(x)    ((x)->Lbit)
#define RLINK(x)    ((x)->Rbit)
#define LTHREAD(x)  (!LLINK(x))
#define RTHREAD(x)  (!RLINK(x))
#define Leftchild(x)  (LLINK(x) ? (x)->Lptr : (void *) 0)
#define Rightchild(x) (RLINK(x) ? (x)->Rptr : (void *) 0)
#define Is_Head(x)    ((x)->Rptr == (x))
			    /* always true for head node of initialized */
			    /* rb_tree, and false for all other nodes */

#define colorOf(x)  ((x) ? (x)->color : BLACK)

RB_nodeptr minOf(RB_nodeptr);
RB_nodeptr maxOf(RB_nodeptr);
RB_nodeptr parentOf(RB_nodeptr);

void rotateRight(RB_nodeptr);
void rotateLeft(RB_nodeptr);
#endif
