/*: RB_RESET.C	 Threaded RedBlack Tree Library   Version 1.51	8-feb-93
 *
 *: Prototype: RB_nodeptr rb_reset(RB_treeptr)
 *: Purpose:   Prepare RedBlack tree for sequential processing. A threaded
 *.	       RedBlack tree may be viewed as a circular list with a head
 *.	       node.  "rb_reset()" returns a pointer to the tree's head
 *.	       node, which can then be passed to the routines "rb_succ"
 *.	       and "rb_pred".
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *  author:		    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"

RB_nodeptr rb_reset(RB_treeptr tree)
{
    return &tree->head;
}
