/*: RB_RMV.C	Threaded RedBlack Tree Library	 Version 1.51   8-feb-93
 *
 *: Prototype:	void rb_remove(RB_treeptr, RB_nodeptr p)
 *: Purpose:	Delete from RedBlack tree the node "p".
 *.             (Of course, node "p" must actually belong to the tree...)
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *		 author:    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"
#include <assert.h>  /* compile production version with NDEBUG defined
			to remove assertions. */
#pragma warn -pia

static void fixupTree(RB_nodeptr);

void rb_remove(RB_treeptr tree, RB_nodeptr p)
{
     RB_nodeptr q;

     if (!p || Is_Head(p)) return;

     (*tree->free_item)(p->dataptr);

     for (;;) {
	  if (RLINK(p)) {
	       q = minOf(p->Rptr);
	       p->dataptr = q->dataptr;
	  }
	  else if (LLINK(p)) {
	       q = maxOf(p->Lptr);
	       p->dataptr = q->dataptr;
	  }
	  else break;  /* p is a leaf */

	  p = q;
     }		       /* until p points to a leaf */

     q = parentOf(p);
     if (p->rchild) {
	  q->Rptr = p->Rptr;
	  q->Rbit = THREAD;
     }
     else {
	  q->Lptr = p->Lptr;
	  q->Lbit = THREAD;
     }

     if (p->color == BLACK)  fixupTree(p);
			/* (q) becomes a leaf/halfleaf, and path leading
			 *  to (q)->nil is going to be short one BLACK */
     (*tree->dealloc)(p);
} /* remove */

static void fixupTree(RB_nodeptr p) {
     RB_nodeptr q,z,zr,zl;

    /* move rule 5 violation up the tree until we can either fix it
     * by marking the RED node(p) BLACK, or we reach the root, so that
     * all paths are shorter by one BLACK, and thus rule 5 is satisfied.
     */

     while ((p->color == BLACK) && !(q = parentOf(p),Is_Head(q)))
	  if (p->rchild) {   /* p is Right child of q */
	       z = Leftchild(q);
	       assert(z);  /* otherwise there is no rule 5 violation */

	       zr = Rightchild(z);

	       if (q->color == RED) {
		    assert(z->color == BLACK);

		    if (colorOf(zr) == RED) {
			 rotateLeft(z);
			 rotateRight(q);
			 q->color = BLACK;
		    }
		    else rotateRight(q);

		    break;
	       }

	       if (z->color == RED) {
		    assert(Leftchild(z) && zr);
		    assert(Leftchild(z)->color==BLACK && zr->color==BLACK);
		    rotateRight(q);
		    q->color = RED;
		    z->color = BLACK; /*next loop will exit, q is RED*/
		    continue;
	       }
	       else { /* z->color == BLACK */
		    if (colorOf(zr) == BLACK) {
			 rotateRight(q);
			 q->color = RED;
			 p = z;
			 continue;
		    }
		    else {
			 rotateLeft(z);
			 rotateRight(q);
			 zr->color = BLACK;
			 break;
		    }
	       }
	  }
	  else /* p is Left child of q */ {
	       z = Rightchild(q);
	       assert(z);     /* otherwise there is no rule 5 violation */
	       zl = Leftchild(z);

	       if (q->color == RED) {
		    assert(z->color == BLACK);

		    if (colorOf(zl) == RED) {
			 rotateRight(z);
			 rotateLeft(q);
			 q->color = BLACK;
		    }
		    else rotateLeft(q);

		    break;
	       }

	       if (z->color == RED) {
		    assert(zl && Rightchild(z));
		    assert(zl->color==BLACK && Rightchild(z)->color==BLACK);
		    rotateLeft(q);
		    q->color = RED;
		    z->color = BLACK; /*next loop will exit, q is RED*/
		    continue;
	       }
	       else { /* z->color == BLACK */
		    if (colorOf(zl) == BLACK) {
			 rotateLeft(q);
			 q->color = RED;
			 p = z;
			 continue;
		    }
		    else {
			 rotateRight(z);
			 rotateLeft(q);
			 zl->color = BLACK;
			 break;
		    }
	       }
	  }
     /* end while */

     p->color = BLACK;
}/*fixupTree*/
