/*: RB_SDT.C	Threaded RedBlack Tree Library	 Version 1.51   8-feb-93
 *
 *: Prototype: int rb_setdata(RB_treeptr, RB_nodeptr p, void *item)
 *: Purpose:   Copy data from *item to node "p".
 *: Returns:   Non-zero if unsuccessful.
 *
 *  RELEASED TO THE PUBLIC DOMAIN
 *
 *  Author:		    Bert C. Hughes
 *			    200 N.Saratoga
 *			    St.Paul, MN 55104
 *			    Compuserve 71211,577
 */

#include "redblack.h"
#include "rb_priv.h"

int rb_setdata(RB_treeptr tree, RB_nodeptr p, void *item)
{
    void *temp;

    if (Is_Head(p)) return TREE_ILLEGAL_OP;

    if ((*tree->cmp)((*tree->key_of)(p->dataptr),(*tree->key_of)(item)))
	return TREE_ILLEGAL_OP;  /* Don't allow identifier to change! */

    if (!(temp = (*tree->make_item)(item))) return TREE_NOMEM;

    (*tree->free_item)(p->dataptr);

    p->dataptr = temp;

    return TREE_OK;
}
