TESTING "ARRYST.CPP - class ArrayStatistics"
CREATE "arry_tst.cpp"
INCLUDE "arryst.hpp"

\
\ Testing ArrayStatistics as an example 
\ of TESTMAN operation.
\

\ First, provide array of 5 numbers (1 to 5)
\ and process.  Use "sign" to allow easy
\ inheritance of this test for negative case.
\
TEST positive_array :
	DECLARE narray AS "const int narray=5;"
	DECLARE array AS "double array[narray];"
	DECLARE sign AS "int sign=1;"
	DO
		\ set the content of the array
		"array[0] = sign*1.0;"
		"array[1] = sign*2.0;"
		"array[2] = sign*3.0;"
		"array[3] = sign*4.0;"
		"array[4] = sign*5.0;"
		"ArrayStatistics stats(array,narray);"
	\
	\ perform checks of results
	\
	CHECK "stats.Status()" IS {ARRSTAT_NO_PROBLEM}
	CHECK "stats.Minimum()" IS {sign*1.0}
	CHECK "stats.Maximum()" IS {sign*5.0}
	CHECK "stats.MinOccurredAt()" IS {0}
	CHECK "stats.MaxOccurredAt()" IS {4}
	CHECK "stats.Mean()" IS {sign*3.0}
END

\ Like previous test but the double precision array
\ consists of all negative numbers.
\
TEST negative_array LIKE positive_array:
	\
	\ Note that array and narray are inherited
	\
	DECLARE sign AS "int sign= -1;"
	\
	\ All checks are inherited.  Must override
	\ checks that changed.
	\
	CHECK "stats.Minimum()" IS {sign*5.0}
	CHECK "stats.Maximum()" IS {sign*1.0}
	CHECK "stats.MinOccurredAt()" IS {4}
	CHECK "stats.MaxOccurredAt()" IS {0}
END

\ Provide a bad count parameter and ensure
\ return code is correct.
\
TEST bad_count:
	DECLARE array AS "double value=10.0;"
	DECLARE count AS "int count= -1;"
	DECLARE stat AS "ArrayStatistics stats(&value,count);"
	CHECK "stats.Status()" IS {ARRSTAT_INVALID_COUNT}
END

\ Like prevous test, but count is zero.  This also
\ should cause invalid status to be returned.
\
TEST bad_count2 LIKE bad_count:
	DECLARE count AS "int count= 0;"
END

\ Set count correctly to 1 and check the results.
\
TEST count_is_1 LIKE bad_count:
	DECLARE count AS "int count= 1;"
	CHECK "stats.Status()" IS {ARRSTAT_NO_PROBLEM}
	CHECK "stats.Minimum()" IS {value}
	CHECK "stats.Maximum()" IS {value}
	CHECK "stats.Mean()" IS {value}
	CHECK "stats.MinOccurredAt()" IS {0}
	CHECK "stats.MaxOccurredAt()" IS {0}
END

\ Like previous testcase but the single value
\ in the array is negative.
\
TEST count_is_1b LIKE count_is_1:
	DECLARE array AS "double value= -10.0;"
END

\ Use an array of 10 numbers and check the results.
\ (NOTE that a string was included for example and
\ is not related to the class under test.)
\
TEST LIKE positive_array :
	DECLARE narray AS "const int narray=10;"
	\
	\ The following is used for an example of string handling
	\
	DECLARE str AS "char str[10]; strcpy(str,\"Hello\");"
	DO
		"array[0] = 10.0;"
		"array[1] = -23.0;"
		"array[2] = 13.0;"
		"array[3] = -42.0;"
		"array[4] = 5.0;"
		"array[5] = -11.0;"
		"array[6] = 22.0;"
		"array[7] = -13.0;"
		"array[8] = 64.0;"
		"array[9] = -75.0;"
		"ArrayStatistics stats(array,narray);"
	\ 
	\ The check of the status is inherited from "positive_array"
	\
	CHECK "stats.Minimum()" IS {-75}
	CHECK "stats.Maximum()" IS {64}
	CHECK "stats.MinOccurredAt()" IS {9}
	CHECK "stats.MaxOccurredAt()" IS {8}
	CHECK "stats.Mean()" IS {-5}
	CHECK "str" IS "Hello"
END
