/*
   03-16-89

   Simple Text Windowing Library for Micro-C, Turbo-C, and DJGPP.

   Copyright (c) 1989, 1996, Scott Beasley.
   Released into the Public Domain

   Scott Beasley.
   704 Otis RD. Walterboro, SC 29488.
   e-mail: scottb@lowcountry.com
*/

#define TESTIT

#include <stdio.h>

#ifndef _MICROC_
#include <io.h>
#endif

#ifndef _MICROC_
#include <string.h>
#include <stdarg.h>
#endif

#include <ctype.h>
#include "textwin.h"

#ifdef __TURBOC__
#define PEEK peekb
#define POKE pokeb
#endif

#ifdef _MICROC_
#define PEEK peek
#define POKE poke
#endif

#ifdef __DJGPP__
#include <sys/farptr.h>
#include <go32.h>

#define PEEK(baseadd,offset) _farpeekb(_dos_ds, baseadd+offset)
#define POKE(baseadd,offset,val) _farpokeb(_dos_ds, baseadd+offset,val)
#define scrnbase 0xb8000
#endif

#ifndef __DJGPP__
#define scrnbase 0xb800
#endif

struct WINDOW * wsave ( int x, int y, int xwid, int yhgt )  
{
   struct WINDOW *hwnd;
   register int winwid, winlen;
   unsigned scrloc;
   char *savebuf;

   #ifdef _MICROC_
   hwnd = malloc ( sizeof ( struct WINDOW ) );
   #endif

   #ifndef _MICROC_
   hwnd = ( struct WINDOW * ) malloc ( sizeof ( struct WINDOW ) );
   #endif

   hwnd->savebuf = ( char * ) malloc ( ( yhgt + 2 ) * ( xwid + 2 ) * 2 );
   savebuf = hwnd->savebuf;

   scrloc = findadd ( x, y );

   hwnd->curpos = scrloc;
   hwnd->x = x;
   hwnd->y = y;
   hwnd->hgt = yhgt;
   hwnd->wid = xwid;

   for ( winlen = hwnd->y; winlen <= hwnd->y + hwnd->hgt + 1; winlen++ ) {
      for ( winwid = hwnd->x; winwid <= hwnd->x + hwnd->wid + 1; winwid++ ) {
         *savebuf = PEEK ( scrnbase, scrloc );
         scrloc++; savebuf++;
         *savebuf = PEEK ( scrnbase, scrloc );
         scrloc++; savebuf++;
      } 

      scrloc = findadd ( x, winlen );
   }

   return hwnd;
}                                       

int wrestore ( struct WINDOW *hwnd )  
{
   register int winwid, winlen;
   unsigned scrloc;
   char *savebuf;

   savebuf = hwnd->savebuf;

   scrloc = findadd ( hwnd->x, hwnd->y );

   for ( winlen = hwnd->y; winlen <= hwnd->y + hwnd->hgt + 1; winlen++ ) {
      for ( winwid = hwnd->x; winwid <= hwnd->x + hwnd->wid + 1; winwid++ ) {
         POKE ( scrnbase, scrloc, *savebuf );
         scrloc++; savebuf++;
         POKE ( scrnbase, scrloc, *savebuf );
         scrloc++; savebuf++;
      } 

      scrloc = findadd ( hwnd->x, winlen );
   }

   return 1;
}                                       

int wdestroy ( struct WINDOW *hwnd )
{
   wrestore ( hwnd );

   free ( hwnd->savebuf );
   free ( hwnd );

   return 1;
}
  
int wcls ( struct WINDOW *hwnd )  
{
   register int winwid, winlen;
   unsigned scrloc;

   scrloc = findadd ( hwnd->x + 1, hwnd->y + 1 );

   for ( winlen = hwnd->y + 1; winlen <= hwnd->y + hwnd->hgt; winlen++ ) {
      for ( winwid = hwnd->x + 1; winwid <= hwnd->x + hwnd->wid; winwid++ ) {
         POKE ( scrnbase, scrloc, ' ' );
         scrloc++;
         POKE ( scrnbase, scrloc, hwnd->attrib );
         scrloc++;
      } 

      scrloc = findadd ( hwnd->x + 1, winlen );
   }

   hwnd->curxpos = 1;
   hwnd->curypos = 1;
   hwnd->curpos = findadd ( hwnd->x + hwnd->curxpos,
                            hwnd->y + hwnd->curypos );

   return 1;
}                                       

/* Draw a box around window. */
void wbox ( struct WINDOW *hwnd, int fore, int back, int intens )
{
   int i, att;
   unsigned scrloc;
   char boxline[81];

   /* Set color and position. */
   att = ( fore | ( back << 4 ) | intens );
   scrloc = findadd ( hwnd->x, hwnd->y );

   /* Draw box top. */
   boxline[0] = '';
   memset ( boxline + 1, '', hwnd->wid );
   boxline[hwnd->wid + 1] = '';
   boxline[hwnd->wid + 2] = 0;
   absputs ( scrloc, boxline, att );

   /* Draw box sides and center. */
   boxline[0] = '';
   memset ( boxline + 1, ' ', hwnd->wid );
   boxline[hwnd->wid + 1] = '';
   boxline[hwnd->wid + 2] = 0;

   for ( i = 1; i <= hwnd->hgt; ++i ) {
      scrloc = findadd ( hwnd->x, hwnd->y + i );
      absputs ( scrloc, boxline, att );
   }

   /* Draw box bottom. */
   scrloc = findadd ( hwnd->x, hwnd->y + hwnd->hgt );
   boxline[0] = '';
   memset ( boxline + 1, '', hwnd->wid );
   boxline[hwnd->wid + 1] = '';
   boxline[hwnd->wid + 2] = 0;
   absputs ( scrloc, boxline, att );
}

int wputc ( struct WINDOW *hwnd, char c )
{
   int tab;

   tab = 8;

   if ( c != '\t' && c != '\r' && c != '\n' ) {
      absputc ( hwnd->curpos, c, hwnd->attrib );
      hwnd->curpos += 2;
   }

   if ( c == '\t' ) {
      while ( tab-- ) {
         absputc ( hwnd->curpos, ' ', hwnd->attrib );
         hwnd->curpos += 2;
         movepsdcur ( hwnd );
      }
   }   

   if ( c == '\r' ) {
      hwnd->curxpos = 0;
   }

   if ( c == '\b' ) {
      hwnd->curxpos--;
   }

   if ( c == '\n' ) {
      hwnd->curxpos = 0;
      hwnd->curypos++;
   }

   movepsdcur ( hwnd );
   return 1;
}

int wputs ( struct WINDOW *hwnd, char *str )
{
   while ( *str ) {
      wputc ( hwnd, *str++ );
   }

   return 1;
}

#ifndef _MICROC_
int wprintf ( struct WINDOW *hwnd, char *strfmt, ... )
{
   int iret;
   va_list pvArglist;
   char strOutput[1024];

   va_start ( pvArglist, strfmt );
   iret = vsprintf ( strOutput, strfmt, pvArglist );
   wputs ( hwnd, strOutput );

   return iret;
}
#endif

int movepsdcur ( struct WINDOW *hwnd )
{
   if ( hwnd->curxpos >= hwnd->x + hwnd->wid - 1 ) {
      hwnd->curxpos = 1;
      hwnd->curypos++;
   }

   else
      hwnd->curxpos++;
 
   if ( hwnd->curypos >= hwnd->y + hwnd->hgt - 1 ) 
      hwnd->curypos--;

   hwnd->curpos = findadd ( hwnd->x + hwnd->curxpos,
                            hwnd->y + hwnd->curypos );

   return 1;
}

int wlocate ( struct WINDOW *hwnd, int x, int y )
{
   int xp, yp;

   x++; y++;

   hwnd->curxpos = x;
   hwnd->curypos = y;

   xp = screenx ( hwnd );
   yp = screeny ( hwnd );

   hwnd->curpos = findadd ( xp, yp );

   return 1;
}

int absputs ( unsigned scrloc, char *str, int att )
{
   while ( *str ) {
      absputc ( scrloc, *str++, att );
      scrloc += 2;
   }

   return 1;
}

unsigned findadd ( int x, int y ) 
{
   register unsigned offset;

   offset = ( y * 160 ) + x * 2;

   return offset;
}

void wcolor ( struct WINDOW *hwnd, int fore, int back, int intens )
{
   hwnd->attrib = ( fore | ( back << 4 ) | intens );
}

void absputc ( unsigned scrloc, char c, int att ) 
{
   POKE ( scrnbase, scrloc, c );
   scrloc++;
   POKE ( scrnbase, scrloc, att );
}

int wgetstr ( struct WINDOW *hwnd, char *strBuff, int ilen )
{
   int ichr, iRealLen = 0;
   char *strHead = strBuff;

   while ( 1 ) {
      ichr = getchr ( );
  
      if ( ichr == '\b' ) {
         strBuff--;
         ilen++;
         iRealLen++;
         wputc ( hwnd, ( char ) '\b' );
         wputc ( hwnd, ( char ) ' ' );
         wputc ( hwnd, ( char ) '\b' );
      }

      if ( isprint ( ichr ) ) {
         *strBuff++ = ( char ) ichr;
         ilen--;
         iRealLen--;
         wputc ( hwnd, ( char ) ichr );
      }

      if ( ichr == '\r' || !ilen ) {
         *( strBuff + iRealLen ) = ( char ) 0;
      }
   }
}

int getchr ( void )
{
   char c;

   return ( read ( 0, &c, 1 ) == 1 ) ? ( int ) c : EOF;
}