/*
   03-16-89

   TEXTWIN.H

   Simple Text Windowing Library for Micro-C, Turbo-C, and DJGPP.

   Copyright (c) 1989, 1997, Scott Beasley.
   Released into the Public Domain

   Scott Beasley.
   704 Otis RD. Walterboro, SC 29488.
   e-mail: scottb@lowcountry.com
*/

struct WINDOW {
   int x;
   int y;
   int hgt;
   int wid;
   int attrib;
   int curxpos;
   int curypos; 
   unsigned curpos;
   char *savebuf;
};

/* Macro to find actaul screen coords of cursor inside window. */
#define screenx(hwnd) (hwnd)->x + (hwnd)->curxpos
#define screeny(hwnd) (hwnd)->y + (hwnd)->curypos

/* Prototypes. */
struct WINDOW * wsave ( int x, int y, int xwid, int yhgt );
int wrestore ( struct WINDOW *hwnd );
int wdestroy ( struct WINDOW *hwnd );
int wcls ( struct WINDOW *hwnd );
void wbox ( struct WINDOW *hwnd, int fore, int back, int intens );
int wlocate ( struct WINDOW *hwnd, int xp, int yp );
int absputs ( unsigned scrloc, char *str, int att );
int wputs ( struct WINDOW *hwnd, char *str );
unsigned findadd ( int x, int y );
int wputc ( struct WINDOW *hwnd, char c );
int wlineinput ( struct WINDOW *hwnd, char *str, int len );
int wprintf ( struct WINDOW *hwnd, char *strfmt, ... );
void wcolor ( struct WINDOW *hwnd, int fore, int back, int intens );
void absputc ( unsigned scrloc, char c, int att );
