/***********************************************************************/
/* COLOUR.C - Colour related functions                                 */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: colour.c 2.0 1995/01/26 16:29:47 MH Release MH $
*/

#include "the.h"
#include "proto.h"

/*                        attributes                                   */
/*             FILEAREA CURLINE  BLOCK    CBLOCK                       */
/*             CMDLINE  IDLINE   MSGLINE  ARROW                        */
/*             PREFIX   PENDING  SCALE    TOFEOF                       */
/*             CTOFEOF  TABLINE  SHADOW   STATAREA                     */
/*             DIVIDER  RESERVED                                       */

#ifdef A_COLOR
 static chtype the_fore[ATTR_MAX] =
              {COLOR_WHITE,COLOR_WHITE,COLOR_BLUE,COLOR_RED,
               COLOR_BLACK,COLOR_BLUE,COLOR_RED,COLOR_BLACK,
               COLOR_BLACK,COLOR_RED,COLOR_YELLOW,COLOR_WHITE,
               COLOR_WHITE,COLOR_YELLOW,COLOR_RED,COLOR_BLUE,
               COLOR_RED,COLOR_WHITE};
 static chtype the_back[ATTR_MAX] =
              {COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_CYAN,COLOR_WHITE,COLOR_WHITE,COLOR_CYAN,
               COLOR_CYAN,COLOR_WHITE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_WHITE,COLOR_BLACK};
 static chtype the_mod[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL,A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL,A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL};
 static chtype kedit_fore[ATTR_MAX] =
              {COLOR_CYAN,COLOR_YELLOW,COLOR_CYAN,COLOR_YELLOW,
               COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,
               COLOR_YELLOW,COLOR_WHITE,COLOR_YELLOW,COLOR_CYAN,
               COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,
               COLOR_CYAN,COLOR_YELLOW};
 static chtype kedit_back[ATTR_MAX] =
              {COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE};
 static chtype kedit_mod[ATTR_MAX]  =
              {A_BOLD,  A_BOLD,  A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL,A_BOLD,
               A_BOLD,  A_BOLD};
 static chtype xedit_fore[ATTR_MAX] =
              {COLOR_GREEN, COLOR_CYAN, COLOR_BLACK,COLOR_CYAN,
               COLOR_YELLOW,COLOR_GREEN,COLOR_RED,  COLOR_GREEN,
               COLOR_GREEN, COLOR_GREEN,COLOR_GREEN,COLOR_GREEN,
               COLOR_GREEN, COLOR_GREEN,COLOR_GREEN,COLOR_GREEN,
               COLOR_GREEN, COLOR_GREEN};
 static chtype xedit_back[ATTR_MAX] =
              {COLOR_BLACK,COLOR_BLACK,COLOR_GREEN,COLOR_GREEN,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK};
 static chtype xedit_mod[ATTR_MAX]  =
              {A_NORMAL,A_BOLD,  A_NORMAL,A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_NORMAL,
               A_BOLD,  A_BOLD,  A_NORMAL,A_BOLD,
               A_BOLD,  A_BOLD};
#else
 static chtype the_fore[ATTR_MAX]   = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype the_back[ATTR_MAX]   = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype the_mod[ATTR_MAX]    = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_fore[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_back[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_mod[ATTR_MAX]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_fore[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_back[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_mod[ATTR_MAX]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#endif
 static chtype the_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,A_REVERSE,A_BOLD|A_REVERSE,
               A_BOLD,A_REVERSE,A_BLINK,A_BOLD,
               A_REVERSE,A_BOLD|A_REVERSE,A_BOLD,A_BOLD,
               A_BOLD,A_BOLD,A_BOLD,A_REVERSE,
               A_BOLD,A_BOLD};
 static chtype kedit_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_REVERSE,A_REVERSE|A_BOLD,
               A_NORMAL,A_NORMAL,A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_NORMAL,A_NORMAL,
               A_BOLD,  A_NORMAL,A_NORMAL,A_BOLD,
               A_NORMAL,A_NORMAL};
 static chtype xedit_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_REVERSE,A_BOLD|A_REVERSE,
               A_NORMAL,A_BOLD,  A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_NORMAL,
               A_BOLD,  A_BOLD,  A_NORMAL,A_BOLD,
               A_BOLD,  A_BOLD};

/***********************************************************************/
#ifdef PROTO
short parse_colours(CHARTYPE *attrib,COLOUR_ATTR *pattr,CHARTYPE **rem,bool spare)
#else
short parse_colours(attrib,pattr,rem,spare)
CHARTYPE *attrib;
COLOUR_ATTR *pattr;
CHARTYPE **rem;
bool spare;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 struct attributes
 {
  CHARTYPE *attrib;
  short attrib_min_len;
  chtype actual_attrib;
  chtype colour_modifier;
  bool attrib_modifier;
  bool attrib_allowed_on_mono;
 };
 typedef struct attributes ATTRIBS;
#define NO_ATTRIBS 21
 static ATTRIBS valid_attribs[NO_ATTRIBS] =
 {
  {(CHARTYPE *)"black",3,COLOR_BLACK,0,FALSE,FALSE},
  {(CHARTYPE *)"gray",3,COLOR_BLACK,A_BOLD,FALSE,FALSE},
  {(CHARTYPE *)"grey",3,COLOR_BLACK,A_BOLD,FALSE,FALSE},
  {(CHARTYPE *)"blue",3,COLOR_BLUE,0,FALSE,FALSE},
  {(CHARTYPE *)"green",1,COLOR_GREEN,0,FALSE,FALSE},
  {(CHARTYPE *)"cyan",1,COLOR_CYAN,0,FALSE,FALSE},
  {(CHARTYPE *)"red",3,COLOR_RED,0,FALSE,FALSE},
  {(CHARTYPE *)"magenta",1,COLOR_MAGENTA,0,FALSE,FALSE},
  {(CHARTYPE *)"yellow",1,COLOR_YELLOW,0,FALSE,FALSE},
  {(CHARTYPE *)"brown",1,COLOR_YELLOW,0,FALSE,FALSE},
  {(CHARTYPE *)"white",1,COLOR_WHITE,0,FALSE,FALSE},
  {(CHARTYPE *)"turquoise",1,COLOR_CYAN,0,FALSE,FALSE},
  {(CHARTYPE *)"pink",1,COLOR_MAGENTA,0,FALSE,FALSE},
  {(CHARTYPE *)"normal",3,A_NORMAL,0,TRUE,TRUE},
  {(CHARTYPE *)"blink",3,A_BLINK,0,TRUE,TRUE},
  {(CHARTYPE *)"bold",2,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"bright",3,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"high",1,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"reverse",3,A_REVERSE,0,TRUE,TRUE},
  {(CHARTYPE *)"underline",1,A_UNDERLINE,0,TRUE,TRUE},
  {(CHARTYPE *)",",1,8,0,FALSE,TRUE},
 };
 register short i=0;
 short num_colours=0;
 chtype pairnum=pattr->pair;
 chtype mod=pattr->mod;
 chtype mono=pattr->mono;
 chtype fg=FOREFROMPAIR(pattr->pair);
 chtype bg=BACKFROMPAIR(pattr->pair);
 CHARTYPE *string=NULL;
 CHARTYPE *p=NULL;
 bool found=FALSE;
 bool reverse=FALSE;
 bool spare_pos=FALSE;
 int offset=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commutil.c:parse_colours");
#endif
/*---------------------------------------------------------------------*/
/* Get a copy of the passed string and wreck it rather than the passed */
/* string.                                                             */
/*---------------------------------------------------------------------*/
 if ((string = (CHARTYPE *)my_strdup(attrib)) == NULL)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }

 p = (CHARTYPE *)strtok(string," \b");
 while(p != NULL)
   {
    found = FALSE;
    for (i=0;i<NO_ATTRIBS;i++)
       {
        if (equal(valid_attribs[i].attrib,p,valid_attribs[i].attrib_min_len))
          {
           found = TRUE;
           if (!valid_attribs[i].attrib_allowed_on_mono
           &&  !colour_support)
             {
              display_error(61,(CHARTYPE *)p,FALSE);
              (*the_free)(string);
#ifdef TRACE
              trace_return();
#endif
              return(RC_INVALID_OPERAND);
             }
           if (valid_attribs[i].attrib_modifier)
             {
              if (colour_support)
                {
                 if (valid_attribs[i].actual_attrib == A_REVERSE)
                    reverse = TRUE;
                 else
                    mod = (valid_attribs[i].actual_attrib==A_NORMAL)?A_NORMAL:mod | valid_attribs[i].actual_attrib;
                }
              else
                 mono = (valid_attribs[i].actual_attrib==A_NORMAL)?A_NORMAL:mono | valid_attribs[i].actual_attrib;
              offset += strlen(p) + 1;
              break;
             }
           else
             {
              switch(num_colours)
                {
                 case 0:
                      if (valid_attribs[i].actual_attrib != 8)
                        {
                         fg = valid_attribs[i].actual_attrib;
                         mod |= valid_attribs[i].colour_modifier;
                        } else ;
/*
                      fg = valid_attribs[i].actual_attrib;
                      mod |= valid_attribs[i].colour_modifier;
*/
                      num_colours++;
                      offset += strlen(p) + 1;
                      break;
                 case 1:
                      if (valid_attribs[i].actual_attrib != 8)
                        {
                         bg = valid_attribs[i].actual_attrib;
                         mod |= valid_attribs[i].colour_modifier;
                        } else ;
/*
                      bg = valid_attribs[i].actual_attrib;
                      mod |= valid_attribs[i].colour_modifier;
*/
                      num_colours++;
                      offset += strlen(p) + 1;
                      break;
                 default:
                      if (spare)
                        {
                         spare_pos = TRUE;
                         *rem = (CHARTYPE *)strstr(attrib+offset,p);
                         break;
                        }
                      display_error(1,(CHARTYPE *)p,FALSE);
                      (*the_free)(string);
#ifdef TRACE
                      trace_return();
#endif
                      return(RC_INVALID_OPERAND);
                      break;
                }
              if (spare_pos)
                 break;
             }
           break;
          }
       }
    if (spare_pos && found)
       break;
    if (!found)
      {
       if (spare)
         {
          *rem = (CHARTYPE *)strstr(attrib+offset,p);
          break;
         }
       display_error(1,(CHARTYPE *)p,FALSE);
       (*the_free)(string);
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }
    p = (CHARTYPE *)strtok(NULL," ");
   }
 pattr->pair = (reverse) ? ATTR2PAIR(bg,fg) : ATTR2PAIR(fg,bg);
 pattr->mod = mod;
 pattr->mono = mono;
 (*the_free)(string);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}

/***********************************************************************/
#ifdef PROTO
chtype set_colour(COLOUR_ATTR *attr)
#else
chtype set_colour(attr)
COLOUR_ATTR *attr;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 chtype color=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commutil.c:set_colour");
#endif

 color = attr->mono;
#ifdef A_COLOR
 if (colour_support)
    color = (attr->pair) ? COLOR_PAIR(attr->pair) | attr->mod : attr->mod;
#endif

#if 0
 color = fd->mono[area];
#ifdef A_COLOR
 if (colour_support)
   {
    init_pair(area+1,fd->fg[area],fd->bg[area]);
    color = COLOR_PAIR(area+1) | fd->mod[area];
   }
#endif
#endif

#ifdef TRACE
 trace_return();
#endif
 return(color);
}
/***********************************************************************/
#ifdef PROTO
void set_up_default_colours(FILE_DETAILS *fd)
#else
void set_up_default_colours(fd)
FILE_DETAILS *fd;
#endif
/***********************************************************************/
/* This function is called as part of reading in a new file.           */
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short compatible;
/*--------------------------- local data ------------------------------*/
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_up_default_colours");
#endif
/*---------------------------------------------------------------------*/
/* Set up default colours.                                             */
/*---------------------------------------------------------------------*/
 switch(compatible)
   {
    case COMPAT_THE:
         for (i=0;i<ATTR_MAX;i++)
           {
            fd->attr[i].pair = ATTR2PAIR(the_fore[i],the_back[i]);
            fd->attr[i].mod = the_mod[i];
            fd->attr[i].mono = the_mono[i];
           }
         break;
    case COMPAT_XEDIT:
         for (i=0;i<ATTR_MAX;i++)
           {
            fd->attr[i].pair = ATTR2PAIR(xedit_fore[i],xedit_back[i]);
            fd->attr[i].mod = xedit_mod[i];
            fd->attr[i].mono = xedit_mono[i];
           }
         break;
    case COMPAT_KEDIT:
         for (i=0;i<ATTR_MAX;i++)
           {
            fd->attr[i].pair = ATTR2PAIR(kedit_fore[i],kedit_back[i]);
            fd->attr[i].mod = kedit_mod[i];
            fd->attr[i].mono = kedit_mono[i];
           }
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
