/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: command.h 2.0 1995/01/26 16:30:06 MH Release MH $
*/

struct commands
{
 CHARTYPE *text;
 unsigned short min_len;
 int funkey;
#ifdef PROTO
 short (*function)(CHARTYPE *);
#else
 short (*function)();
#endif
 bool valid_profile_command;
 bool set_command;
 bool sos_command;
 bool strip_param;
 bool valid_in_readonly;
 bool edit_command;
 CHARTYPE *params;
};
typedef struct commands COMMAND;

#include "proto.h"

/*---------------------- *** IMPORTANT *** ----------------------------*/
/* Make sure that there is no chance two or more commands can be       */
/* matched based on number of significant charcters.                   */
/*---------------------- *** IMPORTANT *** ----------------------------*/
/*                                                             Prof / Set / SOS /strip/ RO  /edit / */
COMMAND command[] =
{
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"cursor",      0,  KEY_CURR,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"right"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_CURL,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"left"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_CURD,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"down"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_CURU,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"up"},  /* comm1.c */
#else
 {(CHARTYPE *)"cursor",      0,  KEY_RIGHT,       Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"right"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_LEFT,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"left"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_DOWN,        Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"down"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_UP,          Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"up"},  /* comm1.c */
#endif
 {(CHARTYPE *)"add",         1,  (-1),            Add,         TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"1"}, /* comm1.c */
 {(CHARTYPE *)"all",         3,  (-1),            All,         TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"arbchar",     3,  (-1),            Arbchar,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"autosave",    2,  (-1),            Autosave,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"backward",    2,  KEY_PGUP,        Backward,    TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm1.c */
#else
 {(CHARTYPE *)"backward",    2,  KEY_PPAGE,       Backward,    TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm1.c */
 {(CHARTYPE *)"backward",    2,  KEY_PrevScrn,    Backward,    TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm1.c */
#endif
 {(CHARTYPE *)"backup",      4,  (-1),            Backup,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"beep",        4,  (-1),            BeepSound,   TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"bottom",      3,  (-1),            Bottom,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"cancel",      3,  (-1),            Cancel,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"case",        4,  (-1),            Case,        TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"ccancel",     2,  (-1),            Ccancel,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"change",      1,  (-1),            Change,      TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"clearscreen", 6,  (-1),            Clearscreen, TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"clock",       5,  (-1),            Clock,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"cmatch",      0,  KEY_F7,          Cmatch,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
#else
 {(CHARTYPE *)"cmatch",      0,  KEY_F(7),        Cmatch,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
#endif
 {(CHARTYPE *)"cmdarrows",   4,  (-1),            Cmdarrows,   TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"cmdline",     3,  (-1),            Cmdline,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"cmsg",        4,  (-1),            Cmsg,        FALSE,FALSE,FALSE,FALSE,TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"command",     7,  (-1),            THECommand,  TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"colour",      6,  (-1),            Colour,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"color",       5,  (-1),            Colour,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"compat",      6,  (-1),            Compat,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"copy",        4,  (-1),            Copy,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"control_char",0,  KEY_F12,         Control_char,FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"copy",        0,  KEY_A_c,         Copy,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block reset"},  /* comm1.c */
 {(CHARTYPE *)"copy",        0,  KEY_A_k,         Copy,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      3,  KEY_HOME,        Cursor,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"home save"},  /* comm1.c */
#else
 {(CHARTYPE *)"control_char",0,  KEY_F(6),        Control_char,FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"copy",        0,  KEY_C_c,         Copy,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block reset"},  /* comm1.c */
 {(CHARTYPE *)"copy",        0,  KEY_C_k,         Copy,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      3,  KEY_HOME,        Cursor,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"home save"},  /* comm1.c */
 {(CHARTYPE *)"cursor",      0,  KEY_Do,          Cursor,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"home save"},  /* comm1.c */
#endif
 {(CHARTYPE *)"curline",     4,  (-1),            Curline,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"define",      3,  (-1),            Define,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"delete",      3,  (-1),            DeleteLine,  TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"1"}, /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"delete",      0,  KEY_A_g,         DeleteLine,  FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block"}, /* comm1.c */
#else
 {(CHARTYPE *)"delete",      0,  KEY_C_g,         DeleteLine,  FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block"}, /* comm1.c */
#endif
 {(CHARTYPE *)"directory",   3,  (-1),            Directory,   FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"dirinclude",  4,  (-1),            Dirinclude,  TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"*"}, /* commset1.c */
 {(CHARTYPE *)"ls",          2,  (-1),            Directory,   FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm1.c */
 {(CHARTYPE *)"display",     4,  (-1),            Display,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"down",        1,  (-1),            Next,        TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm3.c */
 {(CHARTYPE *)"duplicate",   3,  (-1),            Duplicate,   TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"duplicate",   0,  KEY_A_d,         Duplicate,   TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"1 BLOCK"},  /* comm2.c */
#else
 {(CHARTYPE *)"duplicate",   0,  KEY_C_d,         Duplicate,   TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"1 BLOCK"},  /* comm2.c */
 {(CHARTYPE *)"enter",       0,  KEY_C_m,         Enter,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"enter",       0,  KEY_ENTER,       Enter,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
#endif
#if defined(USE_EXTCURSES)
 {(CHARTYPE *)"enter",       0,  KEY_NEWL,        Enter,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
#else
 {(CHARTYPE *)"enter",       0,  KEY_RETURN,      Enter,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
#endif
 {(CHARTYPE *)"emsg",        4,  (-1),            Emsg,        TRUE, FALSE,FALSE,FALSE,TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"eolout",      4,  (-1),            Eolout,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"etmode",      6,  (-1),            Etmode,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"expand",      3,  (-1),            Expand,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"extract",     3,  (-1),            Extract,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"ffile",       2,  (-1),            Ffile,       TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"file",        4,  KEY_F3,          File,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"fillbox",     4,  KEY_A_f,         Fillbox,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#else
 {(CHARTYPE *)"file",        4,  KEY_F(3),        File,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"file",        0,  KEY_PF3,         File,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"fillbox",     4,  KEY_C_f,         Fillbox,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#endif
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"forward",     2,  KEY_PGDN,        Forward,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm2.c */
 {(CHARTYPE *)"forward",     2,  KEY_C_PGDN,      Forward,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"*"}, /* comm2.c */
#else
 {(CHARTYPE *)"forward",     2,  KEY_NPAGE,       Forward,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm2.c */
 {(CHARTYPE *)"forward",     2,  KEY_NextScrn,    Forward,     TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm2.c */
#endif
 {(CHARTYPE *)"get",         3,  (-1),            Get,         TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"help",        4,  KEY_F1,          Help,        FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
#else
 {(CHARTYPE *)"help",        4,  KEY_F(1),        Help,        FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
 {(CHARTYPE *)"help",        0,  KEY_PF1,         Help,        FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm2.c */
#endif
 {(CHARTYPE *)"hex",         3,  (-1),            Hex,         TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"hexdisplay",  7,  (-1),            Hexdisplay,  TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"hexshow",     4,  (-1),            Hexshow,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"idline",      2,  (-1),            Idline,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"impmacro",    5,  (-1),            Impmacro,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"impos",       5,  (-1),            Impos,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"impcmscp",    3,  (-1),            Impos,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"input",       1,  (-1),            Input,       TRUE, FALSE,FALSE,FALSE,FALSE,FALSE,(CHARTYPE *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"insertmode",  7,  KEY_INS,         Insertmode,  TRUE, TRUE, FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"toggle"},  /* commset1.c */
 {(CHARTYPE *)"locate",      1,  KEY_S_F1,        Locate,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
#else
 {(CHARTYPE *)"insertmode",  7,  KEY_IC,          Insertmode,  TRUE, TRUE, FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"toggle"},  /* commset1.c */
 {(CHARTYPE *)"locate",      1,  KEY_F(11),       Locate,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
#endif
 {(CHARTYPE *)"left",        2,  (-1),            Left,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"linend",      5,  (-1),            Linend,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"lowercase",   3,  (-1),            Lowercase,   TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"macro",       5,  (-1),            Macro,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"macroext",    6,  (-1),            Macroext,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"macropath",   6,  (-1),            Macropath,   TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"margins",     3,  (-1),            Margins,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"mark",        4,  (-1),            Mark,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"modify",      3,  (-1),            Modify,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"mark",        0,  KEY_A_l,         Mark,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"line"},  /* comm3.c */
 {(CHARTYPE *)"mark",        0,  KEY_A_b,         Mark,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"box"},  /* comm3.c */
 {(CHARTYPE *)"move",        4,  KEY_A_m,         THEMove,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block reset"},  /* comm3.c */
 {(CHARTYPE *)"nextwindow",  5,  KEY_F2,          Nextwindow,  FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""}, /* comm3.c */
 {(CHARTYPE *)"overlaybox",  8,  KEY_A_o,         Overlaybox,  FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""}, /* comm3.c */
#else
 {(CHARTYPE *)"mark",        0,  KEY_C_l,         Mark,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"line"},  /* comm3.c */
 {(CHARTYPE *)"mark",        0,  KEY_C_b,         Mark,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"box"},  /* comm3.c */
 {(CHARTYPE *)"move",        4,  KEY_C_v,         THEMove,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"block reset"},  /* comm3.c */
 {(CHARTYPE *)"nextwindow",  5,  KEY_F(2),        Nextwindow,  FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"nextwindow",  5,  KEY_PF2,         Nextwindow,  FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"overlaybox",  8,  KEY_C_o,         Overlaybox,  FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm3.c */
#endif
 {(CHARTYPE *)"msg",         3,  (-1),            Msg,         TRUE, FALSE,FALSE,FALSE,TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"msgline",     4,  (-1),            Msgline,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"msgmode",     4,  (-1),            Msgmode,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"newlines",    4,  (-1),            Newlines,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"next",        1,  (-1),            Next,        TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm3.c */
 {(CHARTYPE *)"nomsg",       5,  (-1),            Nomsg,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"nondisp",     4,  (-1),            Nondisp,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset1.c */
 {(CHARTYPE *)"nop",         3,  (-1),            Nop,         FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"number",      3,  (-1),            Number,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"osnowait",    3,  (-1),            Osnowait,    FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"osquiet",     3,  (-1),            Osquiet,     FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"os",          2,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"dosnowait",   4,  (-1),            Osnowait,    FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"dosquiet",    4,  (-1),            Osquiet,     FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"dos",         3,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"!",           1,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm3.c */
 {(CHARTYPE *)"pending",     4,  (-1),            Pending,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"point",       1,  (-1),            Point,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"point",       0,  KEY_C_F11,       Point,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)".a"},/* commset2.c */
 {(CHARTYPE *)"locate",      0,  KEY_C_F12,       Locate,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)".a"},/* commset2.c */
#else
 {(CHARTYPE *)"point",       0,  KEY_F(31),       Point,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)".a"},/* commset2.c */
 {(CHARTYPE *)"locate",      0,  KEY_F(32),       Locate,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)".a"},/* commset2.c */
#endif
 {(CHARTYPE *)"position",    3,  (-1),            Position,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"prefix",      3,  (-1),            Prefix,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"printer",     7,  (-1),            THEPrinter,  TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"print",       2,  (-1),            Print,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"put",         3,  (-1),            Put,         TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"putd",        4,  (-1),            Putd,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"qquit",       2,  KEY_S_F3,        Qquit,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
#else
 {(CHARTYPE *)"qquit",       2,  KEY_F(13),       Qquit,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
#endif
 {(CHARTYPE *)"quit",        4,  (-1),            Quit,        TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"query",       1,  (-1),            Query,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"recover",     3,  KEY_F8,          Recover,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
#else
 {(CHARTYPE *)"recover",     3,  KEY_F(8),        Recover,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
#endif
 {(CHARTYPE *)"readv",       5,  (-1),            Readv,       TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"redraw",      6,  KEY_C_r,         Redraw,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"refresh",     7,  (-1),            THERefresh,  FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"repeat",      4,  (-1),            Repeat,      TRUE, FALSE,FALSE,FALSE,FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"replace",     1,  (-1),            Replace,     TRUE, FALSE,FALSE,FALSE,FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"reprofile",   6,  (-1),            Reprofile,   TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"reserved",    5,  (-1),            Reserved,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"reset",       3,  (-1),            Reset,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"reset",       0,  KEY_A_u,         Reset,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"block"},  /* comm4.c */
#else
 {(CHARTYPE *)"reset",       0,  KEY_C_u,         Reset,       FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"block"},  /* comm4.c */
#endif
 {(CHARTYPE *)"rexxoutput",  7,  (-1),            Rexxoutput,  TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"rgtleft",     7,  (-1),            Rgtleft,     TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"right",       2,  (-1),            Right,       TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"=",           1,  (-1),            Reexecute,   TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"?",           1,  (-1),            Retrieve,    FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"save",        4,  (-1),            Save,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"scale",       5,  (-1),            Scale,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"schange",     3,  (-1),            Schange,     FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"screen",      3,  (-1),            THEScreen,   FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"scope",       5,  (-1),            Scope,       TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"select",      3,  (-1),            Select,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"set",         3,  (-1),            Set,         TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"shadow",      4,  (-1),            Shadow,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"shift",       2,  (-1),            Shift,       TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"showkey",     4,  (-1),            ShowKey,     FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"sort",        4,  (-1),            Sort,        TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"sos",         3,  (-1),            Sos,         FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"bottomedge",  7,  (-1),            Sos_bottomedge,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"current",     4,  (-1),            Sos_current, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"endchar",     4,  (-1),            Sos_endchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"execute",     2,  (-1),            Sos_execute, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"firstchar",   7,  (-1),            Sos_firstchar,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"firstcol",    7,  (-1),            Sos_firstcol,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"lastcol",     6,  (-1),            Sos_lastcol, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"leftedge",    5,  (-1),            Sos_leftedge,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"marginl",     7,  (-1),            Sos_marginl, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"marginr",     7,  (-1),            Sos_marginr, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"parindent",   6,  (-1),            Sos_parindent,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"prefix",      3,  (-1),            Sos_prefix,  FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"qcmnd",       2,  (-1),            Sos_qcmnd,   FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"rightedge",   6,  (-1),            Sos_rightedge,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabfieldb",   9,  (-1),            Sos_tabfieldb,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabfieldf",   8,  (-1),            Sos_tabfieldf,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"topedge",     4,  (-1),            Sos_topedge,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"cursoradj",   7,  KEY_C_a,         Sos_cursoradj,FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"addline",     3,  KEY_F4,          Sos_addline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delback",     5,  KEY_BKSP,        Sos_delback, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  KEY_DEL,         Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delend",      4,  KEY_C_END,       Sos_delend,  FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delline",     4,  KEY_F9,          Sos_delline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delword",     4,  KEY_A_w,         Sos_delword, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"doprefix",    5,  KEY_NUMENTER,    Sos_doprefix,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"edit",        4,  KEY_A_x,         Sos_edit,    FALSE,FALSE,TRUE, TRUE, TRUE,TRUE,  (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"startendchar",9,  KEY_END,         Sos_startendchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"makecurr",    8,  KEY_F5,          Sos_makecurr,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabb",        4,  KEY_S_TAB,       Sos_tabb,    FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabf",        3,  KEY_TAB,         Sos_tabf,    FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabwordb",    8,  KEY_C_CURL,      Sos_tabwordb,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabwordf",    7,  KEY_C_CURR,      Sos_tabwordf,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"undo",        4,  KEY_ESC,         Sos_undo,    FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"split",       2,  KEY_A_s,         Split,       FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"aligned"},  /* comm4.c */
 {(CHARTYPE *)"join",        1,  KEY_A_j,         Join,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"aligned"},  /* comm2.c */
 {(CHARTYPE *)"spltjoin",    8,  KEY_F10,         Spltjoin,    FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
#else
 {(CHARTYPE *)"addline",     3,  KEY_F(4),        Sos_addline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"addline",     3,  KEY_PF4,         Sos_addline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabb",        4,  (-1),            Sos_tabb,    FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#ifdef OLD_DELBACK_DELCHAR
 {(CHARTYPE *)"delback",     4,  127,             Sos_delback, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  8,               Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  KEY_DC,          Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#else
 {(CHARTYPE *)"delback",     4,  KEY_C_h,         Sos_delback, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delback",     4,  KEY_BACKSPACE,   Sos_delback, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  Del,             Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  127,             Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delchar",     4,  KEY_DC,          Sos_delchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#endif
 {(CHARTYPE *)"delend",      4,  KEY_C_e,         Sos_delend,  FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delline",     4,  KEY_F(9),        Sos_delline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"delword",     4,  KEY_C_w,         Sos_delword, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"doprefix",    5,  KEY_C_p,         Sos_doprefix,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"edit",        4,  KEY_C_x,         Sos_edit,    FALSE,FALSE,TRUE, TRUE, TRUE,TRUE,  (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"startendchar",9,  KEY_F(20),       Sos_startendchar, FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"makecurr",    8,  KEY_F(5),        Sos_makecurr,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#if defined(USE_EXTCURSES)
 {(CHARTYPE *)"tabf",        3,  KEY_TAB,         Sos_tabf,    FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#else
 {(CHARTYPE *)"tabf",        3,  KEY_C_i,         Sos_tabf,    FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
#endif
 {(CHARTYPE *)"tabwordb",    8,  KEY_F(18),       Sos_tabwordb,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"tabwordf",    7,  KEY_F(19),       Sos_tabwordf,FALSE,FALSE,TRUE, TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"undo",        4,  KEY_C_q,         Sos_undo,    FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"split",       2,  KEY_C_s,         Split,       FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"aligned"},  /* comm4.c */
 {(CHARTYPE *)"join",        1,  KEY_C_j,         Join,        FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)"aligned"},  /* comm2.c */
 {(CHARTYPE *)"spltjoin",    8,  KEY_F(10),       Spltjoin,    FALSE,FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
#endif
 {(CHARTYPE *)"lineadd",     5,  (-1),            Sos_addline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"linedel",     5,  (-1),            Sos_delline, FALSE,FALSE,TRUE, TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commsos.c */
 {(CHARTYPE *)"ssave",       2,  (-1),            Ssave,       TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"status",      4,  (-1),            Status,      TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
 {(CHARTYPE *)"statusline",  7,  (-1),            Statusline,  TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"stay",        4,  (-1),            Stay,        TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"synonym",     3,  (-1),            Synonym,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"suspend",     4,  KEY_C_z,         Suspend,     FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"tabpre",      0,  KEY_NUMPLUS,     Tabpre,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
#else
 {(CHARTYPE *)"tabpre",      0,  KEY_F(12),       Tabpre,      FALSE,FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
#endif
 {(CHARTYPE *)"tabline",     4,  (-1),            Tabline,     TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"tabkey",      4,  (-1),            Tabkey,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"tabs",        4,  (-1),            Tabs,        TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"tabsin",      5,  (-1),            Tabsin,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"tabsout",     5,  (-1),            Tabsout,     TRUE, TRUE, FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"text",        4,  (-1),            Text,        FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,(CHARTYPE *)""},  /* comm5.c */
#if defined(DOS) || defined(OS2)
 {(CHARTYPE *)"top",         3,  KEY_C_PGUP,      Top,         TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
#else
 {(CHARTYPE *)"top",         3,  (-1),            Top,         TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* comm5.c */
#endif
 {(CHARTYPE *)"typeahead",   5,  (-1),            THETypeahead,TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"up",          1,  (-1),            Up,          TRUE, FALSE,FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)"1"}, /* comm5.c */
 {(CHARTYPE *)"uppercase",   3,  (-1),            Uppercase,   TRUE, FALSE,FALSE,TRUE, FALSE,FALSE,(CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"wordwrap",    5,  (-1),            Wordwrap,    TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"edit",        1,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, TRUE,TRUE,  (CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"xedit",       1,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, TRUE,TRUE,  (CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"the",         3,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, TRUE,TRUE,  (CHARTYPE *)""},  /* comm5.c */
 {(CHARTYPE *)"verify",      1,  (-1),            Verify,      TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {(CHARTYPE *)"zone",        1,  (-1),            Zone,        TRUE, TRUE, FALSE,TRUE, TRUE,FALSE, (CHARTYPE *)""},  /* commset2.c */
 {NULL,                      0,  (-1),            NULL,        FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,(CHARTYPE *)""}
};
