/***********************************************************************/
/* DEFAULT.C - Default settings and profile processing                 */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: default.c 2.0 1995/01/26 16:30:32 MH Release MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

/*#define DEBUG 1*/
/*--------------------------- global data -----------------------------*/
 bool BEEPx;
 bool CAPREXXOUTx;
 LINETYPE CAPREXXMAXx;
 bool CLEARSCREENx;
 bool CLOCKx;
 CHARTYPE CMDARROWSTABCMDx;
 CHARTYPE EOLx;
 bool ETMODEx;
 bool HEXDISPLAYx;
 bool INSERTMODEx;
 bool LINEND_STATUSx; /* not really global, but used in command_line() */
 CHARTYPE LINEND_VALUEx; /* not really global, but used in command_line() */
 CHARTYPE NONDISPx; 
 CHARTYPE PREFIXx;/* not really global but used in set_screen_defaults() */
 bool REPROFILEx;
 CHARTYPE TABI_ONx;
 CHARTYPE TABI_Nx;
 ROWTYPE STATUSLINEx;
 bool scroll_cursor_stay;   /* determine how page scrolling is handled */

/***********************************************************************/
#ifdef PROTO
void set_global_defaults(void)
#else
void set_global_defaults()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short compatible;
 extern short prefix_width;
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_global_defaults");
#endif
/*---------------------------------------------------------------------*/
/* Set defaults for all environments first...                          */
/*---------------------------------------------------------------------*/
 BEEPx = FALSE;
 CAPREXXOUTx = FALSE;
 CAPREXXMAXx = 1000L;
#if defined(DOS) || defined(OS2)
 ETMODEx=TRUE;
#else
 ETMODEx=FALSE;
#endif
 INSERTMODEx = FALSE;
 LINEND_VALUEx = '#';
 REPROFILEx = FALSE;
 TABI_ONx = FALSE;
 TABI_Nx = 8;
#ifdef UNIX
 EOLx = EOLOUT_LF;
#endif
#if defined(DOS) || defined(OS2)
 EOLx = EOLOUT_CRLF;
#endif
 STATUSLINEx = 'B';
/*---------------------------------------------------------------------*/
/* Set defaults for individual environments next...                    */
/*---------------------------------------------------------------------*/
 switch(compatible)
   {
    case COMPAT_THE:
         CLEARSCREENx = FALSE;
         CLOCKx = TRUE;
         CMDARROWSTABCMDx = FALSE;
         HEXDISPLAYx = TRUE;
         PREFIXx = PREFIX_ON|PREFIX_LEFT;
         prefix_width = PREFIX_WIDTH;
         LINEND_STATUSx = FALSE;
         NONDISPx = '#';
         scroll_cursor_stay = FALSE;
         break;
    case COMPAT_KEDIT:
         CLEARSCREENx = TRUE;
         CLOCKx = TRUE;
         CMDARROWSTABCMDx = TRUE;
         HEXDISPLAYx = FALSE;
         LINEND_STATUSx = FALSE;
         NONDISPx = '#';
         PREFIXx = PREFIX_OFF;
         prefix_width = PREFIX_WIDTH-1;
         scroll_cursor_stay = TRUE;
         break;
    case COMPAT_XEDIT:
         CLEARSCREENx = TRUE;
         CLOCKx = FALSE;
         CMDARROWSTABCMDx = TRUE;
         HEXDISPLAYx = FALSE;
         LINEND_STATUSx = TRUE;
         NONDISPx = '"';
         PREFIXx = PREFIX_ON|PREFIX_LEFT;
         prefix_width = PREFIX_WIDTH-1;
         scroll_cursor_stay = TRUE;
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void set_file_defaults(FILE_DETAILS *filep)
#else
void set_file_defaults(filep)
FILE_DETAILS *filep;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short compatible;
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_file_defaults");
#endif
/*---------------------------------------------------------------------*/
/* Set defaults for all environments first...                          */
/*---------------------------------------------------------------------*/
 filep->autosave = 0;
 filep->autosave_alt = 0;
 filep->save_alt = 0;
 filep->tabsout_on = FALSE;
 filep->tabsout_num =  8;
 filep->eolout = EOLx;
 set_up_default_colours(filep);
/*---------------------------------------------------------------------*/
/* Set defaults for individual environments next...                    */
/*---------------------------------------------------------------------*/
 switch(compatible)
   {
    case COMPAT_THE:
         filep->backup = BACKUP_KEEP;
         break;
    case COMPAT_XEDIT:
         filep->backup = BACKUP_OFF;
         break;
    case COMPAT_KEDIT:
         filep->backup = BACKUP_OFF;
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void set_view_defaults(VIEW_DETAILS *viewp)
#else
void set_view_defaults(viewp)
VIEW_DETAILS *viewp;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short compatible;
/*--------------------------- local data ------------------------------*/
 register int i=0;
 short tabinc=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_view_defaults");
#endif
/*---------------------------------------------------------------------*/
/* Set defaults for all environments first...                          */
/*---------------------------------------------------------------------*/
 viewp->arbchar_status =        FALSE;
 viewp->arbchar_single =        '?';
 viewp->arbchar_multiple =      '$';
 viewp->case_locate = CASE_IGNORE;
 viewp->case_change = CASE_RESPECT;
 viewp->case_sort = CASE_RESPECT;
 viewp->cmd_line = 'B';
 viewp->id_line = TRUE;
 viewp->current_row = 6;
 viewp->display_high = 0;
 viewp->display_low = 0;
 viewp->hex = FALSE;
 viewp->margin_left = 1;
 viewp->margin_right = 72;
 viewp->margin_indent = 0;
 viewp->margin_indent_offset = TRUE;
 viewp->msgmode_status = TRUE;
 viewp->position_status = TRUE;
 viewp->newline_aligned = TRUE;
 viewp->scale_base = POSITION_MIDDLE;
 viewp->scale_off = 1;
 viewp->scope_all = FALSE;
 viewp->shadow = TRUE;
 viewp->tab_base = POSITION_BOTTOM;
 viewp->tab_on = FALSE;
 viewp->numtabs = 32;
 viewp->verify_start = 1;
 viewp->verify_col = 1;
 viewp->verify_end = max_line_length;
 viewp->hexshow_on = FALSE;
 viewp->hexshow_base = POSITION_TOP;
 viewp->hexshow_off = 7;
 viewp->wordwrap = FALSE;
 viewp->zone_start = 1;
 viewp->zone_end = max_line_length;

 if (viewp->cmd_line == 'O')
   {
    viewp->current_window =     WINDOW_MAIN;
    viewp->previous_window =    WINDOW_MAIN;
   }
 else
   {
    viewp->current_window =        WINDOW_COMMAND;
    viewp->previous_window =       WINDOW_MAIN;
   }
/*---------------------------------------------------------------------*/
/* Set defaults for individual environments next...                    */
/*---------------------------------------------------------------------*/
 switch(compatible)
   {
    case COMPAT_THE:
         viewp->case_enter = CASE_MIXED;
         viewp->current_base = POSITION_TOP;
         viewp->current_off = viewp->current_row;
         viewp->imp_macro = TRUE;
         viewp->imp_os = TRUE;
         viewp->linend_status = FALSE;
         viewp->linend_value = '#';
         viewp->number = TRUE;
         viewp->prefix = PREFIX_ON|PREFIX_LEFT;
         viewp->scale_on = FALSE;
         viewp->stay = TRUE;
         viewp->tab_off = (-3);
         viewp->msgline_base = POSITION_TOP;
         viewp->msgline_off = 2;
         viewp->msgline_rows = 1;
         tabinc = 8;
         break;
    case COMPAT_XEDIT:
         viewp->case_enter = CASE_UPPER;
         viewp->current_base = POSITION_MIDDLE;
         viewp->current_off = 0;
         viewp->imp_macro = TRUE;
         viewp->imp_os = TRUE;
         viewp->linend_status = TRUE;
         viewp->linend_value = '#';
         viewp->number = FALSE;
         viewp->prefix = PREFIX_ON|PREFIX_LEFT;
         viewp->scale_on = TRUE;
         viewp->stay = FALSE;
         viewp->tab_off = (-3);
         viewp->msgline_base = POSITION_TOP;
         viewp->msgline_off = 2;
         viewp->msgline_rows = 8;
         tabinc = 3;
         break;
    case COMPAT_KEDIT:
         viewp->case_enter = CASE_MIXED;
         viewp->current_base = POSITION_MIDDLE;
         viewp->current_off = 0;
         viewp->imp_macro = FALSE;
         viewp->imp_os = FALSE;
         viewp->linend_status = FALSE;
         viewp->linend_value = '#';
         viewp->number = FALSE;
         viewp->prefix = PREFIX_OFF;
         viewp->scale_on = FALSE;
         viewp->stay = TRUE;
         viewp->tab_off = (-2);
         viewp->msgline_base = POSITION_TOP;
         viewp->msgline_off = 2;
         viewp->msgline_rows = 5;
         tabinc = 8;
         break;
   }
 for (i=0;i<MAX_NUMTABS;i++)
     viewp->tabs[i] = 1 + (i*tabinc);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
short get_profile(CHARTYPE *prf_arg)
#else
short get_profile(prf_arg)
CHARTYPE *prf_arg;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool in_profile;
 extern bool in_macro;
 extern CHARTYPE the_profile_file[MAX_FILE_NAME+1];
 extern bool profile_specified;
 extern bool rexx_support;
/*--------------------------- local data ------------------------------*/
 FILE *fp;
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: get_profile");
#endif
/*---------------------------------------------------------------------*/
/* Check to see if the profile file exists and is readable. If the file*/
/* does not exists or is not readable, return. If a profile file was   */
/* explicitly specified, display an error if it doesn't exist. If the  */
/* file is not readable, whether we specified it or not, display error.*/
/*---------------------------------------------------------------------*/
 if (!file_exists(the_profile_file))
   {
    if (profile_specified)
       display_error(9,the_profile_file,FALSE);
#ifdef TRACE
    trace_return();
#endif
    return(RC_FILE_NOT_FOUND);
   }
/*---------------------------------------------------------------------*/
/* If the file is not readable, error.                                 */
/*---------------------------------------------------------------------*/
 if (!file_readable(the_profile_file))
   {
    display_error(8,the_profile_file,FALSE);
#ifdef TRACE
    trace_return();
#endif
    return(RC_ACCESS_DENIED);
   }
/*---------------------------------------------------------------------*/
/* To get here, we either have a specified a valid profile name or we  */
/* haven't specified a profile file at all.                            */
/*---------------------------------------------------------------------*/
 in_macro = TRUE;
/*---------------------------------------------------------------------*/
/* If REXX is supported, process the macro as a REXX macro...          */
/*---------------------------------------------------------------------*/
 if (rexx_support)
   {
    post_process_line(CURRENT_VIEW,CURRENT_VIEW->focus_line);
    rc = execute_macro_file(the_profile_file,prf_arg);
    if (rc != RC_OK)
      {
       display_error(54,(CHARTYPE *)"",FALSE);
       rc = RC_SYSTEM_ERROR;
      }
   }
 else
   {
/*---------------------------------------------------------------------*/
/* ...otherwise, process the file as a non-REXX macro file...          */
/*---------------------------------------------------------------------*/
    if ((fp = fopen(the_profile_file,"r")) == NULL)
      {
       rc = RC_ACCESS_DENIED;
       display_error(8,the_profile_file,FALSE);
      }
    post_process_line(CURRENT_VIEW,CURRENT_VIEW->focus_line);
    if (rc == RC_OK)
      {
       rc = execute_command_file(fp);
       fclose(fp);
      }
    if (rc == RC_SYSTEM_ERROR)
       display_error(53,"",FALSE);
   }
 in_macro = FALSE;

#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_first_file(void)
#else
short defaults_for_first_file()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern VIEW_DETAILS *vd_first;
 extern CHARTYPE number_of_views;
/*--------------------------- local data ------------------------------*/
 register int i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_first_file");
#endif
/*---------------------------------------------------------------------*/
/* Add to view linked list.                                            */
/*---------------------------------------------------------------------*/
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 set_view_defaults(CURRENT_VIEW);

 CURRENT_VIEW->mark_type = 0;
 CURRENT_VIEW->marked_line = FALSE;
 CURRENT_VIEW->marked_col = FALSE;
 CURRENT_VIEW->mark_start_line = 0;
 CURRENT_VIEW->mark_end_line = 0;
 CURRENT_VIEW->mark_start_col = 0;
 CURRENT_VIEW->mark_end_col = 0;
 CURRENT_VIEW->focus_line = 0L;
 CURRENT_VIEW->current_line = 0L;
 CURRENT_VIEW->current_column = 0;
 for (i=0;i<VIEW_WINDOWS;i++)
    CURRENT_VIEW->x[i] = CURRENT_VIEW->y[i] = 0;

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;
 if (CURRENT_VIEW->cmd_line == 'O')
   {
    CURRENT_VIEW->current_window =     WINDOW_MAIN;
    CURRENT_VIEW->previous_window =    WINDOW_MAIN;
   }
 else
   {
    CURRENT_VIEW->current_window =        WINDOW_COMMAND;
    CURRENT_VIEW->previous_window =       WINDOW_MAIN;
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_other_files(bool same_file)
#else
short defaults_for_other_files(same_file)
bool same_file;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern VIEW_DETAILS *vd_first;
 extern CHARTYPE number_of_views;
/*--------------------------- local data ------------------------------*/
 register int i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_other_files");
#endif
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 if (same_file)
   {
    CURRENT_VIEW->current_line =    PREVIOUS_VIEW->current_line;
    CURRENT_VIEW->current_column =  PREVIOUS_VIEW->current_column;
    CURRENT_VIEW->display_high =    PREVIOUS_VIEW->display_high;
    CURRENT_VIEW->display_low =     PREVIOUS_VIEW->display_low;
    CURRENT_VIEW->hex =             PREVIOUS_VIEW->hex;
    CURRENT_VIEW->newline_aligned = PREVIOUS_VIEW->newline_aligned;
    CURRENT_VIEW->scope_all =       PREVIOUS_VIEW->scope_all;
    CURRENT_VIEW->shadow =          PREVIOUS_VIEW->shadow;
    CURRENT_VIEW->stay =            PREVIOUS_VIEW->stay;
    CURRENT_VIEW->hexshow_on =      PREVIOUS_VIEW->hexshow_on;
    CURRENT_VIEW->hexshow_base =    PREVIOUS_VIEW->hexshow_base;
    CURRENT_VIEW->hexshow_off =     PREVIOUS_VIEW->hexshow_off;
    CURRENT_VIEW->verify_start =    PREVIOUS_VIEW->verify_start;
    CURRENT_VIEW->verify_col =      PREVIOUS_VIEW->verify_col;
    CURRENT_VIEW->verify_end =      PREVIOUS_VIEW->verify_end;
    CURRENT_VIEW->zone_start =      PREVIOUS_VIEW->zone_start;
    CURRENT_VIEW->zone_end =        PREVIOUS_VIEW->zone_end;
    
    for (i=0;i<VIEW_WINDOWS;i++)
      {
       CURRENT_VIEW->y[i] = PREVIOUS_VIEW->y[i];
       CURRENT_VIEW->x[i] = PREVIOUS_VIEW->x[i];
      }

    CURRENT_VIEW->focus_line =      PREVIOUS_VIEW->focus_line;
    CURRENT_VIEW->mark_type =       PREVIOUS_VIEW->mark_type;
    CURRENT_VIEW->marked_line =     PREVIOUS_VIEW->marked_line;
    CURRENT_VIEW->marked_col =      PREVIOUS_VIEW->marked_col;
    CURRENT_VIEW->mark_start_line = PREVIOUS_VIEW->mark_start_line;
    CURRENT_VIEW->mark_end_line =   PREVIOUS_VIEW->mark_end_line;
    CURRENT_VIEW->mark_start_col =  PREVIOUS_VIEW->mark_start_col;
    CURRENT_VIEW->mark_end_col =    PREVIOUS_VIEW->mark_end_col;
   }
 else
   {
    set_view_defaults(CURRENT_VIEW);
    CURRENT_VIEW->focus_line = 0L;
    CURRENT_VIEW->current_line = 0L;
    CURRENT_VIEW->current_column = 0;
    CURRENT_VIEW->mark_type = 0;
    CURRENT_VIEW->marked_line = FALSE;
    CURRENT_VIEW->marked_col = FALSE;
    CURRENT_VIEW->mark_start_line = 0;
    CURRENT_VIEW->mark_end_line = 0;
    CURRENT_VIEW->mark_start_col = 0;
    CURRENT_VIEW->mark_end_col = 0;
    for (i=0;i<VIEW_WINDOWS;i++)
      {
       CURRENT_VIEW->y[i] = CURRENT_VIEW->x[i] = 0;
      }
   }

 CURRENT_VIEW->arbchar_status =  PREVIOUS_VIEW->arbchar_status;
 CURRENT_VIEW->arbchar_single =  PREVIOUS_VIEW->arbchar_single;
 CURRENT_VIEW->arbchar_multiple= PREVIOUS_VIEW->arbchar_multiple;
 CURRENT_VIEW->case_enter =      PREVIOUS_VIEW->case_enter;
 CURRENT_VIEW->case_locate =     PREVIOUS_VIEW->case_locate;
 CURRENT_VIEW->case_change =     PREVIOUS_VIEW->case_change;
 CURRENT_VIEW->case_sort =       PREVIOUS_VIEW->case_sort;
 CURRENT_VIEW->cmd_line =        PREVIOUS_VIEW->cmd_line;
 CURRENT_VIEW->id_line =         PREVIOUS_VIEW->id_line;
 CURRENT_VIEW->current_base =    PREVIOUS_VIEW->current_base;
 CURRENT_VIEW->current_off =     PREVIOUS_VIEW->current_off;
 CURRENT_VIEW->current_row =     PREVIOUS_VIEW->current_row;
 CURRENT_VIEW->imp_macro =       PREVIOUS_VIEW->imp_macro;
 CURRENT_VIEW->imp_os =          PREVIOUS_VIEW->imp_os;
 CURRENT_VIEW->linend_status =   PREVIOUS_VIEW->linend_status;
 CURRENT_VIEW->linend_value =    PREVIOUS_VIEW->linend_value;
 CURRENT_VIEW->margin_left =     PREVIOUS_VIEW->margin_left;
 CURRENT_VIEW->margin_right =    PREVIOUS_VIEW->margin_right;
 CURRENT_VIEW->margin_indent =   PREVIOUS_VIEW->margin_indent;
 CURRENT_VIEW->margin_indent_offset = PREVIOUS_VIEW->margin_indent_offset;
 CURRENT_VIEW->msgmode_status =  PREVIOUS_VIEW->msgmode_status;
 CURRENT_VIEW->position_status = PREVIOUS_VIEW->position_status;
 CURRENT_VIEW->msgline_base =    PREVIOUS_VIEW->msgline_base;
 CURRENT_VIEW->msgline_off =     PREVIOUS_VIEW->msgline_off;
 CURRENT_VIEW->msgline_rows =    PREVIOUS_VIEW->msgline_rows;
 CURRENT_VIEW->number =          PREVIOUS_VIEW->number;
 CURRENT_VIEW->prefix =          PREVIOUS_VIEW->prefix;
 CURRENT_VIEW->scale_base =      PREVIOUS_VIEW->scale_base;
 CURRENT_VIEW->scale_off =       PREVIOUS_VIEW->scale_off;
 CURRENT_VIEW->scale_on =        PREVIOUS_VIEW->scale_on;
 CURRENT_VIEW->tab_base =        PREVIOUS_VIEW->tab_base;
 CURRENT_VIEW->tab_off =         PREVIOUS_VIEW->tab_off;
 CURRENT_VIEW->tab_on =          PREVIOUS_VIEW->tab_on;
 CURRENT_VIEW->wordwrap =        PREVIOUS_VIEW->wordwrap;
 CURRENT_VIEW->numtabs =         PREVIOUS_VIEW->numtabs;
 memcpy(CURRENT_VIEW->tabs,PREVIOUS_VIEW->tabs,MAX_NUMTABS*sizeof(LENGTHTYPE));

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;
 if (CURRENT_VIEW->cmd_line == 'O')
   {
    CURRENT_VIEW->current_window =     WINDOW_MAIN;
    CURRENT_VIEW->previous_window =    WINDOW_MAIN;
   }
 else
   {
    CURRENT_VIEW->current_window =        WINDOW_COMMAND;
    CURRENT_VIEW->previous_window =       WINDOW_MAIN;
   }

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef PROTO
short default_file_attributes(FILE_DETAILS *fd)
#else
short default_file_attributes(fd)
FILE_DETAILS *fd;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
/*--------------------------- local data ------------------------------*/
 RESERVED *curr=NULL;
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: default_file_attributes");
#endif

 set_file_defaults(CURRENT_FILE);

 CURRENT_FILE->fname =           (CHARTYPE *)NULL;
 CURRENT_FILE->fpath =           (CHARTYPE *)NULL;
 CURRENT_FILE->file_views =      1;
 CURRENT_FILE->first_line =      (LINE *)NULL;
 CURRENT_FILE->last_line =       (LINE *)NULL;
 CURRENT_FILE->first_reserved  = (RESERVED *)NULL;
 CURRENT_FILE->fmode =           FMODE;
 CURRENT_FILE->pseudo_file =     PSEUDO_REAL;
 CURRENT_FILE->first_ppc = CURRENT_FILE->last_ppc = NULL;
/*---------------------------------------------------------------------*/
/* Set defaults for the current file based on the settings for the     */
/* previous file. The defaults to copy are:                            */
/* - colours, reserved lines.                                          */
/*---------------------------------------------------------------------*/
 if (fd != NULL)
   {
    memcpy(CURRENT_FILE->attr,fd->attr,ATTR_MAX*sizeof(COLOUR_ATTR));
    curr = fd->first_reserved;
    while(curr!=NULL)
      {
       rc = add_reserved_line(curr->spec,curr->line,curr->base,curr->off,
                        curr->attr);
       if (rc != RC_OK)
          break;
       curr = curr->next;
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
void set_screen_defaults(void)
#else
void set_screen_defaults()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern CHARTYPE display_screens;
 extern bool horizontal;
/*--------------------------- local data ------------------------------*/
 register int i=0;
 register int j=0;
 ROWTYPE cmdline=0;
 CHARTYPE prefix=0;
 ROWTYPE start_row=0,number_rows_less=0,idline_rows;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_screen_defaults");
#endif
/*---------------------------------------------------------------------*/
/* Set values that affect the placement of each screen depending on    */
/* the position of the status line...                                  */
/*---------------------------------------------------------------------*/
 switch(STATUSLINEx)
   {
    case 'B':
         start_row = 0;
         number_rows_less = 1;
         break;
    case 'T':
         start_row = 1;
         number_rows_less = 1;
         break;
    case 'O':
    case 'G':
         start_row = 0;
         number_rows_less = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* Determine size of overall screen dimensions...                      */
/*---------------------------------------------------------------------*/
 if (horizontal)
   {
    screen[0].screen_rows = (LINES - number_rows_less) / display_screens;
    screen[0].screen_cols = COLS;
    screen[0].screen_start_row = start_row;
    screen[0].screen_start_col = 0;
    if (display_screens == 1)
      {
       screen[1].screen_rows = 0;
       screen[1].screen_cols = 0;
       screen[1].screen_start_row = 0;
       screen[1].screen_start_col = 0;
      }
    else
      {
       screen[1].screen_rows = (LINES - number_rows_less) - screen[0].screen_rows;
       screen[1].screen_cols = COLS;
       screen[1].screen_start_row = screen[0].screen_rows + start_row;
       screen[1].screen_start_col = 0;
      }
   }
 else
   {
    screen[0].screen_rows = LINES - number_rows_less;
    screen[0].screen_cols = (COLS / display_screens)-((display_screens == 1) ? 0 : 1);
    screen[0].screen_start_row = start_row;
    screen[0].screen_start_col = 0;
    if (display_screens == 1)
      {
       screen[1].screen_rows = 0;
       screen[1].screen_cols = 0;
       screen[1].screen_start_row = 0;
       screen[1].screen_start_col = 0;
      }
    else
      {
       screen[1].screen_rows = LINES - number_rows_less;
       screen[1].screen_cols = COLS - screen[0].screen_cols - 2;
       screen[1].screen_start_row = start_row;
       screen[1].screen_start_col = screen[0].screen_cols + 2;
      }
   }
/*---------------------------------------------------------------------*/
/* Reset window sizes to zero...                                       */
/*---------------------------------------------------------------------*/
 for (i=0;i<MAX_SCREENS;i++)
   {
    for (j=0;j<VIEW_WINDOWS;j++)
      {
       screen[i].start_row[j] = 0;
       screen[i].start_col[j] = 0;
       screen[i].rows[j] = 0;
       screen[i].cols[j] = 0;
      }
   }
/*---------------------------------------------------------------------*/
/* Determine size of each window for each screen...                    */
/*---------------------------------------------------------------------*/
 for (i=0;i<display_screens;i++)
   {
    if (screen[i].screen_view == (VIEW_DETAILS *)NULL)
      {
       cmdline = 'B';
       idline_rows = 1;
       prefix = PREFIXx;
      }
    else
      {
       cmdline = screen[i].screen_view->cmd_line;
       idline_rows = (screen[i].screen_view->id_line) ? 1 : 0;
       prefix = screen[i].screen_view->prefix;
      }
    switch(cmdline)
      {
       case 'T':                                   /* command line on top */
            screen[i].start_row[WINDOW_MAIN] = screen[i].screen_start_row + 1 + idline_rows;
            screen[i].rows[WINDOW_MAIN] = screen[i].screen_rows - 1 - idline_rows;
            screen[i].start_row[WINDOW_COMMAND] = screen[i].screen_start_row + idline_rows;
            screen[i].rows[WINDOW_COMMAND] = 1;
            screen[i].cols[WINDOW_COMMAND] = screen[i].screen_cols-PREFIX_WIDTH;
            screen[i].start_row[WINDOW_ARROW] = screen[i].start_row[WINDOW_COMMAND];
            screen[i].rows[WINDOW_ARROW] = 1;
            screen[i].cols[WINDOW_ARROW] = PREFIX_WIDTH;
            break;
       case 'B':                                /* command line on bottom */
            screen[i].start_row[WINDOW_MAIN] = screen[i].screen_start_row + idline_rows;
            screen[i].rows[WINDOW_MAIN] = screen[i].screen_rows - 1 - idline_rows;
            screen[i].start_row[WINDOW_COMMAND] = screen[i].screen_start_row + screen[i].screen_rows - 1;
            screen[i].rows[WINDOW_COMMAND] = 1;
            screen[i].cols[WINDOW_COMMAND] = screen[i].screen_cols-PREFIX_WIDTH;
            screen[i].start_row[WINDOW_ARROW] = screen[i].start_row[WINDOW_COMMAND];
            screen[i].rows[WINDOW_ARROW] = 1;
            screen[i].cols[WINDOW_ARROW] = PREFIX_WIDTH;
            break;
       case 'O':                                      /* command line off */
            screen[i].start_row[WINDOW_MAIN] = screen[i].screen_start_row + idline_rows;
            screen[i].rows[WINDOW_MAIN] = screen[i].screen_rows - idline_rows;
            screen[i].start_row[WINDOW_COMMAND] = 0;
            screen[i].rows[WINDOW_COMMAND] = 0;
            screen[i].cols[WINDOW_COMMAND] = 0;
            screen[i].start_row[WINDOW_ARROW] = 0;
            screen[i].rows[WINDOW_ARROW] = 0;
            screen[i].cols[WINDOW_ARROW] = 0;
            break;
      }
    screen[i].start_col[WINDOW_ARROW] = screen[i].screen_start_col;
    screen[i].start_col[WINDOW_COMMAND] = screen[i].screen_start_col+PREFIX_WIDTH;
    if (idline_rows == 1)
      {
       screen[i].start_row[WINDOW_IDLINE] = screen[i].screen_start_row;
       screen[i].start_col[WINDOW_IDLINE] = screen[i].screen_start_col;
       screen[i].rows[WINDOW_IDLINE] = 1;
       screen[i].cols[WINDOW_IDLINE] = screen[i].screen_cols;
      }
    if (prefix)
      {
       screen[i].start_row[WINDOW_PREFIX] = screen[i].start_row[WINDOW_MAIN];
       screen[i].rows[WINDOW_PREFIX] = screen[i].rows[WINDOW_MAIN];
       screen[i].cols[WINDOW_PREFIX] = PREFIX_WIDTH;
       screen[i].cols[WINDOW_MAIN] = screen[i].screen_cols-PREFIX_WIDTH;
       if ((prefix&PREFIX_LOCATION_MASK) == PREFIX_LEFT)
         {
          screen[i].start_col[WINDOW_PREFIX] = screen[i].screen_start_col;
          screen[i].start_col[WINDOW_MAIN] = screen[i].screen_start_col+PREFIX_WIDTH;
         }
       else
         {
          screen[i].start_col[WINDOW_MAIN] = screen[i].screen_start_col;
          screen[i].start_col[WINDOW_PREFIX] = (screen[i].screen_start_col+screen[i].screen_cols)-PREFIX_WIDTH;
         }
      }
    else
      {
       screen[i].cols[WINDOW_MAIN] = screen[i].screen_cols;
       screen[i].start_col[WINDOW_MAIN] = screen[i].screen_start_col;
       screen[i].rows[WINDOW_PREFIX] = 0;
       screen[i].cols[WINDOW_PREFIX] = 0;
      }
   }
/*---------------------------------------------------------------------*/
/* We now have the size of each screen, so we can allocate the display */
/* line arrays.                                                        */
/*---------------------------------------------------------------------*/
 if (screen[0].sl != NULL)
   {
    (*the_free)(screen[0].sl);
    screen[0].sl = NULL;
   }
 if (screen[1].sl != NULL)
   {
    (*the_free)(screen[1].sl);
    screen[1].sl = NULL;
   }
 if ((screen[0].sl = (SHOW_LINE *)(*the_malloc)(screen[0].rows[WINDOW_MAIN]*sizeof(SHOW_LINE))) == NULL)
   {
    display_error(30,"",FALSE);
    exit_clean(1);
   }
 if (display_screens > 1)
   {
    if ((screen[1].sl = (SHOW_LINE *)(*the_malloc)(screen[1].rows[WINDOW_MAIN]*sizeof(SHOW_LINE))) == NULL)
      {
       display_error(30,"",FALSE);
       exit_clean(1);
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void set_defaults(void)
#else
void set_defaults()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern CHARTYPE *cmd_rec;
 extern LENGTHTYPE cmd_rec_len;
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_defaults");
#endif
/*---------------------------------------------------------------------*/
/* Set up screen default sizes using the temp values of LINES and COLS.*/
/* These will be overwritten by initscr().                             */
/*---------------------------------------------------------------------*/
 set_screen_defaults();
/*---------------------------------------------------------------------*/
/* Allocate memory to cmd_rec and set it to blanks.                    */
/*---------------------------------------------------------------------*/
 if (cmd_rec != NULL)
    (*the_free)(cmd_rec);
 if ((cmd_rec = (CHARTYPE *)(*the_malloc)((COLS+1)*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
 memset(cmd_rec,' ',COLS);
 cmd_rec_len = 0;

#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
short set_THE_defaults(int prey,int prex)
#else
short set_THE_defaults(prey,prex)
int prey,prex;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short prefix_width;
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_THE_defaults");
#endif
/*---------------------------------------------------------------------*/
/* This function is for resetting all default values for THE           */
/* compatibility mode.                                                 */
/*---------------------------------------------------------------------*/
 Define("F2");
 Define("F3");
 Define("F4");
 Define("F6");
 Define("F7");
 Define("F8");
 Define("F9");
 Define("F11");
 Define("CURD");
 Define("CURL");
 Define("CURR");
 Define("CURU");
#if defined(UNIX) && !defined(USE_EXTCURSES)
 Define("C-M");
 Define("Do");
# if defined(KEY_TAB)
 Define("KEY_TAB");
# endif
# if defined(KEY_BTAB)
 Define("S-TAB");
# endif
 Define("C-I");
#else
 Define("TAB");
 Define("S-TAB");
 Define("ENTER");
#endif
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
short set_XEDIT_defaults(int prey,int prex)
#else
short set_XEDIT_defaults(prey,prex)
int prey,prex;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short prefix_width;
 extern bool in_profile;
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
 int y=0,x=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_XEDIT_defaults");
#endif
/*---------------------------------------------------------------------*/
/* This function is for resetting all default values for XEDIT         */
/* compatibility mode.                                                 */
/*---------------------------------------------------------------------*/
 Define("F2 sos lineadd");
 Define("F3 quit");
 Define("F4 sos tabf");
 Define("F6 ?");
 Define("F7 backward");
 Define("F8 forward");
 Define("F9 =");
 Define("F11 spltjoin");
 Define("CURD cursor screen down");
 Define("CURL cursor screen left");
 Define("CURR cursor screen right");
 Define("CURU cursor screen up");
#if defined(UNIX) && !defined(USE_EXTCURSES)
 Define("C-M sos doprefix#sos execute");
# if defined(KEY_BTAB)
 Define("S-TAB sos tabfieldb");
# endif
# if defined(KEY_TAB)
 Define("KEY_TAB sos tabfieldf");
# endif
 Define("C-I sos tabfieldf");
#else
 Define("ENTER sos doprefix#sos execute");
 Define("S-TAB sos tabfieldb");
 Define("TAB sos tabfieldf");
#endif
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
short set_KEDIT_defaults(int prey,int prex)
#else
short set_KEDIT_defaults(prey,prex)
int prey,prex;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short prefix_width;
 extern bool in_profile;
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
 int y=0,x=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_KEDIT_defaults");
#endif
/*---------------------------------------------------------------------*/
/* This function is for resetting all default values for KEDIT         */
/* compatibility mode.                                                 */
/*---------------------------------------------------------------------*/
 Define("F2 sos lineadd");
 Define("F3 quit");
 Define("F4 sos tab");
 Define("F5 sos makecurr");
 Define("F6 ?");
 Define("F7 ");
 Define("F8 dup");
 Define("F9 =");
 Define("F11 spltjoin");
 Define("F12 cursor home");
 Define("CURD");
 Define("CURL cursor kedit left");
 Define("CURR cursor kedit right");
 Define("CURU");
#if defined(UNIX) && !defined(USE_EXTCURSES)
 Define("C-M");
# if defined(KEY_TAB)
 Define("KEY_TAB");
# endif
# if defined(KEY_BTAB)
 Define("S-TAB");
# endif
 Define("C-I");
#else
 Define("ENTER");
 Define("TAB");
 Define("S-TAB");
#endif

#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
