/***********************************************************************/
/* LINKED.C - Linked list routines.                                    */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: linked.c 2.0 1995/01/26 16:31:19 MH Release MH $
*/

#include <stdio.h>
#include "the.h"
#include "proto.h"
/*-------------------------- external data ----------------------------*/
/***********************************************************************/
#ifdef PROTO
LINE *lll_add(LINE *first,LINE *curr,unsigned short size)
#else
LINE *lll_add(first,curr,size)
LINE *first;
LINE *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a LINE to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first LINE in linked list                   */
/* curr       - pointer to current LINE in linked list                 */
/* size       - size of a LINE item                                    */
/* RETURN:    - pointer to next LINE item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_add");
#endif

 if ((next=(LINE *)(*the_malloc)(size)) != (LINE *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->line = NULL;
 next->name = NULL;
 next->pre = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef PROTO
LINE *lll_del(LINE **first,LINE **last,LINE *curr,short direction)
#else
LINE *lll_del(first,last,curr,direction)
LINE **first;
LINE **last;
LINE *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
    new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
LINE *lll_free(LINE *first)
#else
LINE *lll_free(first)
LINE *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr=NULL;
 LINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    (*the_free)(curr->line);
    if (curr->name != (CHARTYPE *)NULL)
       (*the_free)(curr->name);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((LINE *)NULL);
}
/***********************************************************************/
#ifdef PROTO
LINE *lll_find(LINE *first,LINETYPE row)
#else
LINE *lll_find(first,row)
LINE *first;
LINETYPE row;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr=NULL;
 LINETYPE i=0L;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_find");
#endif
 curr = first;
 if (curr != NULL)
    for(i=0L;i<row && curr->next != NULL; i++, curr=curr->next);
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
VIEW_DETAILS *vll_add(VIEW_DETAILS *first,VIEW_DETAILS *curr,unsigned short size)
#else
VIEW_DETAILS *vll_add(first,curr,size)
VIEW_DETAILS *first;
VIEW_DETAILS *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a VIEW_DETAILS to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first VIEW_DETAILS in linked list                   */
/* curr       - pointer to current VIEW_DETAILS in linked list                 */
/* size       - size of a VIEW_DETAILS item                                    */
/* RETURN:    - pointer to next VIEW_DETAILS item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 VIEW_DETAILS *next=(VIEW_DETAILS *)NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    vll_add");
#endif

 if ((next=(VIEW_DETAILS *)(*the_malloc)(size)) != (VIEW_DETAILS *)NULL)
   {
    if (curr == (VIEW_DETAILS *)NULL)
      {
       first = next;
       next->next = (VIEW_DETAILS *)NULL;
      }
    else
      {
       if (curr->next != (VIEW_DETAILS *)NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->file_for_view == NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef PROTO
VIEW_DETAILS *vll_del(VIEW_DETAILS **first,VIEW_DETAILS **last,VIEW_DETAILS *curr,short direction)
#else
VIEW_DETAILS *vll_del(first,last,curr,direction)
VIEW_DETAILS **first;
VIEW_DETAILS **last;
VIEW_DETAILS *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 VIEW_DETAILS *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    vll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
#ifdef TRACE
    trace_return();
#endif
    *first = curr = NULL;
    if (last != NULL)
       *last = NULL;
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
DEFINE *dll_add(DEFINE *first,DEFINE *curr,unsigned short size)
#else
DEFINE *dll_add(first,curr,size)
DEFINE *first;
DEFINE *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a DEFINE to the current linked list after the current member.  */
/* PARAMETERS:                                                         */
/* first      - pointer to first DEFINE in linked list                 */
/* curr       - pointer to current DEFINE in linked list               */
/* size       - size of a DEFINE item                                  */
/* RETURN:    - pointer to next DEFINE item                            */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_add");
#endif
 if ((next=(DEFINE *)(*the_malloc)(size)) != (DEFINE *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->def_params = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef PROTO
DEFINE *dll_del(DEFINE **first,DEFINE **last,DEFINE *curr,short direction)
#else
DEFINE *dll_del(first,last,curr,direction)
DEFINE **first;
DEFINE **last;
DEFINE *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
DEFINE *dll_free(DEFINE *first)
#else
DEFINE *dll_free(first)
DEFINE *first;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *curr=NULL;
 DEFINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_free");
#endif
 curr = first;
 while (curr != (DEFINE *)NULL)
   {
    if (curr->def_params != NULL)
       (*the_free)(curr->def_params);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((DEFINE *)NULL);
}
/***********************************************************************/
#ifdef PROTO
PPC *pll_add(PPC *first,PPC *curr,unsigned short size)
#else
PPC *pll_add(first,curr,size)
PPC *first;
PPC *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a PPC to the current linked list after the current member.     */
/* PARAMETERS:                                                         */
/* first      - pointer to first PPC in linked list                    */
/* curr       - pointer to current PPC in linked list                  */
/* size       - size of a PPC item                                     */
/* RETURN:    - pointer to next PPC item                               */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_add");
#endif

 if ((next=(PPC *)(*the_malloc)(size)) != (PPC *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef PROTO
PPC *pll_del(PPC **first,PPC **last,PPC *curr,short direction)
#else
PPC *pll_del(first,last,curr,direction)
PPC **first;
PPC **last;
PPC *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
PPC *pll_free(PPC *first)
#else
PPC *pll_free(first)
PPC *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *curr=NULL;
 PPC *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((PPC *)NULL);
}
/***********************************************************************/
#ifdef PROTO
PPC *pll_find(PPC *first,LINETYPE line_number)
#else
PPC *pll_find(first,line_number)
PPC *first;
LINETYPE line_number;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *curr_ppc=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_find");
#endif
 curr_ppc = first;
 while (curr_ppc != NULL)
   {
    if (curr_ppc->ppc_line_number == line_number)
      {
#ifdef TRACE
       trace_return();
#endif
       return(curr_ppc);
      }
    curr_ppc = curr_ppc->next;
   }
#ifdef TRACE
 trace_return();
#endif
 return(NULL);
}
/***********************************************************************/
#ifdef PROTO
RESERVED *rll_add(RESERVED *first,RESERVED *curr,unsigned short size)
#else
RESERVED *rll_add(first,curr,size)
RESERVED *first;
RESERVED *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a RESERVED to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first RESERVED in linked list                   */
/* curr       - pointer to current RESERVED in linked list                 */
/* size       - size of a RESERVED item                                    */
/* RETURN:    - pointer to next RESERVED item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_add");
#endif

 if ((next=(RESERVED *)(*the_malloc)(size)) != (RESERVED *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->line = NULL;
 next->spec = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef PROTO
RESERVED *rll_del(RESERVED **first,RESERVED **last,RESERVED *curr,short direction)
#else
RESERVED *rll_del(first,last,curr,direction)
RESERVED **first;
RESERVED **last;
RESERVED *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
RESERVED *rll_free(RESERVED *first)
#else
RESERVED *rll_free(first)
RESERVED *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *curr=NULL;
 RESERVED *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    (*the_free)(curr->line);
    if (curr->spec != (CHARTYPE *)NULL)
       (*the_free)(curr->spec);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((RESERVED *)NULL);
}
/***********************************************************************/
#ifdef PROTO
RESERVED *rll_find(RESERVED *first,short row)
#else
RESERVED *rll_find(first,row)
RESERVED *first;
short row;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *curr=NULL;
 short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_find");
#endif
 curr = first;
 if (curr != NULL)
    for(i=0;i<row && curr->next != NULL; i++, curr=curr->next);
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
