/***********************************************************************/
/* REXX.C - REXX interface routines.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: rexx.c 2.0 1995/01/26 16:31:55 MH Release MH $
*/

#if defined(PROTO)
/*--------------------------- global data -----------------------------*/
/* these are here because EMX include REXX definitions from within os2.h */
/*---------------------------------------------------------------------*/
#  define INCL_RXSUBCOM       /* Subcommand handler values */
#  define INCL_RXSHV          /* Shared variable support */
#  define INCL_RXSYSEXIT      /* System exit routines */
#  define INCL_DOSPROCESS     /* Process/Thread Info */
#  define INCL_RXFUNC         /* External functions */

#include "the.h"
#include "proto.h"
#include "query.h"
#include "rexx.h"

#if defined(USE_AIXREXX)
LONG THE_Commands(PRXSTRING, PUSHORT,PRXSTRING);
LONG THE_Exit_Handler(LONG, LONG, PEXIT);
USHORT THE_Function_Handler(PSZ,ULONG,PRXSTRING,PSZ,PRXSTRING);
#else
RexxSubcomHandler THE_Commands;
RexxExitHandler THE_Exit_Handler;
RexxFunctionHandler THE_Function_Handler;
#endif

FILE *rexxoutfp;
static LINETYPE captured_lines;
static bool rexx_halted;


struct function_item
 {
  CHARTYPE *name;                      /* name of item */
  short item_number;                  /* unique number for item */
  short item_index;                  /* index value for the whole item */
  CHARTYPE query;                         /* valid query response ? */
 };
typedef struct function_item FUNCTION_ITEM;

 static FUNCTION_ITEM function_item[] =
  {
   {(CHARTYPE *)"ALT.0",ITEM_ALT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"ALT.1",ITEM_ALT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"ALT.2",ITEM_ALT,2,QUERY_FUNCTION},
   {(CHARTYPE *)"ARBCHAR.0",ITEM_ARBCHAR,0,QUERY_FUNCTION},
   {(CHARTYPE *)"ARBCHAR.1",ITEM_ARBCHAR,1,QUERY_FUNCTION},
   {(CHARTYPE *)"ARBCHAR.2",ITEM_ARBCHAR,2,QUERY_FUNCTION},
   {(CHARTYPE *)"AUTOSAVE.0",ITEM_AUTOSAVE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"AUTOSAVE.1",ITEM_AUTOSAVE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BACKUP.0",ITEM_BACKUP,0,QUERY_FUNCTION},
   {(CHARTYPE *)"BACKUP.1",ITEM_BACKUP,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BEEP.0",ITEM_BEEP,0,QUERY_FUNCTION},
   {(CHARTYPE *)"BEEP.1",ITEM_BEEP,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.0",ITEM_BLOCK,0,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.1",ITEM_BLOCK,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.2",ITEM_BLOCK,2,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.3",ITEM_BLOCK,3,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.4",ITEM_BLOCK,4,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.5",ITEM_BLOCK,5,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK.6",ITEM_BLOCK,6,QUERY_FUNCTION},
   {(CHARTYPE *)"CASE.0",ITEM_CASE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CASE.1",ITEM_CASE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CASE.2",ITEM_CASE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"CASE.3",ITEM_CASE,3,QUERY_FUNCTION},
   {(CHARTYPE *)"CASE.4",ITEM_CASE,4,QUERY_FUNCTION},
   {(CHARTYPE *)"CLEARSCREEN.0",ITEM_CLEARSCREEN,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CLEARSCREEN.1",ITEM_CLEARSCREEN,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CLOCK.0",ITEM_CLOCK,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CLOCK.1",ITEM_CLOCK,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDARROWS.0",ITEM_CMDARROWS,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDARROWS.1",ITEM_CMDARROWS,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDLINE.0",ITEM_CMDLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDLINE.1",ITEM_CMDLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDLINE.2",ITEM_CMDLINE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"CMDLINE.3",ITEM_CMDLINE,3,QUERY_FUNCTION},
   {(CHARTYPE *)"COMPAT.0",ITEM_COMPAT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"COMPAT.1",ITEM_COMPAT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CURLINE.0",ITEM_CURLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CURLINE.1",ITEM_CURLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CURLINE.2",ITEM_CURLINE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"CURLINE.3",ITEM_CURLINE,3,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.0",ITEM_CURSOR,0,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.1",ITEM_CURSOR,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.2",ITEM_CURSOR,2,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.3",ITEM_CURSOR,3,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.4",ITEM_CURSOR,4,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.5",ITEM_CURSOR,5,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.6",ITEM_CURSOR,6,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.7",ITEM_CURSOR,7,QUERY_FUNCTION},
   {(CHARTYPE *)"CURSOR.8",ITEM_CURSOR,8,QUERY_FUNCTION},
   {(CHARTYPE *)"DIRFILEID.0",ITEM_DIRFILEID,0,QUERY_FUNCTION},
   {(CHARTYPE *)"DIRFILEID.1",ITEM_DIRFILEID,1,QUERY_FUNCTION},
   {(CHARTYPE *)"DIRFILEID.2",ITEM_DIRFILEID,2,QUERY_FUNCTION},
   {(CHARTYPE *)"DISPLAY.0",ITEM_DISPLAY,0,QUERY_FUNCTION},
   {(CHARTYPE *)"DISPLAY.1",ITEM_DISPLAY,1,QUERY_FUNCTION},
   {(CHARTYPE *)"DISPLAY.2",ITEM_DISPLAY,2,QUERY_FUNCTION},
   {(CHARTYPE *)"EOF.0",ITEM_EOF,0,QUERY_FUNCTION},
   {(CHARTYPE *)"EOF.1",ITEM_EOF,1,QUERY_FUNCTION},
   {(CHARTYPE *)"EOLOUT.0",ITEM_EOLOUT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"EOLOUT.1",ITEM_EOLOUT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"ETMODE.0",ITEM_ETMODE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"ETMODE.1",ITEM_ETMODE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FNAME.0",ITEM_FNAME,0,QUERY_FUNCTION},
   {(CHARTYPE *)"FNAME.1",ITEM_FNAME,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FPATH.0",ITEM_FPATH,0,QUERY_FUNCTION},
   {(CHARTYPE *)"FPATH.1",ITEM_FPATH,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FTYPE.0",ITEM_FTYPE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"FTYPE.1",ITEM_FTYPE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"GETENV.0",ITEM_GETENV,0,QUERY_FUNCTION},
   {(CHARTYPE *)"GETENV.1",ITEM_GETENV,1,QUERY_FUNCTION},
   {(CHARTYPE *)"HEX.0",ITEM_HEX,0,QUERY_FUNCTION},
   {(CHARTYPE *)"HEX.1",ITEM_HEX,1,QUERY_FUNCTION},
   {(CHARTYPE *)"HEXDISPLAY.0",ITEM_HEXDISPLAY,0,QUERY_FUNCTION},
   {(CHARTYPE *)"HEXDISPLAY.1",ITEM_HEXDISPLAY,1,QUERY_FUNCTION},
   {(CHARTYPE *)"HEXSHOW.0",ITEM_HEXSHOW,0,QUERY_FUNCTION},
   {(CHARTYPE *)"HEXSHOW.1",ITEM_HEXSHOW,1,QUERY_FUNCTION},
   {(CHARTYPE *)"HEXSHOW.2",ITEM_HEXSHOW,2,QUERY_FUNCTION},
   {(CHARTYPE *)"IDLINE.0",ITEM_IDLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"IDLINE.1",ITEM_IDLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"IMPMACRO.0",ITEM_IMPMACRO,0,QUERY_FUNCTION},
   {(CHARTYPE *)"IMPMACRO.1",ITEM_IMPMACRO,1,QUERY_FUNCTION},
   {(CHARTYPE *)"IMPMOS.0",ITEM_IMPOS,0,QUERY_FUNCTION},
   {(CHARTYPE *)"IMPMOS.1",ITEM_IMPOS,1,QUERY_FUNCTION},
   {(CHARTYPE *)"INSERTMODE.0",ITEM_INSERTMODE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"INSERTMODE.1",ITEM_INSERTMODE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LASTMSG.0",ITEM_LASTMSG,0,QUERY_FUNCTION},
   {(CHARTYPE *)"LASTMSG.1",ITEM_LASTMSG,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LASTRC.0",ITEM_LASTRC,0,QUERY_FUNCTION},
   {(CHARTYPE *)"LASTRC.1",ITEM_LASTRC,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LENGTH.0",ITEM_LENGTH,0,QUERY_FUNCTION},
   {(CHARTYPE *)"LENGTH.1",ITEM_LENGTH,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LINE.0",ITEM_LINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"LINE.1",ITEM_LINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LINEND.0",ITEM_LINEND,0,QUERY_FUNCTION},
   {(CHARTYPE *)"LINEND.1",ITEM_LINEND,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LINEND.2",ITEM_LINEND,2,QUERY_FUNCTION},
   {(CHARTYPE *)"MACROEXT.0",ITEM_MACROEXT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MACROEXT.1",ITEM_MACROEXT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MACROPATH.0",ITEM_MACROPATH,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MACROPATH.1",ITEM_MACROPATH,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MARGINS.0",ITEM_MARGINS,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MARGINS.1",ITEM_MARGINS,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MARGINS.2",ITEM_MARGINS,2,QUERY_FUNCTION},
   {(CHARTYPE *)"MARGINS.3",ITEM_MARGINS,3,QUERY_FUNCTION},
   {(CHARTYPE *)"MONITOR.0",ITEM_MONITOR,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MONITOR.1",ITEM_MONITOR,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MONITOR.2",ITEM_MONITOR,2,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGLINE.0",ITEM_MSGLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGLINE.1",ITEM_MSGLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGLINE.2",ITEM_MSGLINE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGLINE.3",ITEM_MSGLINE,3,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGLINE.4",ITEM_MSGLINE,4,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGMODE.0",ITEM_MSGMODE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"MSGMODE.1",ITEM_MSGMODE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"NBFILE.0",ITEM_NBFILE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"NBFILE.1",ITEM_NBFILE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"NEWLINES.0",ITEM_NEWLINES,0,QUERY_FUNCTION},
   {(CHARTYPE *)"NEWLINES.1",ITEM_NEWLINES,1,QUERY_FUNCTION},
   {(CHARTYPE *)"NONDISP.0",ITEM_NONDISP,0,QUERY_FUNCTION},
   {(CHARTYPE *)"NONDISP.1",ITEM_NONDISP,1,QUERY_FUNCTION},
   {(CHARTYPE *)"NUMBER.0",ITEM_NUMBER,0,QUERY_FUNCTION},
   {(CHARTYPE *)"NUMBER.1",ITEM_NUMBER,1,QUERY_FUNCTION},
   {(CHARTYPE *)"POSITION.0",ITEM_POSITION,0,QUERY_FUNCTION},
   {(CHARTYPE *)"POSITION.1",ITEM_POSITION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"POSITION.2",ITEM_POSITION,2,QUERY_FUNCTION},
   {(CHARTYPE *)"POSITION.3",ITEM_POSITION,3,QUERY_FUNCTION},
   {(CHARTYPE *)"PREFIX.0",ITEM_PREFIX,0,QUERY_FUNCTION},
   {(CHARTYPE *)"PREFIX.1",ITEM_PREFIX,1,QUERY_FUNCTION},
   {(CHARTYPE *)"PREFIX.2",ITEM_PREFIX,2,QUERY_FUNCTION},
   {(CHARTYPE *)"PRINTER.0",ITEM_PRINTER,0,QUERY_FUNCTION},
   {(CHARTYPE *)"PRINTER.1",ITEM_PRINTER,1,QUERY_FUNCTION},
   {(CHARTYPE *)"REPROFILE.0",ITEM_REPROFILE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"REPROFILE.1",ITEM_REPROFILE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"RESERVED.0",ITEM_RESERVED,0,QUERY_FUNCTION},
   {(CHARTYPE *)"RESERVED.1",ITEM_RESERVED,1,QUERY_FUNCTION},
   {(CHARTYPE *)"REXXOUTPUT.0",ITEM_REXXOUTPUT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"REXXOUTPUT.1",ITEM_REXXOUTPUT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"REXXOUTPUT.2",ITEM_REXXOUTPUT,2,QUERY_FUNCTION},
   {(CHARTYPE *)"SCALE.0",ITEM_SCALE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"SCALE.1",ITEM_SCALE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"SCALE.2",ITEM_SCALE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"SCOPE.0",ITEM_SCOPE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"SCOPE.1",ITEM_SCOPE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"SELECT.0",ITEM_SELECT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"SELECT.1",ITEM_SELECT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"SELECT.2",ITEM_SELECT,2,QUERY_FUNCTION},
   {(CHARTYPE *)"SHADOW.0",ITEM_SHADOW,0,QUERY_FUNCTION},
   {(CHARTYPE *)"SHADOW.1",ITEM_SHADOW,1,QUERY_FUNCTION},
   {(CHARTYPE *)"SIZE.0",ITEM_SIZE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"SIZE.1",ITEM_SIZE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"STATUSLINE.0",ITEM_STATUSLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"STATUSLINE.1",ITEM_STATUSLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"STAY.0",ITEM_STAY,0,QUERY_FUNCTION},
   {(CHARTYPE *)"STAY.1",ITEM_STAY,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABKEY.0",ITEM_TABKEY,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TABKEY.1",ITEM_TABKEY,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABKEY.2",ITEM_TABKEY,2,QUERY_FUNCTION},
   {(CHARTYPE *)"TABLINE.0",ITEM_TABLINE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TABLINE.1",ITEM_TABLINE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABLINE.2",ITEM_TABLINE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"TABS.0",ITEM_TABS,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TABS.1",ITEM_TABS,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSIN.0",ITEM_TABSIN,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSIN.1",ITEM_TABSIN,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSIN.2",ITEM_TABSIN,2,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSOUT.0",ITEM_TABSOUT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSOUT.1",ITEM_TABSOUT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TABSOUT.2",ITEM_TABSOUT,2,QUERY_FUNCTION},
   {(CHARTYPE *)"TERMINAL.0",ITEM_TERMINAL,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TERMINAL.1",ITEM_TERMINAL,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TOF.0",ITEM_TOF,0,QUERY_FUNCTION},
   {(CHARTYPE *)"TOF.1",ITEM_TOF,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VERIFY.0",ITEM_VERIFY,0,QUERY_FUNCTION},
   {(CHARTYPE *)"VERIFY.1",ITEM_VERIFY,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSHIFT.0",ITEM_VERSHIFT,0,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSHIFT.1",ITEM_VERSHIFT,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSION.0",ITEM_VERSION,0,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSION.1",ITEM_VERSION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSION.2",ITEM_VERSION,2,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSION.3",ITEM_VERSION,3,QUERY_FUNCTION},
   {(CHARTYPE *)"VERSION.4",ITEM_VERSION,4,QUERY_FUNCTION},
   {(CHARTYPE *)"WIDTH.0",ITEM_WIDTH,0,QUERY_FUNCTION},
   {(CHARTYPE *)"WIDTH.1",ITEM_WIDTH,1,QUERY_FUNCTION},
   {(CHARTYPE *)"WORDWRAP.0",ITEM_WORDWRAP,0,QUERY_FUNCTION},
   {(CHARTYPE *)"WORDWRAP.1",ITEM_WORDWRAP,1,QUERY_FUNCTION},
   {(CHARTYPE *)"ZONE.0",ITEM_ZONE,0,QUERY_FUNCTION},
   {(CHARTYPE *)"ZONE.1",ITEM_ZONE,1,QUERY_FUNCTION},
   {(CHARTYPE *)"ZONE.2",ITEM_ZONE,2,QUERY_FUNCTION},
   {(CHARTYPE *)"AFTER",ITEM_AFTER_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BEFORE",ITEM_BEFORE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BLANK",ITEM_BLANK_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BLOCK",ITEM_BLOCK_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"BOTTOMEDGE",ITEM_BOTTOMEDGE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"COMMAND",ITEM_COMMAND_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"CURRENT",ITEM_CURRENT_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"DIR",ITEM_DIR_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"END",ITEM_END_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"EOF",ITEM_EOF_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FIRST",ITEM_FIRST_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FOCUSEOF",ITEM_FOCUSEOF_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"FOCUSTOF",ITEM_FOCUSTOF_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"INBLOCK",ITEM_INBLOCK_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"INCOMMAND",ITEM_INCOMMAND_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"INITIAL",ITEM_INITIAL_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"INPREFIX",ITEM_INPREFIX_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"LEFTEDGE",ITEM_LEFTEDGE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"MODIFIABLE",ITEM_MODIFIABLE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"RIGHTEDGE",ITEM_RIGHTEDGE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"SPACECHAR",ITEM_SPACECHAR_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TOF",ITEM_TOF_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"TOPEDGE",ITEM_TOPEDGE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VERONE",ITEM_VERONE_FUNCTION,1,QUERY_FUNCTION},
   {(CHARTYPE *)"VALID_TARGET",ITEM_VALID_TARGET_FUNCTION,1,QUERY_FUNCTION},
   {NULL,0,0,0},
  };

/***********************************************************************/
#if defined(USE_AIXREXX)
LONG THE_Commands(
   PRXSTRING Command,    /* Command string passed from the caller    */
   PUSHORT   Flags,      /* pointer to short for return of flags     */
   PRXSTRING Retstr)     /* pointer to RXSTRING for RC return        */
#else
ULONG THE_Commands(
   PRXSTRING Command,    /* Command string passed from the caller    */
   PUSHORT   Flags,      /* pointer to short for return of flags     */
   PRXSTRING Retstr)     /* pointer to RXSTRING for RC return        */
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern CHARTYPE *temp_cmd;
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
 SHVBLOCK shv;
 RXSTRING argstr;
/*--------------------------- processing ------------------------------*/
 if (allocate_temp_space(Command->strlength,TEMP_TEMP_CMD) != RC_OK)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
    *Flags = RXSUBCOM_ERROR;             /* raise an error condition   */
    sprintf(Retstr->strptr, "%d", rc);   /* format return code string  */
                                         /* and set the correct length */
    Retstr->strlength = strlen(Retstr->strptr);
    return 0L;                           /* processing completed       */
   }
 memcpy(temp_cmd,Command->strptr,Command->strlength);
 temp_cmd[Command->strlength] = '\0';

 if (strcmp("XXYYZZ",temp_cmd) == 0)
   {
    shv.shvnext=NULL;                                /* only one block */
    shv.shvcode=RXSHV_NEXTV;                             /* direct set */

    argstr.strptr=NULL;
    argstr.strlength=0;
    shv.shvname=argstr;
    rc = 0;
    while(rc != 2)
     {
      rc = RexxVariablePool(&shv);            /* get the next variable */
      if (rc != 2)
        {
         sprintf(temp_cmd,"i <%s> <%s> <%d>",
             shv.shvname.strptr,shv.shvvalue.strptr,shv.shvvalue.strlength);
         command_line(temp_cmd,COMMAND_ONLY_FALSE);
        }
     }
   }
 else
   rc = command_line(temp_cmd,COMMAND_ONLY_FALSE);
 if (rc < 0)
    *Flags = RXSUBCOM_ERROR;             /* raise an error condition   */
 else
    *Flags = RXSUBCOM_OK;                /* not found is not an error  */

 sprintf(Retstr->strptr, "%d", rc);      /* format return code string  */
                                         /* and set the correct length */
 Retstr->strlength = strlen(Retstr->strptr);
 return 0L;                              /* processing completed       */
}
/***********************************************************************/
LONG THE_Exit_Handler(
      LONG  ExitNumber,    /* code defining the exit function    */
      LONG  Subfunction,   /* code defining the exit subfunction */
      PEXIT ParmBlock)     /* function dependent control block   */
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern WINDOW *foot;
 extern bool in_profile;
 extern CHARTYPE *temp_cmd;
 extern CHARTYPE rexx_filename[10];
 extern CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
 extern LINETYPE CAPREXXMAXx;
 extern bool CAPREXXOUTx;
 extern bool rexx_output;
/*--------------------------- local data ------------------------------*/
 RXSIOTRC_PARM *trc_parm = (RXSIOTRC_PARM *)ParmBlock;
 LONG rc=0L;
 register int i=0;
/*--------------------------- processing ------------------------------*/
 if (Subfunction != RXSIOSAY   /* ignore all but RXSIOSAY and RXSIOTRC */
 &&  Subfunction != RXSIOTRC)
    return(RXEXIT_NOT_HANDLED);
/*---------------------------------------------------------------------*/
/* If this is the first time this exit handler is called, set up the   */
/* handling of the result; either open the capture file, or set the    */
/* terminal out of curses mode so scrolling etc. work.                 */
/*---------------------------------------------------------------------*/
 if (!rexx_output)
   {
    rexx_output = TRUE;
    if (CAPREXXOUTx)
      {
       strcpy(temp_cmd,rexx_pathname);
       strcat(temp_cmd,rexx_filename);
       rexxoutfp = fopen(temp_cmd,"w");
      }
    else
      {
       if (!in_profile)
         {
          wmove(foot,0,COLS-1);
          wrefresh(foot);
          suspend_curses();
         }
       printf("\n");                       /* scroll the screen 1 line */
       fflush(stdout);
      }
   }
/*---------------------------------------------------------------------*/
/* If the REXX interpreter has been halted by line limit exceeded, just*/
/* return to the interpreter indicating that THE is hadnling the output*/
/* of messages. This is done to stop the "cluter" that comes back as   */
/* the interpreter tries to tell us that it is stopping.               */
/*---------------------------------------------------------------------*/
 if (rexx_halted)
    return(RXEXIT_HANDLED);
/*---------------------------------------------------------------------*/
/* If we are capturing the rexx output, print the string to the file.  */
/*---------------------------------------------------------------------*/
 if (CAPREXXOUTx)
   {
    for (i=0;i<trc_parm->rxsio_string.strlength;i++)
       fputc(trc_parm->rxsio_string.strptr[i],rexxoutfp);
    fputc('\n',rexxoutfp);
/*    fprintf(rexxoutfp,"%s\n",trc_parm->rxsio_string.strptr); */
    rc = RXEXIT_HANDLED;
   }
 else
    rc = RXEXIT_NOT_HANDLED;
/*---------------------------------------------------------------------*/
/* If the number of lines processed exceeds the line limit, display our*/
/* own message telling what has happened and exit with                 */
/* RXEXIT_RAISE_ERROR. This tells the interpreter that it is to stop.  */
/*---------------------------------------------------------------------*/
 if (++captured_lines > CAPREXXMAXx)
   {
    if (CAPREXXOUTx)
       fprintf(rexxoutfp,"THE: REXX macro halted - line limit (%d) exceeded\n",CAPREXXMAXx);
    else
       printf("THE: REXX macro halted - line limit (%d) exceeded\n",CAPREXXMAXx);
    rc = RXEXIT_RAISE_ERROR;
    rexx_halted = TRUE;
   }
 return(rc);
}
/***********************************************************************/
#if defined(USE_AIXREXX)
USHORT THE_Function_Handler(
      PSZ   FunctionName,  /* name of function */
      ULONG Argc,          /* number of arguments    */
      RXSTRING Argv[],     /* array of arguments in RXSTRINGs */
      PSZ   QueueName,     /* name of queue */
      PRXSTRING Retstr)    /* return string   */
#else
ULONG  THE_Function_Handler(
#  if defined(EMX)
      PCSZ   FunctionName,  /* name of function */
      ULONG Argc,          /* number of arguments    */
      RXSTRING Argv[],     /* array of arguments in RXSTRINGs */
      PCSZ   QueueName,     /* name of queue */
      PRXSTRING Retstr)    /* return string   */
#  else
      PSZ   FunctionName,  /* name of function */
      ULONG Argc,          /* number of arguments    */
      RXSTRING Argv[],     /* array of arguments in RXSTRINGs */
      PSZ   QueueName,     /* name of queue */
      PRXSTRING Retstr)    /* return string   */
#  endif
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VALUE item_values[MAX_VARIABLES_RETURNED];
/*--------------------------- local data ------------------------------*/
 register short i=0;
/*--------------------------- processing ------------------------------*/
/*---------------------------------------------------------------------*/
/* Find the external function name in the array. Error if not found.   */
/*---------------------------------------------------------------------*/
 for (i=0;function_item[i].name != NULL;i++)
   {
    if (memcmpi(FunctionName,function_item[i].name,strlen(function_item[i].name))==0)
      {
       (void)get_item_values(function_item[i].item_number,"",function_item[i].query,(LINETYPE)Argc,Argv[0].strptr,(LINETYPE)Argv[0].strlength);
       if (item_values[function_item[i].item_index].len > 256)
         {
          if ((Retstr->strptr = (PSZ)(*the_malloc)(item_values[function_item[i].item_index].len)) == NULL)
            {
             display_error(30,(CHARTYPE *)"",FALSE);
             return(1);
            }
         }
       memcpy(Retstr->strptr,item_values[function_item[i].item_index].value,
                             item_values[function_item[i].item_index].len);
       Retstr->strlength = item_values[function_item[i].item_index].len;
       return(0);
      }
   }
 return(1);                                    /* fatal error for REXX */
}
/***********************************************************************/
short initialise_rexx(void)
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 APIRET rc;
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    initialise_rexx");
#endif

#if defined(MSWIN)
 if (RexxThread(GetCurrentTask(),THREAD_ATTACH) != THREAD_ATTACH_AOK)
    return(RC_INVALID_ENVIRON);
#endif

#if defined(USE_AIXREXX)
 rc = RexxRegisterSubcom((PSZ)"THE",
                         (PRXSUBCOM)&THE_Commands,
                         (PUCHAR)NULL);
#else
 rc = RexxRegisterSubcomExe((PSZ)"THE",
                           (PFN)&THE_Commands,
                           (PUCHAR)NULL);
#endif

 if (rc != RXSUBCOM_OK)
    return((short)rc);

#if !defined(USE_AIXREXX)
 rc = RexxRegisterExitExe((PSZ)"THE_EXIT",
                          (PFN)&THE_Exit_Handler,
                          (PUCHAR)NULL);
 if (rc != RXEXIT_OK)
    return((short)rc);
#endif

 for (i=0;function_item[i].name != NULL;i++)
   {
#if defined(USE_AIXREXX)
    rc = RexxRegisterFunction((PSZ)function_item[i].name,
                              (PRXFUNC)&THE_Function_Handler,NULL);
#else
    rc = RexxRegisterFunctionExe((PSZ)function_item[i].name,
                                 (PFN)&THE_Function_Handler);
#endif
    if (rc != RXFUNC_OK)
       return((short)rc);
   }

#ifdef TRACE
 trace_return();
#endif
 return((short)rc);
}
/***********************************************************************/
short finalise_rexx(void)
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 APIRET rc;
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    finalise_rexx");
#endif

#if defined(USE_AIXREXX)
 rc = RexxDeregisterSubcom((PSZ)"THE");
#else
 rc = RexxDeregisterSubcom((PSZ)"THE",(PSZ)NULL);
 rc = RexxDeregisterExit((PSZ)"THE_EXIT",(PSZ)NULL);
#endif
 for (i=0;function_item[i].name != NULL;i++)
   {
    rc = RexxDeregisterFunction((PSZ)function_item[i].name);
   }

#if defined(MSWIN)
 (void)RexxThread(GetCurrentTask(),THREAD_DETACH);
#endif

#ifdef TRACE
 trace_return();
#endif
 return((short)rc);
}

/***********************************************************************/
short execute_macro_file(CHARTYPE *filename,CHARTYPE *params)
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern WINDOW *foot;
 extern bool in_profile;
 extern bool error_on_screen;
 extern CHARTYPE number_of_files;
 extern CHARTYPE rexx_filename[10];
 extern CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
 extern CHARTYPE *temp_cmd;
 extern bool CAPREXXOUTx;
 extern bool rexx_output;
/*--------------------------- local data ------------------------------*/
#if defined(USE_REGINA) || defined(USE_AIXREXX)
 LONG rexxrc=0L;
#else
 USHORT rexxrc=0L;
#endif
 RXSTRING retstr;
 RXSTRING argstr;
 APIRET rc=0;
 CHAR retbuf[250];
 LONG num_params=0L;
 CHARTYPE *rexx_args=NULL;
 RXSYSEXIT exit_list[2];                /* system exit list           */
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    execute_macro_file");
#endif
/*---------------------------------------------------------------------*/
/* Determine how many parameters are to be passed to the interpreter.  */
/* Only 0 or 1 are valid values.                                       */
/*---------------------------------------------------------------------*/
 if (params == NULL
 || strcmp(params,"") == 0)
   {
    num_params = 0;
    MAKERXSTRING(argstr,"",0);
   }
 else
   {
    num_params = 1;
    if ((rexx_args = (CHARTYPE *)(*the_malloc)(strlen(params)+1)) == (CHARTYPE *)NULL)
      {
       display_error(30,(CHARTYPE *)"",FALSE);
#ifdef TRACE
       trace_return();
#endif
       return(RC_OUT_OF_MEMORY);
      }
    strcpy(rexx_args,params);
    MAKERXSTRING(argstr,rexx_args,strlen(rexx_args));
   }

 MAKERXSTRING(retstr,retbuf,sizeof(retbuf));

/*---------------------------------------------------------------------*/
/* Set up pointer to REXX Exit Handler.                                */
/*---------------------------------------------------------------------*/
#if defined(USE_AIXREXX)
 exit_list[0].sysexit_func = THE_Exit_Handler;
#else
 exit_list[0].sysexit_name = "THE_EXIT";
#endif
 exit_list[0].sysexit_code = RXSIO;
 exit_list[1].sysexit_code = RXENDLST;

 captured_lines = 0L;
 rexx_output = FALSE;
 rexx_halted = FALSE;
/*---------------------------------------------------------------------*/
/* Call the REXX interpreter.                                          */
/*---------------------------------------------------------------------*/
 rc = RexxStart((LONG)num_params,
               (PRXSTRING)&argstr,
               (PSZ)filename,
               (PRXSTRING)NULL,
               (PSZ)"THE",
               (LONG)RXCOMMAND,
               (PRXSYSEXIT)exit_list,
#if defined(USE_OS2REXX)
               (PSHORT)&rexxrc,
#else
               (PLONG)&rexxrc,
#endif
               (PRXSTRING)&retstr);

/*---------------------------------------------------------------------*/
/* Edit the captured file or clean up after REXX output displays.      */
/*---------------------------------------------------------------------*/
 if (rexx_output)
   {
    rexx_output = FALSE;
    if (CAPREXXOUTx)
      {
       fclose(rexxoutfp);
       strcpy(temp_cmd,rexx_pathname);
       strcat(temp_cmd,rexx_filename);
       if (!in_profile)
          Xedit(temp_cmd);
      }
    else
      {
       if (in_profile)
          error_on_screen = TRUE;
       else
/*---------------------------------------------------------------------*/
/* Pause for operator intervention and restore the screen to the       */
/* current screen if there are still file(s) in the ring.              */
/*---------------------------------------------------------------------*/
         {
          printf("\n%s",HIT_ANY_KEY);
          fflush(stdout);
          resume_curses();
/*          (void)my_getch(foot);*/
          (void)my_getch(stdscr);
          if (number_of_files > 0)
             restore_THE();
         }
      }
   }

 if (rexx_args != NULL)
    (*the_free)(rexx_args);
#ifdef TRACE
 trace_return();
#endif
 return((short)rc);
}
/***********************************************************************/
short set_rexx_variable(CHARTYPE *name,CHARTYPE *value,short suffix)
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 SHVBLOCK shv;
 CHAR variable_name[50];
 short rc=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    set_rexx_variable");
#endif

 shv.shvnext=NULL;                                   /* only one block */
 shv.shvcode=RXSHV_SYSET;                          /* symbolic set set */
/*---------------------------------------------------------------------*/
/* This calls the RexxVariablePool() function for each value. This is  */
/* not the most efficient way of doing this.                           */
/*---------------------------------------------------------------------*/
 sprintf(variable_name,"%s.%-d",name,suffix);
 make_upper(variable_name);            /* make variable name uppercase */
/*---------------------------------------------------------------------*/
/* Now (attempt to) set the REXX variable                              */
/* Add name/value to SHVBLOCK                                          */
/*---------------------------------------------------------------------*/
 MAKERXSTRING(shv.shvname, variable_name, strlen(variable_name));
 MAKERXSTRING(shv.shvvalue,value,strlen(value));
/*---------------------------------------------------------------------*/
/* One or both of these is needed, too <sigh>                          */
/*---------------------------------------------------------------------*/
 shv.shvnamelen=strlen(variable_name);
 shv.shvvaluelen=strlen(value);

#if defined(USE_OS2REXX) || defined(USE_AIXREXX)
 rc=(short)RexxVariablePool(&shv);              /* Set the REXX variable */
#else
 rc = RexxVariablePool(&shv);                 /* Set the REXX variable */
 rc = RXSHV_OK;
#endif
 if (rc != RXSHV_OK 
 &&  rc != RXSHV_NEWV)
   {
    display_error(25,(CHARTYPE *)"",FALSE);
    rc = RC_SYSTEM_ERROR;
   }
 else
    rc = RC_OK;
 return(rc);
}
#else
/*---------------------------------------------------------------------*/
/* The following are dummy routines to enable the compliation of THE   */
/* with a nonANSI compiler.                                            */
/*---------------------------------------------------------------------*/
/***********************************************************************/
short initialise_rexx(void)
/***********************************************************************/
{
 return(RC_INVALID_ENVIRON);                        /* force an error */
}
/***********************************************************************/
short finalise_rexx(void)
/***********************************************************************/
{
 return(RC_OK);
}
/***********************************************************************/
short execute_macro_file(filename,params)
CHARTYPE *filename;
CHARTYPE *params;
/***********************************************************************/
{
 return(RC_OK);
}
/***********************************************************************/
short set_rexx_variable(name,value,suffix)
CHARTYPE *name;
CHARTYPE *value;
short suffix;
/***********************************************************************/
{
 return(RC_OK);
}
#endif
