/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 * 
 * 
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed 
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: trace.c 2.0 1995/01/26 16:32:16 MH Release MH $
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
void trace_initialise();
void trace_function();
void trace_return();
void trace_string(char *,...);

char trace_save_str[40];
char trace_env[40];
FILE *trace_fp;
short trace_number,trace_level=(-1);

void trace_initialise()
{
 char *trace_env_ptr=getenv("TRACE");

 trace_fp = NULL;
 if (trace_env_ptr == NULL)
    return;
 strcpy(trace_env,trace_env_ptr);
 trace_number = trace_level = 0;
 return;
}
void trace_function(trace_str)
char *trace_str;
{

 register int i;
 if (trace_level == (-1))
    return;
 if (strcmp(trace_str,trace_save_str) == 0)
   {
    trace_number++;
    trace_level++;
    return;
   }
 trace_fp = fopen(trace_env,"a");
 fprintf(trace_fp,"%5d\n",trace_number);
 for (i=0;i<trace_level;i++)
     fprintf(trace_fp,"  ");
 fprintf(trace_fp,"(%d)%-s",trace_level,trace_str);
 for (i=0;i<60-(trace_level*2)-strlen(trace_str);i++)
     fprintf(trace_fp," ");

 trace_number = 1;
 trace_level++;
 fclose(trace_fp);
 strcpy(trace_save_str,trace_str);
 return;
}
void trace_return()
{
 if (trace_level == (-1))
    return;
 trace_level--;
 if (trace_level < 0)
    fprintf(trace_fp,"****** trace level below zero ********");

 return;
}
void trace_string(char *fmt,...)
{
 va_list args;

 if (trace_level == (-1))
    return;
 va_start(args,fmt);
 trace_fp = fopen(trace_env,"a");
 vfprintf(trace_fp,fmt,args);
 fclose(trace_fp);
 va_end(args);
 return;
}
