/*
 Timer functions for Djgpp;
 File:timerdj.h;
 By Dhonn Lushine; ludhonn@aol.com; http://members.aol.com/ludhonn
 Includes: interrupt handling, delay functions and update functions

 Now it's time to show you a real world example.
 Read int9dj.h for more info.

 Warnings: I am not responsible for any damages.
*/

#include <conio.h>
#include <stdio.h>
#include "timerdj.h"		/* include our timer functions */ 

int timermyfunction;		/* myfunctions timer variable */
void myfunction()		/* callback function */
{
 timermyfunction++;		/* increment my timer */
}
void myfunction_end(){}	/* its like myfunctions_end-myfunction, number of bytes to lock */

void main()
{
 _go32_dpmi_lock_data(&timermyfunction,sizeof(timermyfunction)); /* need to lock memory because hardware interrupts do allow paging */ 
 _go32_dpmi_lock_code(myfunction,(long)myfunction_end-(long)myfunction); /* need to lock code also */

 setbuf(stdout,NULL);		/* fix djgpp's buffered output */
 install_timer(myfunction,TIMER_(30));		/* 30hz timer with myfunction */

 do{
  /* variable timer1ch is incrementing every time a timer interrupt is called */  
  printf("timer1ch==%i,%i=getmovementspeed(),timermyfunction==%i\n",timer1ch,getmovementspeed(),timermyfunction);
 }while(!kbhit());
 getch();

 do{
  /* variable timer1ch is incrementing every time a timer interrupt is called */  
  printf("timer1ch==%i,%i=getmovementspeed(),timermyfunction==%i\n",timer1ch,getmovementspeed(),timermyfunction);
  delayer(2);		/* delayer function has been added now its at 9.1 hz per second */
			/* this will not slow down the timer interrupt or the getmovementspeed() */
 }while(!kbhit());
 getch();

 uninstall_timer();	/* uninstall timer now so I can start a new one */
 install_timer(NULL,TIMER_(30));	/* 30hz timer without my function */

 do{
  int movementspeed=getmovementspeed(); /* call this function once in a game loop where you update moves */
  printf("movementspeed==%i\n",movementspeed);

/* 
 In a game you would use getmovementspeed() to update players moves.
 All you do is call getmovementspeed() once and multiply it by the 
 movementspeed variable that you created. If you have played a choppy game
 this is why it gets choppy. Also choppy because its not updating with 
 the normal frame rate expected. This function fixes slow down.

 Here's some code:
 
 int movementspeed;

 do{
  movementspeed=getmovementspeed();

  // update players based on the timer rate
  // lets say normally you used:
  // players.x+=2;
  // now is modified to this:
  players.x+=2*movementspeed;
  // use movementspeed with all your moving variables
  // use it for moving backgrounds and players
*/

 }while(!kbhit());
 getch();

 do{

  int movementspeed=getmovementspeed(); /* call this function once in a game loop where you update moves */
  printf("movementspeed==%i\n",movementspeed);
  delayer(9);				/* added slowdown to show the features of getmovementspeed() */

 }while(!kbhit());
 getch();

 uninstall_timer();		/* uninstall timer now */
}
