/*
 *	dos2unix.c -- 
 *
 *	converts dos text files to unix text files...
 *
 *	that means:	\r removed
 *			^z removed
 *
 *	USAGE:	dos2unix <filename>  ... if <filename> is not specified,
 *	dos2unix reads from stdin.  In either case, all output is directed
 *	to stdout.
 *
 *
 *ver	user	date		comments
 *1.00	cbo	03/06/90	first draft
 */

#include <stdio.h>
#define NAME	"dos2unix"
static void	err_report();		/* error reporting function */
static FILE	*Fpi;			/* input file pointer */


extern int main(argc, argv)
int	argc;
char	**argv;
{
	register int data;

	/* parse command line, open input file if needed */
	switch (argc) {
	case 1: {
			Fpi = stdin;
			break;
		}
	case 2: {
			if ((Fpi = fopen(*++argv, "r ")) == NULL)
				err_report(1);
			break;
		}
	default: 
		err_report(0);		/* emit usage message */
	}

	/* read file in 1-char-at-a-time... this is extraordinarily
	 * slow but quite reliable across varied platforms.  The
	 * multiple tests are faster on my system than a switch or
	 * single compound test.
	 */
	while ( ! feof(Fpi)) {
		data = fgetc(Fpi);
		if (data == EOF)    break;	/* a null (?) */
		if (data == '\015') continue;	/* a CR */
		if (data == '\026') continue;	/* a control-Z */
		(void) fputc(data,stdout);
	}

	(void) fclose(Fpi);
	exit(0);
}


static void err_report(n)
int	n;
{
	switch (n)  {
	case 0: 
		(void) fprintf(stderr,"Usage: %s <file> \n",NAME);
		break;
	case 1: 
		(void) fprintf(stderr,"%s: Can't open input file.\n",NAME);
		break;
	}

	exit(1);
}

/* EOF */
