/* volume.c   version 1.1   Sat Mar 30 18:44:45 EST 1996
 * Author:  Andy Isaacson <adisaacs@mtu.edu>
 *
 * sets the audio volume on SPARCstations running 4.*
 *
 * Copyright 1996 Andrew Isaacson
 * this software comes with no warranty, either express or implied.
 * This software may be redistributed so long as this copyright notice 
 * is retained on all redistributions.
 *
 * Changes for version 1.1:
 *   prints the range when printing the volume
 *   more informative output
 *   accepts -q option for quieter operation
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sun/audioio.h>
#include <fcntl.h>
#include <errno.h>

void printvol(int);
void setvol(int,int);
void printusage(char *);

audio_info_t info;
/*int audiofd = 0;*/
main(int argc, char* argv[]) {

   int err, vol;
   char opt;
   extern char *optarg;
   extern int optind, opterr;
   opt = getopt(argc, argv, "q");
   if (opt == -1 && argv[1])
      setvol(atoi(argv[1]), 1);
   else if ( opt == '?')
      printusage(argv[0]);
   else if (opt == 'q') {
      if (argv[2]) {
         vol = atoi (argv[2]);
         setvol(vol,0);
      } else
         printvol(0);
   } else
      printvol(1);
}

void printvol(int format)
{
   int err,audiofd = open ("/dev/audioctl", O_RDONLY);
   if (audiofd < 1) {
      perror("volume: /dev/audioctl");
      exit (-1);
   };
   err = ioctl(audiofd, AUDIO_GETINFO, &info);
   if (err) {
      printf("Error %i occurred while getting the volume.\n",err);
      perror ("volume");
      exit(-1);
   }
   if (format)
      printf ("The current audio volume is %i [%i to %i]\n",info.play.gain,
              AUDIO_MIN_GAIN, AUDIO_MAX_GAIN);
   else
      printf ("%i\n",info.play.gain);
}

void setvol(int newvol, int format)
{
   int err, audiofd = open ("/dev/audioctl", O_RDONLY);
   if (audiofd < 1) {
      perror("volume: /dev/audioctl");
      exit (-1);
   }
   if ((newvol < AUDIO_MIN_GAIN)||(newvol > AUDIO_MAX_GAIN)) {
      printf("Invalid volume: %i. Should be in the range %i to %i.\n",newvol,
             AUDIO_MIN_GAIN, AUDIO_MAX_GAIN);
      exit(-1);
   }
   AUDIO_INITINFO(&info);
   info.play.gain = newvol;
    err = ioctl(audiofd, AUDIO_SETINFO, &info);
   if (err) {
      printf("Error %i occurred while setting the volume.\n",err);
      perror ("volume");
      exit(-1);
   }
   printvol(format);
}

void printusage(char *progname)
{
   printf("%s [-q] [vol]: change or view audio volume\n", progname);
   puts(  "volume 1.1    Andrew Isaacson");
   puts("\nOptions:");
   puts("\n     -q     quiet; print just integer value of volume");
   puts(  "     -q vol quiet; set volume and exit");
   puts(  "     vol    set volume and print new volume");
   puts("\n     default: print volume verbosely");
}
