/* wordcnt.c                                   
   program which creates an alphabetical linked list of words from
   a given text file and their occurance (count) in that file.
   compile with 'cc wordcnt.c -O -owordcnt
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

typedef struct list_struct {
    struct list_struct *next;
    char word[16];
    int count;
    } list;

list *head, *current, *prev, *temp, *swap;

void swap_structure(list *up, list *down);

int i = 0, k = 0;
char filename[30];
FILE *filein;
char holdword[16]; /* arbitrarily set max word length to 15 */
main (int argc, char *argv[])
{
register int j;
char tmp;
holdword[0] = '\0';
/* initialize structure */
head = (list *) malloc ( sizeof(list) );
head->next = NULL;
head->count = 0;
strcpy(head->word,"!!!!!!!!!!!!!!!\0");
current = head;
/* get filename if not given and open file */
if (argv[1] == NULL)
   { 
   printf("Enter file name: ");
   gets(filename);
   }
   else strcpy(filename,argv[1]);
if ((filein = fopen(filename,"rb")) == NULL)
   {
   printf("Error opening file.\n");
   exit();
   }
/* read file */
while (!feof(filein))
      {
      tmp = fgetc(filein);
      tmp = toupper(tmp);
      if (isalnum(tmp) != 0 || tmp == '\'')
	 { /* a good character */
	 holdword[i] = tmp;
	 if (i < 14) i++;
	 holdword[i] = '\0';
	 }
	 else
	 { /* parse */
	 if (i != 0)
	    { /* don't add an empty word */
	    current = head;
	    while (current != NULL)
		{
		if (strcmp(current->word,holdword) == 0)
		   { /* word found */
		   current->count++;
                   /* necessary so as not to dup end of list condition */ 
                   current = head;
		   break;
		   }
                if (strcmp(current->word,holdword) > 0)
                   { /* insert a word in the list alphabetically */
                   prev->next = (list *) malloc ( sizeof(list) );
                   prev = prev->next;
                   prev->next = current;
                   strcpy(prev->word,holdword);
                   prev->count = 1;
                   /* necessary so as not to dup end of list condition */ 
                   current = head;
                   break;
                   } 
                prev = current;
		current = current->next;
		}
	    if (current == NULL)
	       { /* not found add a new link to end */
	       prev->next = (list *) malloc ( sizeof(list) );
	       current = prev->next;
	       strcpy(current->word,holdword);
	       current->count = 1;
	       current->next = NULL;
	       }
	    holdword[0] = '\0';
	    i = 0;
	    }
	 }
      }
/* show results */
printf("Word Count Alpha Order of %s\n",filename);
j = 0;
current = head;
while (current != NULL)
    {
    printf("%-16s\t%5u\n",current->word,current->count);
    current = current->next;
    j++;
    }
printf("Total Words %5u\n\n",j);
#ifdef DEBUG
       if (argv[2] != NULL) exit();
       printf("Do you want numeric occurance sort (y/n?) ");
       gets(holdword);
       holdword[0] = toupper(holdword[0]);
       if (holdword[0] == 'N') exit();
#endif
/* sort by occurance */
current = head;
i = 0; k = 0, j = 0;
while (current->next != NULL)
    {
#ifdef DEBUG
       printf("Outer %u\n",i++);
#endif
    swap = current;
    temp = current->next;
    while (temp != NULL)
        {
#ifdef DEBUG
       printf("Inner %u\n",j++);
#endif
        if (temp->count > swap->count)
           { /* 1st key count */ 
           swap = temp;
           }
        if (temp->count == swap->count && 
           (strcmp(temp->word,swap->word) < 0))
           { /* 2nd key word (bubble up) */
           swap_structure(temp,swap);
           }
        temp = temp->next;
        }
    if (current != swap && swap != NULL)
       { /* perform swap if a greater than was found in this pass */
#ifdef DEBUG
       printf("SWAPPING %u\n",k++);
#endif
       swap_structure(swap,current);
       j = 0;
       }
    current = current->next;
    }
/* show results again */
printf("\nWord Count Occurance Order of %s\n",filename);
j=0;
current = head;
while (current != NULL)
    {
    printf("%-16s\t%5u\n",current->word,current->count);
    current = current->next;
    j++;
    }
printf("Total Words %5u\n",j);
return(0);
}

void swap_structure(list *s1, list *s2)
{
list *tp;
tp = (list *) malloc( sizeof(list) );
strcpy(tp->word,s1->word);
strcpy(s1->word,s2->word);
strcpy(s2->word,tp->word);
tp->count = s1->count;
s1->count = s2->count;
s2->count = tp->count;
free(tp);
}

