/*
 * bbsc.c 
 *
 * BBS (Bulletin Board System) written in xenix system V  "C". 
 *
 * Support files needed: bbscdef.h bbscport.o or bbscport.c bbsclock.o or
 * bbsclock.c bbscfile.o or bbscfile.c bbscmisc.o or bbscmisc.c bbscio.o   or
 * bbscio.c bbscarea.o or bbscarea.c bbscmsga.o or bbscmsga.c bbscqust.o or
 * bbscqust.c bbscbult.o or bbscbult.c bbscadds.o or bbscadds.c bbsclist.o or
 * bbsclist.c bbsczip.o  or bbsczip.c bbscconf.c or bbscconf.o bbscsumm.c or
 * .o 
 *
 *
 *                          Sanford J. Zelkovitz
 *
 */
#include "bbsc12.h"
char *basename();
long difft();
main()
{
	int             i, fd;
	char            ptype[2];
	char            pval[18];
	/*
	 * init global variables 
	 */
	Zsec = Ztime = sigreturn = 0;
	if ((inbuf = fopen(CONFIG, "r")) == NULL) {
		portsout("\n\rError opening configuration file!\n\r");
		exit(1);
	}
	if ((fgets(WELCOME, 49, inbuf) == NULL))
		error_config();
	strip(WELCOME);
	if ((fgets(BULLETINS, 49, inbuf) == NULL))
		error_config();
	strip(BULLETINS);
	if ((fgets(NEWUSER, 49, inbuf) == NULL))
		error_config();
	strip(NEWUSER);
	if ((fgets(SYSTEM, 49, inbuf) == NULL))
		error_config();
	strip(SYSTEM);
	if ((fgets(CALLERS, 49, inbuf) == NULL))
		error_config();
	strip(CALLERS);
	if ((fgets(LASTCALL, 49, inbuf) == NULL))
		error_config();
	strip(LASTCALL);
	if ((fgets(USERS, 49, inbuf) == NULL))
		error_config();
	strip(USERS);
	if ((fgets(UNIXMSG, 49, inbuf) == NULL))
		error_config();
	strip(UNIXMSG);
	if ((fgets(DLMSG, 49, inbuf) == NULL))
		error_config();
	strip(DLMSG);
	if ((fgets(HUMOR, 49, inbuf) == NULL))
		error_config();
	strip(HUMOR);
	if ((fgets(HELP, 49, inbuf) == NULL))
		error_config();
	strip(HELP);
	if ((fgets(HELPFILE, 49, inbuf) == NULL))
		error_config();
	strip(HELPFILE);
	if ((fgets(HELPMSG, 49, inbuf) == NULL))
		error_config();
	strip(HELPMSG);
	if ((fgets(USERPRIV, 49, inbuf) == NULL))
		error_config();
	strip(USERPRIV);
	if ((fgets(MAINPRIV, 49, inbuf) == NULL))
		error_config();
	strip(MAINPRIV);
	if ((fgets(FILEPRIV, 49, inbuf) == NULL))
		error_config();
	strip(FILEPRIV);
	if ((fgets(QUESTION, 49, inbuf) == NULL))
		error_config();
	strip(QUESTION);
	if ((fgets(ANSWER, 49, inbuf) == NULL))
		error_config();
	strip(ANSWER);
	if ((fgets(ADDITN, 49, inbuf) == NULL))
		error_config();
	strip(ADDITN);
	if ((fgets(LISTFILES, 49, inbuf) == NULL))
		error_config();
	strip(LISTFILES);
	if ((fgets(TODAY, 98, inbuf) == NULL))
		error_config();
	strip(TODAY);
	if ((fgets(ORGPATH, 49, inbuf) == NULL))
		error_config();
	strip(ORGPATH);
	if ((fgets(AREAS, 49, inbuf) == NULL))
		error_config();
	strip(AREAS);

	strcpy(SIGS, ORGPATH);
	strcat(SIGS, "sigs.bbs");

	if ((fgets(MSGS, 49, inbuf) == NULL))
		error_config();
	strip(MSGS);
	if ((fgets(USRBBS, 49, inbuf) == NULL))
		error_config();
	strip(USRBBS);
	if ((fgets(RB, 49, inbuf) == NULL))
		error_config();
	strip(RB);
	if ((fgets(SB, 49, inbuf) == NULL))
		error_config();
	strip(SB);
	if ((fgets(CRCR, 49, inbuf) == NULL))
		error_config();
	strip(CRCR);
	if ((fgets(CRCS, 49, inbuf) == NULL))
		error_config();
	strip(CRCS);
	if ((fgets(YMDR, 49, inbuf) == NULL))
		error_config();
	strip(YMDR);
	if ((fgets(YMDS, 49, inbuf) == NULL))
		error_config();
	strip(YMDS);
	if ((fgets(YMR, 49, inbuf) == NULL))
		error_config();
	strip(YMR);
	if ((fgets(YMS, 49, inbuf) == NULL))
		error_config();
	strip(YMS);
	if ((fgets(RZ, 49, inbuf) == NULL))
		error_config();
	strip(RZ);
	if ((fgets(SZ, 49, inbuf) == NULL))
		error_config();
	strip(SZ);
	if ((fgets(KS, 49, inbuf) == NULL))
		error_config();
	strip(KS);
	if ((fgets(KRA, 49, inbuf) == NULL))
		error_config();
	strip(KRA);
	if ((fgets(KRE, 49, inbuf) == NULL))
		error_config();
	strip(KRE);
	if ((fgets(SEAR, 49, inbuf) == NULL))
		error_config();
	strip(SEAR);
	if ((fgets(SEAS, 49, inbuf) == NULL))
		error_config();
	strip(SEAS);
	if ((fgets(SYSOP, 49, inbuf) == NULL))
		error_config();
	strip(SYSOP);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	LOGTIME = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	RUNTIME = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	WAITTIME = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	NEWPRIV = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	MAXPRIV = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	MAXSEC = atoi(buf128);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	MAXKBYTE = atoi(buf128);
	if ((fgets(TAR, 49, inbuf) == NULL))
		error_config();
	strip(TAR);
	if ((fgets(ZCAT, 49, inbuf) == NULL))
		error_config();
	strip(ZCAT);
/*
	Starting with version 7.102, the following fgets can just get garbage
   	since the arc file lister is now a built-in ( bbscarc.c )
*/ 
	if ((fgets(ARC, 49, inbuf) == NULL))
		error_config();
	strip(ARC);

/*
	Starting with version 7.102, the following fgets can just get garbage
   	since the zip file lister is now a built-in ( bbscunzip.c )
*/ 
	if ((fgets(ZIP, 49, inbuf) == NULL))
		error_config();
	strip(ZIP);

	if ((fgets(MONITOR, 29, inbuf) == NULL))
		error_config();
	strip(MONITOR);
	if ((fgets(CONSOLE, 29, inbuf) == NULL))
		error_config();
	strip(CONSOLE);
	if ((fgets(SHELL, 29, inbuf) == NULL))
		error_config();
	strip(SHELL);
	if ((fgets(buf128, 49, inbuf) == NULL))
		error_config();
	strip(buf128);
	scan = atoi(buf128);
	if ((fgets(READN, 98, inbuf) == NULL))
		error_config();
	strip(READN);
	if ((fgets(POSTN, 98, inbuf) == NULL))
		error_config();
	strip(POSTN);
	fclose(inbuf);

	strcpy(l_m_base, "0");
	strcpy(l_f_base, "0");
	strcpy(xprt_a, "0");
	strcpy(tggl_a, "1");

	maxkbyte = MAXKBYTE;
	logtime = LOGTIME;
	Ytime = logtime;
	runtime = RUNTIME;
	waittime = WAITTIME;
	newpriv = NEWPRIV;
	max_priv = MAXPRIV;
	strcpy(callers, CALLERS);
	this_ttyname = ttyname(0);
	strcpy(buf128, this_ttyname);
	i = strlen(buf128);
	i--;
	substr(buf128, pval, i, 2);
	strcat(callers, pval);
	strcpy(port_id, pval);
	strcpy(buf128, "/tmp/conf");
	strcat(buf128, pval);
	(void) unlink(buf128);
	strcpy( buf128, ORGPATH );
	strcat( buf128, "inval_port.bbs");
	inbuf = fopen(buf128, "r" );
	if( inbuf != NULL ) {
		while (1) {
			if( fscanf(inbuf, "%s", buf128) == EOF )
				break;
			if(strcmp(basename(buf128),basename(this_ttyname))==0){
				fclose(inbuf);
				portinit();
				setmodes();
				portsout("\n\r\n\rYou called in on a restricted line!\n\r\n\r");
				restoremodes();
				portrst();
				strcpy(buf128, ORGPATH);
				strcat(buf128, "restricted.bbs");
				if((inbuf=fopen(buf128,"a")) != NULL) {
					gettime(ttime);
					GeTdAtE(mm, dd, yy, month, day, year, date, week);
					fd = atoi(mm);
					fd++;
					sprintf(mm, "%.2d", fd);
					(void)fprintf(inbuf, "%s/%s/%s  %s    restricted line caller on %s\n", mm,dd,yy,ttime,this_ttyname);
					fclose(inbuf);
				}
				exit(1);
			}
		}
		fclose(inbuf);
	}
	hold_pipe = FALSE;
	debug = FALSE;
	hold_off = FALSE;
	toggle_hold = FALSE;
	first_time_in = TRUE;
	first_msg_in = TRUE;
	chat_in_progress = FALSE;
	stop_chat = FALSE;
	newuzr = FALSE;
	statcnt = 0;
	last_msg_read = 0;
	xpert = FALSE;
	listed_l = FALSE;
	listed_r = FALSE;
	listed_n = FALSE;
	toggle = TRUE;
	active = TRUE;
	reply_sw = FALSE;
	end_msg = FALSE;
	read_flag = FALSE;
	sys_flag = FALSE;
	strcpy(old_upath, AUTHOR);
	new_msg = 0;
	c_pathname[0] = '\0';
	if_monitor = FALSE;
	no_cntrl_k = FALSE;
	resp_flag = FALSE;
	in_the_buffer = 0;
	user_priv = 1;
	read_number = 1;
	extra_time = 0L;
	extra_size = 0L;
	dload_total = 0L;
	max_dload = 0L;
	blocked_m = 0;
	mpA = 1;
	mpB = 1;
	mpE = 1;
	mpG = 1;
	mpK = 1;
	mpP = 1;
	mpN = 1;
	mpQ = 1;
	mpR = 1;
	mpS = 1;
	mpW = 1;
	mpM = 1;
	mpX = 1;
	mpF = 1;
	mpC = 1;
	mpH = 1;
	mpT = 1;
	mpD = 1;
	mpY = 1;

	mpUSENET = 1;		/* added for 7.2.1 */
	mpRF = 1;
	mpQUEST = 1;
	mpU = 32767;
	mpMS = 1;
	mpCHAT = 1;
	mpCONF = 1;
	mpL = 1;
	fpL = 1;
	fpU = 1;
	fpD = 1;
	fpM = 1;
	fpG = 1;
	fpR = 1;


	strcpy(buf128, STDERR);
	strcat(buf128, port_id);
	STDerr = freopen(buf128, "w+", stderr);
	if (IF_MONITOR) {
		mon_handle = open(MONITOR, O_WRONLY);
		if (mon_handle == -1) {
			portsout("\n\rCritical Error --- End BBS\n\r");
			exit(1);
		}
		if_monitor = FALSE;
		i = getpid();
		itoa(buf128, i);
		strcpy(who_am_i, "/tmp/pid");
		strcat(who_am_i, pval);
		inbuf = fopen(who_am_i, "w");
		fprintf(inbuf, "%s", buf128);
		fclose(inbuf);
	}
	if ((inbuf = fopen(MAINPRIV, "r")) == NULL) {
		portsout("\n\rCritical Error!\n\r");
		portsout("Unable to find main privs!\n\r");
		exit(1);
	}
	while (fscanf(inbuf, "%s%s", ptype, pval) != EOF) {
		ptype[1] = '\0';
		*ptype = toupper(*ptype);
		switch (ptype[0]) {
		case ('B'):
			mpB = atoi(pval);
			break;
		case ('E'):
			mpE = atoi(pval);
			break;
		case ('G'):
			mpG = atoi(pval);
			break;
		case ('K'):
			mpK = atoi(pval);
			break;
		case ('N'):
			mpN = atoi(pval);
			break;
		case ('Q'):
			mpQ = atoi(pval);
			break;
		case ('R'):
			mpR = atoi(pval);
			break;
		case ('S'):
			mpS = atoi(pval);
			break;
		case ('W'):
			mpW = atoi(pval);
			break;
		case ('M'):
			mpM = atoi(pval);
			break;
		case ('X'):
			mpX = atoi(pval);
			break;
		case ('F'):
			mpF = atoi(pval);
			break;
		case ('C'):
			mpC = atoi(pval);
			break;
		case ('H'):
			mpH = atoi(pval);
			break;
		case ('T'):
			mpT = atoi(pval);
			break;
		case ('D'):
			mpD = atoi(pval);
			break;
		case ('Y'):
			mpY = atoi(pval);
			break;
		case ('U'):
			mpU = atoi(pval);
			break;
		case ('P'):
			mpP = atoi(pval);
			break;
		case ('A'):
			mpA = atoi(pval);
			break;
		case ('L'):
			mpL = atoi(pval);
			break;
		case ('&'):
			mpMS = atoi(pval);
			break;
		case ('?'):
			mpZ = atoi(pval);
			break;
		case ('~'):
			mpCHAT = atoi(pval);
			break;
		case ('%'):
			mpQUEST = atoi(pval);
			break;
		case ('$'):
			mpRF = atoi(pval);
			break;
		case ('O'):
			mpCONF = atoi(pval);
			break;
		case ('I'):	/* added for 7.2.1 */
			mpUSENET = atoi(pval);
			break;
		default:
			portsout("\n\rBad entry in MAIN PRIV\n\r");
			break;
		}
	}
	fclose(inbuf);
	if ((inbuf = fopen(FILEPRIV, "r")) == NULL) {
		portsout("\n\rCritical Error!\n\r");
		portsout("Unable to find file privs!\n\r");
		exit(1);
	}
	while (fscanf(inbuf, "%s%s", ptype, pval) != EOF) {
		ptype[1] = '\0';
		*ptype = toupper(*ptype);
		switch (ptype[0]) {
		case ('L'):
			fpL = atoi(pval);
			break;
		case ('U'):
			fpU = atoi(pval);
			break;
		case ('D'):
			fpD = atoi(pval);
			break;
		case ('M'):
			fpM = atoi(pval);
			break;
		case ('G'):
			fpG = atoi(pval);
			break;
		case ('R'):
			fpR = atoi(pval);
			break;
		default:
			portsout("\n\rBad entry in FILE PRIV\n\r");
			break;
		}
	}
	fclose(inbuf);
	w_fname[0] = '\0';
	w_lname[0] = '\0';
	strcpy(w_password, "MPK0");

	u_fname[0] = '\0';
	u_lname[0] = '\0';
	strcpy(u_password, "MPK0");
	u_time1[0] = '\0';
	u_date1[0] = '\0';
	u_time2[0] = '\0';
	u_date2[0] = '\0';
	u_city[0] = '\0';

	mm[0] = '\0';
	dd[0] = '\0';
	yy[0] = '\0';
	month[0] = '\0';
	day[0] = '\0';
	year[0] = '\0';
	date[0] = '\0';
	week[0] = '\0';
	ttime[0] = '\0';

	strcpy(msg_delete, "0");
	msg_no[0] = '\0';
	msg_date[0] = '\0';
	msg_date[0] = '\0';
	msg_time[0] = '\0';
	msg_to[0] = '\0';
	msg_from[0] = '\0';
	msg_pass[0] = '\0';
	msg_subject[0] = '\0';
	msg_text[0] = '\0';
	strfill(msg_text, 0, 1482);

	stop_that = FALSE;

	/* get date and time from the clock      */

	gettime(ttime);
	GeTdAtE(mm, dd, yy, month, day, year, date, week);
	substr(month, mnd, 1, 3);
	strcat(mnd, day);

	fd = atoi(mm);
	fd++;
	sprintf(mm, "%.2d", fd);

	sec = logtime;
	which_timer = 1;
	alarm(sec);

	if (signal(SIGALRM, timer) == (int (*) ()) -1)
		exit(1);
	if (signal(SIGUSR1, mon_toggle) == (int (*) ()) -1)
		exit(1);
	if (signal(SIGUSR2, sys_toggle) == (int (*) ()) -1)
		exit(1);
	if (signal(SIGPIPE, chat) == (int (*) ()) -1)
		exit(1);
	if (signal(SIGINT, STOP) == (int (*) ()) -1)
		exit(1);
	if (signal(SIGHUP, hanged) == (int (*) ()) -1)
		exit(1);


	portinit();		/* init terminal modes */
	setmodes();
	signon();
	driver();
	restoremodes();
	portrst();		/* undo any special modes */
	closer(1);
}
/* end of mainline routine       */

driver()
{
	char            linebuf[MAXLINE], buf[128], *bufptr,	/* ptr to buf */
	                usercd[100],	/* user record */
	               *userptr,/* ptr to usercd */
	                cmd[2];

	int             cnt, ok_sw, case_sw, i, mpk, result, num0, num1, num2;
	long            vtime;

	mpk = mpK;
	cnt = 0;
	ok_sw = TRUE;
	bufptr = buf;
	cmd[0] = '\0';
	if (active) {

		sec = runtime;
		vtime = sec;
		vtime += extra_time;
		if (vtime > 32767L)
			vtime = 32767L;
		if (vtime < 60L)
			vtime = 60L;
		sec = vtime;
		Ytime = sec;
		max_dload = ((long) (maxkbyte)) * 1024L;
		max_dload += extra_size;
		alarm(sec);
		which_timer = 2;
		change_bult();
		today_msg();
		if (scan) {
			if (!newuzr) {
				portsout("\n\rLast time you were on the system: ");
				portsout(z_date);
				portsout(" at ");
				portsout(z_time);
				portsout("\n\r\n\r");
				portsout("\n\rDo you wish to check to see if you have any messages? (Y/n): ");
				portsin(cmd, 1);
				portsout(CRLF);
				if (cmd[0] == 'N' || cmd[0] == 'n')
					check_msga_n();
				else
					check_msga();
				cmd[0] = '\0';
			} else {
				portsout(CRLF);
				portsout("Since you are a new user, the scan for messages will not be performed.\n\r");
				portsout("The next time that you call, all message bases will be scanned.\n\r\n\r");
				check_msga_n();
				portsout("Since you are a new user, you will be asked to fill out our questionnaire.\n\r");
				portsout("Please take the time and fill it out. Thank you.\n\r");
				question(1);
			}
		} else
			check_msga_n();
	}
	while (active) {
		stop_that = FALSE;	/* reset switch */
		portsout(CRLF);
		signal(SIGALRM, timer);
		signal(SIGUSR1, mon_toggle);
		signal(SIGUSR2, sys_toggle);
		signal(SIGPIPE, chat);
		signal(SIGINT, STOP);
		signal(SIGHUP, hanged);
		cmd_t();
		sigreturn = 0;
		bbsmenu(1,0);
		portsin(cmd, 1);
		portsout(CRLF);

		*cmd = toupper(*cmd);

		switch (cmd[0]) {
		case ('V'):
			portsout("\n\r\n\rVersion: ");
			portsout(VERSION);
			portsout("    ");
			portsout(LASTDATE);
			portsout("\n\r\n\r");
			break;
		case ('U'):
			if (!privmsg(mpU))
				break;
			cmd_p(UNIXMSG);
			if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
									 * append */
				portsout(CRLF);
				portsout("Can't open/create callers file!");
				portsout(CRLF);
				return;
			}
			result = fprintf(inbuf, "%s", "   Going into Xenix/Unix");
			if (result < 0) {
				portsout(CRLF);
				portsout("Caller file has problem writing");
				portsout(CRLF);
			} else {
				fputs("\n", inbuf);
			}
			fclose(inbuf);
			restoremodes();
			portrst();
			STDerr = freopen("/dev/tty", "w+", stderr);
			result = system(SHELL);
			strcpy(buf128, STDERR);
			strcat(buf128, port_id);
			STDerr = freopen(buf128, "w+", stderr);
			signal(SIGALRM, timer);
			signal(SIGHUP, hanged);
			signal(SIGUSR1, mon_toggle);
			signal(SIGUSR2, sys_toggle);
			signal(SIGPIPE, chat);
			signal(SIGINT, STOP);
			portinit();
			setmodes();
			break;
		case ('G'):	/* goodby */
			if (!privmsg(mpG))
				break;
			cmd_c();
			break;
		case ('L'):
			if (!privmsg(mpL))
				break;
			who_is_there();
			break;
		case ('Z'):
			if (!privmsg(mpY))
				break;
			cmd_z();
			break;
		case ('R'):
			if (!privmsg(mpRF))
				break;
			file_list();
			break;
		case ('C'):
			if (!privmsg(mpCHAT))
				break;
			sigchat();
			break;
		case ('O'):
			if (!privmsg(mpCONF))
				break;
			conf();
			break;
		case ('E'):
			if (!privmsg(mpCONF))
				break;
			portsout("\n\r\n\rThe following users are presently in conference\n\r");
			no_cntrl_k = 1;
			strcpy(buf128, "ls /tmp/conf* > /tmp/inconf.");
			strcat(buf128, port_id);
			(void) system(buf128);
			strcpy(buf128, "/tmp/inconf.");
			strcat(buf128, port_id);
			if ((otbuf = fopen(buf128, "r")) == NULL) {
				portsout("\n\rError opening list file!\n\r");
				exit(1);
			}
			while (fscanf(otbuf, "%s", who_am_i) != EOF)
				cmd_p(who_am_i);
			fclose(otbuf);
			no_cntrl_k = 0;
			break;
		case ('I'):		/* No need to check privs since
                                           each command has access privs */
			sig_access();
			break;
		case ('Q'):
			if (!privmsg(mpQUEST))
				break;
			question(0);
			break;
		case ('A'):
			if (!privmsg(mpA))
				break;
			additional(ADDITN);
			break;
		case ('D'):
			if (!privmsg(mpD))
				break;
			strcpy(buf128, TODAY);
			strcat(buf128, port_id);
			result = system(buf128);
			strcpy(buf128, "/tmp/today");
			strcat(buf128, port_id);
			cmd_p(buf128);
			break;
		case ('P'):
			if (!privmsg(mpP))
				break;
			ch_password();
			break;
		case ('X'):	/* expert toggle */
			if (!privmsg(mpX))
				break;
			cmd_x();
			rewritx();
			break;
		case ('N'):	/* print new-user stuff */
			if (!privmsg(mpN))
				break;
			cmd_p(NEWUSER);
			break;
		case ('W'):	/* print welcome file */
			if (!privmsg(mpW))
				break;
			cmd_p(WELCOME);
			break;
		case ('B'):	/* print bulletins */
			if (!privmsg(mpB))
				break;
			change_bult();
			break;
		case ('H'):	/* print humor file */
			if (!privmsg(mpH))
				break;
			cmd_p(HUMOR);
			break;
		case ('F'):
			if (!privmsg(mpF))
				break;
			cmd_f();
			break;
		case ('M'):
			if (!privmsg(mpMS))
				break;
			msg_section(mpk);
			break;
		case ('T'):
			if (!privmsg(mpT))
				break;
			toggle = !toggle;
			rewritx();
			if (toggle) {
				portsout("\n\rStop Mode\n\r");
			} else {
				portsout("\n\rContinuous Mode\n\r");
			}
			break;
		case ('?'):	/* help */
			if (!privmsg(mpZ))
				break;
			cmd_p(HELP);
			break;
		case ('S'):	/* added for 7.2.1  USENET ACCESS */
			if (!privmsg(mpUSENET))
				break;
			usenet();
			break;
		default:
			break;
		}

	}
}
/* end of function               */
sigchat()
{
	char           *ttyzz;
	char            tb[80];
	int             result, handle;
	static char     bell = '\007';
	if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
	result = fprintf(inbuf, "%s", "   Requesting a chat");
	if (result < 0) {
		portsout(CRLF);
		portsout("Caller file has problem writing");
		portsout(CRLF);
	} else {
		fputs("\n", inbuf);
	}
	fclose(inbuf);
	result = stat(SYSTTY, &statbuf);
	if (!result) {
		strcpy(buf128, "\n\r\n\r");
		strcat(buf128, SYSOP);
		strcat(buf128, " is already engaged in a chat or has turned it off.\n\r\n\r");
		portsout(buf128);
		return;
	}
	handle = open(CONSOLE, O_WRONLY);
	if (handle == -1) {
		portsout("\n\rError opening console driver!\n\r");
		exit(1);
	}
	ttyzz = ttyname(1);
	strcpy(tb, "\n\rChat requested by ");
	strcat(tb, w_fname);
	strcat(tb, " ");
	strcat(tb, w_lname);
	strcat(tb, " on ");
	strcat(tb, ttyzz);
	strcat(tb, "\n\r");
	write(handle, tb, (strlen(tb)));
	Xsec = 0;
	stop_chat = FALSE;
	portsout("\n\rPaging: ");
	for (result = 0; result <= 30; result++) {
sigloop:
		if (stop_chat) {
			portsout(CRLF);
			close(handle);
			return;
		}
		Sec = alarm(0);
		hold_pipe = TRUE;
		alarm(Sec);
		hold_pipe = FALSE;
		if (Sec != Xsec) {
			if (stop_chat) {
				portsout(CRLF);
				close(handle);
				return;
			}
			Xsec = Sec;
			portsout(". ");
			write(handle, &bell, 1);
		} else
			goto sigloop;
	}
	strcpy(buf128, "\n\rI am sorry; however, ");
	strcat(buf128, SYSOP);
	strcat(buf128, " is unavailable to chat with you.\n\r");
	portsout(buf128);
	close(handle);
}

ch_password()
{
	int             result, char_in_passwd;
	char           *pptr;
	while (1) {
in_passx:
		portsout(CRLF);
		portsout("Ok, now I need a 4  to 10 character password ===> ");
		portsinz(u_password, 10);
		portsout(CRLF);
		char_in_passwd = strlen(u_password);
		if (char_in_passwd < 4) {
			portsout("\n\rPassword was NOT changed!\n\r");
			return;
		}
		pptr = strchr(u_password, '~');
		if (pptr != NULL) {
			portsout("\n\rInvalid password   try again!\n\r");
			goto in_passx;
		}
		pptr = strchr(u_password, ' ');
		if (pptr != NULL) {
			portsout("\n\rInvalid password   try again!\n\r");
			goto in_passx;
		}
		portsout("Just to make sure, enter it again ===> ");
		portsinz(w_password, 10);
		result = strlen(w_password);
		if (result != char_in_passwd)
			goto passwx_loop;
		portsout(CRLF);

		if (strcmp(u_password, w_password) == 0) {
			result = 10 - result;
			while (result) {
				strcat(u_password, " ");
				result--;
			}
			break;	/* get it right twice, then get out */
		}
passwx_loop:
		portsout(CRLF);
		portsout("hmmmm, one of us forgot it already");
		portsout(CRLF);
		portsout("      let's try it again!!");
		portsout(CRLF);
		portsout(CRLF);
	}
	if ((inbuf = fopen(USERS, "r+")) == NULL) {
		portsout("\n\rError opening users file!\n\r");
		exit(1);
	}
	fds = fileno(inbuf);
	rewind(inbuf);
	locking(fds, LK_LOCK, 0L);
	result = fseek(inbuf, save_d_pos, 0);
	rewrtuser(inbuf);
	rewind(inbuf);
	locking(fds, LK_UNLCK, 0L);
	fclose(inbuf);
}

msg_section(mpk)
	int             mpk;
{
	char            cmd[81];
	char		tmp_cmd[80];
	char		*cmd_ptr, *tmp_cmd_ptr;
	int             result, tmp_number;
	char           *file_ptr_x;
	if (first_msg_in) {
		result = atoi(l_m_base);
		change_msga(result);
		check_mail();
	}
	first_msg_in = FALSE;
msg_looper:
	signal(SIGALRM, timer);
	signal(SIGHUP, hanged);
	signal(SIGUSR1, mon_toggle);
	signal(SIGUSR2, sys_toggle);
	signal(SIGPIPE, chat);
	signal(SIGINT, STOP);
	stop_that = FALSE;
	cmd_t();
	portsout("\n\rCurrent message area = ");
	strcpy(buf128, m_pathname);
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x = '\0';
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x++;
	strcpy(who_am_i, file_ptr_x);
	portsout(who_am_i);
	portsout(CRLF);
	portsout(CRLF);
	bbsmenu(2,mpk);
	portsin_cmp(cmd, 80, "KkQqSsRrYyCcEeNnMmGgXxTt?");
	portsout(CRLF);

	if(cmd[0] != 'B' && cmd[0] != 'b')
		fix_name(cmd);

	switch (cmd[0]) {
	case ('E'):		/* enter msg */
		if (!privmsg(mpE))
			goto msg_looper;
		cmd_e();
		goto msg_looper;
	case ('N'):		/*Enter BLOCKED message */
		if(!privmsg(mpE))
			goto msg_looper;
		blocked_m = 1;
		cmd_e();
		blocked_m = 0;
		goto msg_looper;
	case ('G'):		/* goodby */
		if (!privmsg(mpG))
			goto msg_looper;
		cmd_c();
		break;
	case ('T'):
		if (!privmsg(mpT))
			goto msg_looper;
		toggle = !toggle;
		rewritx();
		if (toggle) {
			portsout("\n\rStop Mode\n\r");
		} else {
			portsout("\n\rContinuous Mode\n\r");
		}
		goto msg_looper;
	case ('X'):
		if (!privmsg(mpX))
			goto msg_looper;
		cmd_x();
		rewritx();
		goto msg_looper;
	case ('K'):
		if (!privmsg(mpk))
			goto msg_looper;
		cmd_k();
		goto msg_looper;
	case ('Q'):		/* quick scan */
		if (!privmsg(mpQ))
			goto msg_looper;
		cmd_q();
		goto msg_looper;
	case ('R'):		/* read msg */
		if (!privmsg(mpR))
			goto msg_looper;
		cmd_r();
		goto msg_looper;
	case ('B'):
	case ('b'):
		if(!privmsg(mpR))
			goto msg_looper;
		cmd_ptr = cmd;
		cmd_ptr++;
		tmp_number=strlen(cmd_ptr);
		if(!tmp_number)
			{
			portsout("\n\r\n\rNo messages selected in batch command!\n\r\n\r");
			goto msg_looper;
			}
		digit(cmd_ptr);
		while(*cmd_ptr)
			{
			tmp_cmd_ptr = tmp_cmd;
			if(*cmd_ptr == (char) ' ')
				{
				cmd_ptr++;
				continue;
				}
			while(*cmd_ptr != (char) ' ')
				{
				if(*cmd_ptr == (char) '\0')
					break;
				*tmp_cmd_ptr++ = *cmd_ptr++;
				}
			*tmp_cmd_ptr = (char)'\0';
			read_number = atoi(tmp_cmd);
			read_flag = TRUE;
			cmd_r();
			read_flag = FALSE;
			portsout(CRLF);
			portsout("*** Depress a key to continue ( control-k to quit ) ........ ");
			jnk[0] = portin();
			if (jnk[0] == CTL_K || stop_that)
				{
				stop_that = FALSE;
				goto msg_looper;
				}
				
			}
		goto msg_looper;
			
		
	case ('Y'):
		if (!privmsg(mpY))
			goto msg_looper;
		cmd_y();
		goto msg_looper;
	case ('S'):		/* scan msg */
		if (!privmsg(mpS))
			goto msg_looper;
		cmd_s();
		goto msg_looper;
	case ('C'):
		if (!privmsg(mpC))
			goto msg_looper;
		check_mail();
		goto msg_looper;
	case ('M'):
		break;
	case ('?'):		/* help */
		if (!privmsg(mpZ))
			goto msg_looper;
		cmd_p(HELPMSG);
		goto msg_looper;
	case ('A'):
		result = strlen(cmd);
		result--;
		if (!result)
			change_msga(0);
		else {
			substr(cmd, buf128, 2, result);
			digit(buf128);
			result = atoi(buf128);
			change_msga(result);
		}
		check_mail();
		goto msg_looper;
	default:
		goto msg_looper;
	}
}

privmsg(priv)
	int             priv;
{
	if (user_priv >= priv)
		return (TRUE);
	portsout("\n\rI'm sorry, your privilege level is not high enough to use that option.\n\r");
	return (FALSE);
}
cmd_c()
{				/* go to the operating system level */
	char            well[3];
	int             length;
	if (resp_flag) {
		portsout("\n\r\n\rAre you sure you want to exit? (Y/n): ");
		portsin(well, 1);
		portsout(CRLF);
		if (well[0] == 'N' || well[0] == 'n')
			return;
	}
	length = strlen(c_pathname);
	if (resp_flag && length > 0) {
		portsout(CRLF);
		strcpy(buf128, "Would you like to leave a private message for ");
		strcat(buf128, SYSOP);
		strcat(buf128, "? (y/N): ");
		portsout(buf128);
		portsin(well, 1);
		portsout(CRLF);
		if (well[0] == 'y' || well[0] == 'Y') {
			portsout("\n\rDo you wish to use blocked (right justified) format?  (y/N: ");
			portsin(well, 1);
			portsout(CRLF);
			if (well[0] == 'y' || well[0] == 'Y') 
				blocked_m = 1;
			else
				blocked_m = 0;
			strcpy(m_pathname, c_pathname);
			hdrread();
			reply_sw = TRUE;
			strcpy(msg_to, SYSOP);
			strcpy(msg_subject, "Departure Message");
			end_msg = TRUE;
			cmd_e();
			reply_sw = FALSE;
		}
	}
	if ((inbuf = fopen(SYSTEM, "r")) == NULL) {
		portsout("\n\rError opening system file!\n\r");
		exit(1);
	} else {
		no_cntrl_k = TRUE;
		porttype(inbuf);/* type a file to port */
		fclose(inbuf);
	}
	active = FALSE;
}
/* end of function               */
cmd_t()
{
	int             minutes, seconds;
	xsec = alarm(0);
	sec = xsec;
	alarm(sec);
	minutes = xsec / 60;
	seconds = xsec - (minutes * 60);
	portsout(CRLF);
	portsout("Time left = ");
	itoa(bufy, minutes);
	strcpy(bufx, bufy);
	strcat(bufx, " minutes and ");
	itoa(bufy, seconds);
	strcat(bufx, bufy);
	strcat(bufx, " seconds");
	portsout(bufx);
	portsout(CRLF);
}

cmd_tt(tt) int tt;
{
	int             minutes, seconds;
	long		tottime;
	tottime = difft();
	minutes = (int)tottime / 60L;
	seconds = (int)tottime - (long)(minutes * 60);
	itoa(bufy, minutes);
	strcpy(bufx, bufy);
	strcat(bufx, " minutes and ");
	itoa(bufy, seconds);
	strcat(bufx, bufy);
	strcat(bufx, " seconds");
}

int
timer()
{
	portsout(CRLF);
	if (which_timer == 1)
		portsout("Your login time limit has been reached!");
	if (which_timer == 2)
		portsout("Your usage time limit has been reached!");
	if (which_timer == 3)
		portsout("Your response time limit has been reached!");
	portsout(CRLF);
	restoremodes();
	portrst();		/* undo any special modes */
	closer(2);
	exit(1);
}
int
hanged()
{
	restoremodes();
	portrst();
	closer(3);
	exit(1);
}

closer(typeclose)
int typeclose;
{
	int result;
	if(typeclose == 2)
		cmd_tt(0);
	else
		cmd_tt(1);
	if ((inbuf = fopen(callers, "a")) == NULL)
		exit(1);
	result = fprintf(inbuf, "Time used on the system = %s\n",bufx);
	if (result < 0)
		exit(1);
	switch(typeclose) {
	case (1): fprintf(inbuf, "Normal exit .....\n");
			break;
	case (2): fprintf(inbuf, "Limit exit .....");
			switch (which_timer) {
			case(1): fprintf(inbuf, "logon\n");
				break;
			case(2): fprintf(inbuf, "usage\n");
				break;
			case(3): fprintf(inbuf, "response\n");
				break;
			}
			break;
	case (3): fprintf(inbuf, "The user just hung up! .....\n");
			break;
	case (4): fprintf(inbuf, "The user forgot his password! .....\n");
			break;
	default:  fprintf(inbuf, "Ooooops .... This exit is not known! .....\n");
			break;
	}

	fprintf(inbuf,"\n\n");
	fclose(inbuf);
}
int
mon_toggle()
{
	signal(SIGUSR1, mon_toggle);
	if (!chat_in_progress)
		if_monitor = !if_monitor;
	else
		chat_in_progress = !chat_in_progress;
}
int
STOP()
{
	signal(SIGINT, STOP);
	stop_that = TRUE;
}
int
chat()
{
	FILE           *dev;
	int             result, handle;
	char            byte, byten, byter, bytes, device[30];
	signal(SIGPIPE, chat);
	byten = (char) '\n';
	byter = (char) '\r';
	bytes = (char) ' ';
	chat_in_progress = TRUE;
	stop_chat = TRUE;
	if (hold_pipe) {
		alarm(Sec);
		hold_pipe = FALSE;
	}
	Xsec = alarm(0);
	if ((dev = fopen(SYSTTY, "r")) == NULL) {
		portsout_chat("\n\rError finding sysop's device driver!\n\r");
		exit(1);
	}
	if ((fgets(device, 29, dev) == NULL)) {
		portsout_chat("\n\rError reading sysop's device driver name!\n\r");
		exit(1);
	}
	fclose(dev);
	strip(device);
	handle = open(device, O_WRONLY);
	if (handle == -1) {
		portsout_chat("\n\rError opening sysop's device driver!\n\r");
		exit(1);
	}
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat("********** THE SYSOP HAS STARTED CHAT MODE ********");
	portsout_chat(CRLF);
	portsout_chat("*** Your usage time has stopped during the chat ***");
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	while (chat_in_progress) {
		byte = portin_chat();
		if (byte == 127)
			byte = '\b';
		portout_chat(byte);
		if (byte == '\n')
			portout_chat(byter);
		if (byte == '\r')
			portout_chat(byten);
		write(handle, &byte, 1);
		if (byte == '\n')
			write(handle, &byter, 1);
		if (byte == '\r')
			write(handle, &byten, 1);
		if (byte == '\b') {
			write(handle, &bytes, 1);
			portout_chat(bytes);
			write(handle, &byte, 1);
			portout_chat(byte);
		}
	}
	close(handle);
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat("********** THE SYSOP HAS STOPPED CHAT MODE **********");
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	portsout_chat(CRLF);
	alarm(Xsec);
}

int
sys_toggle()
{
	signal(SIGUSR2, sys_toggle);
	if (!toggle_hold && hold_off) {
		toggle_hold = TRUE;
		return;
	}
	toggle_hold = FALSE;
	if (!sys_flag) {
		old_priv = user_priv;
		user_priv = max_priv;
		if (max_priv != MAXPRIV) {
			sprintf(buf128, "\n\rCompiler error max=%d  MAX=%d\n\r", max_priv, MAXPRIV);
			portsout(buf128);
			exit(1);
		}
		strcpy(old_upath, u_pathname);
		strcpy(old_fpath, f_pathname);
		strcpy(old_mpath, m_pathname);
		old_sec = alarm(0);
		alarm(MAXSEC);
	} else {
		user_priv = old_priv;
		strcpy(u_pathname, old_upath);
		strcpy(f_pathname, old_fpath);
		strcpy(m_pathname, old_mpath);
		if (!first_msg_in)
			hdrread();
		delta_time = old_sec;
		delta_time = delta_time - (MAXSEC - alarm(0));
		if (delta_time < 0L || delta_time > 32767L)
			delta_time = 5L;
		sec = delta_time;
		alarm(sec);
	}
	sys_flag = !sys_flag;
}
cmd_f()
{
	char            choice[6];
	char           *file_ptr_x;
	long            bytes_left;
	int             result;
	listed_l = FALSE;
	listed_r = FALSE;
	listed_n = FALSE;
	if (first_time_in) {
		result = atoi(l_f_base);
		change_area(result);
	}
	first_time_in = FALSE;
ffile:
	portsout(CRLF);
	portsout(CRLF);
	signal(SIGALRM, timer);
	signal(SIGHUP, hanged);
	signal(SIGUSR1, mon_toggle);
	signal(SIGUSR2, sys_toggle);
	signal(SIGPIPE, chat);
	signal(SIGINT, STOP);
	cmd_t();
	portsout("\n\rCurrent download area = ");
	strcpy(buf128, f_pathname);
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x = '\0';
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x++;
	strcpy(who_am_i, file_ptr_x);
	portsout(who_am_i);
	portsout("\n\rCurrent upload area = ");
	strcpy(buf128, u_pathname);
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x = '\0';
	file_ptr_x = strrchr(buf128, '/');
	*file_ptr_x++;
	strcpy(who_am_i, file_ptr_x);
	portsout(who_am_i);
	portsout(CRLF);
	bytes_left = max_dload - dload_total;
	strcpy(buf128, "Allowable daily download limit = ");
	sprintf(who_am_i, "%ld", bytes_left);
	strcat(buf128, who_am_i);
	strcat(buf128, " bytes\n\r");
	portsout(buf128);
	stop_that = FALSE;
	bbsmenu(3,0);
	portsin_cmp(choice, 5, "FfLlUuDdMmXxTtGgCcRrNnSsZz?");
	portsout(CRLF);
	fix_name(choice);
	switch (choice[0]) {
	case ('S'):
		if (!privmsg(fpL))
			goto ffile;
		summary();
		goto ffile;
	case ('L'):
		if (!privmsg(fpL))
			goto ffile;
		listed_r = FALSE;
		listed_n = FALSE;
		listed_l = FALSE;
		file_loc( NULL );
		goto ffile;
	case ('F'):
		if (!privmsg(fpL))
			goto ffile;
		listed_r = FALSE;
		listed_n = FALSE;
		file_l();
		listed_l = TRUE;
		goto ffile;
	case ('N'):
		if (!privmsg(fpL))
			goto ffile;
		listed_r = FALSE;
		listed_l = FALSE;
		file_n();
		listed_n = TRUE;
		goto ffile;
	case ('Z'):
		if (!privmsg(fpL))
			goto ffile;
		listed_r = FALSE;
		listed_l = FALSE;
		listed_n = FALSE;
		allnew();
		goto ffile;
	case ('?'):		/* help */
		if (!privmsg(mpZ))
			goto ffile;
		cmd_p(HELPFILE);
		goto ffile;
	case ('R'):
		if (!privmsg(fpR))
			goto ffile;
		listed_l = FALSE;
		listed_n = FALSE;
		file_r();
		listed_r = TRUE;
		goto ffile;
	case ('C'):
		if (!privmsg(fpL))
			goto ffile;
		listed_l = FALSE;
		listed_r = FALSE;
		listed_n = FALSE;
		file_c();
		goto ffile;
	case ('T'):
		if (!privmsg(mpT))
			goto ffile;
		toggle = !toggle;
		rewritx();
		if (toggle) {
			portsout("\n\rStop Mode\n\r");
		} else {
			portsout("\n\rContinuous Mode\n\r");
		}
		goto ffile;
	case ('A'):
		result = strlen(choice);
		result--;
		if (!result)
			change_area(0);
		else {
			substr(choice, buf128, 2, result);
			digit(buf128);
			result = atoi(buf128);
			change_area(result);
		}
		listed_r = FALSE;
		listed_l = FALSE;
		listed_n = FALSE;
		goto ffile;
	case ('X'):
		if (!privmsg(mpX))
			goto ffile;
		cmd_x();
		rewritx();
		goto ffile;
	case ('U'):
		if (!privmsg(fpU))
			goto ffile;
		file_u();
		listed_r = FALSE;
		listed_l = FALSE;
		listed_n = FALSE;
		goto ffile;
	case ('D'):
		if (!privmsg(fpD))
			goto ffile;
		file_d();
		goto ffile;
	case ('M'):
		if (!privmsg(fpM))
			goto ffile;
		listed_l = FALSE;
		listed_r = FALSE;
		listed_n = FALSE;
		break;
	case ('G'):
		if (!privmsg(fpG))
			goto ffile;
		cmd_c();
		break;
	default:
		goto ffile;
	}
}
file_c()
{
	int             result, zcat;
	char           *ptr, temp[16];
	zcat = 0;
	portsout("\n\r\n\rArchive Contents Listing Option for .tar(.Z), .zip  or .arc files\n\r\n\r");
	portsout("Input archive file name to list ====> ");
	portsin(x_filename, 15);
	portsout(CRLF);
	if (strlen(x_filename) < 1)
		return;
	strcpy(x_pathandfile, f_pathname);
	strcat(x_pathandfile, x_filename);
	ptr = strrchr(x_pathandfile, '.');
	if (ptr == NULL) {
		portsout("\n\rImproper file extension\n\r");
		return;
	}
	*ptr++;
	strcpy(temp, ptr);
	if (strcmp(temp, "Z") == 0) {
		zcat = 1;
		strcpy(buf128, x_pathandfile);
		ptr = strrchr(buf128, '.');
		if (ptr == NULL) {
			portsout("\n\rImproper file extension\n\r");
			return;
		}
		*ptr = '\0';
		ptr = strrchr(buf128, '.');
		if (ptr == NULL) {
			portsout("\n\rImproper file extension\n\r");
			return;
		}
		*ptr++;
		strcpy(temp, ptr);
	}
	if ((strcmp(temp, "arc") == 0) || (strcmp(temp, "ARC") == 0) || (strcmp(temp, "tar") == 0) || (strcmp(temp,"zip") == 0) || (strcmp(temp,"ZIP") ==0)) {
		result = stat(x_pathandfile, &statbuf);
		if (result != 0) {
			portsout("\n\r\n\rThe requested file was not found!\n\r\n\r");
			return;
		}
		if ((strcmp(temp, "arc") == 0 || strcmp(temp, "ARC") == 0)) {
			listarc(x_pathandfile, port_id);
/*
			strcpy(buf128, ARC);
			strcat(buf128, x_pathandfile);
			strcat(buf128, " > ");
			strcat(buf128, TMPFILE);
			strcat(buf128, port_id);
			(void) system(buf128);
*/

			strcpy(buf128, "/tmp/arclst.");
			strcat(buf128, port_id);

			portsout("\n\r\n\r");
/*
			strcpy(buf128, TMPFILE);
			strcat(buf128, port_id);
*/
			cmd_p(buf128);
			portsout("\n\r\n\r");
			return;
		}
		if ((strcmp(temp, "zip") == 0 || strcmp(temp, "ZIP") == 0)) {

			listzip( x_pathandfile, port_id);
/*
			strcpy(buf128, ZIP);
			strcat(buf128, x_pathandfile);
			strcat(buf128, " > ");
			strcat(buf128, TMPFILE);
			strcat(buf128, port_id);
			(void) system(buf128);
*/

			strcpy(buf128, "/tmp/ziplst.");
			strcat(buf128, port_id);

			portsout("\n\r\n\r");
/*
			strcpy(buf128, TMPFILE);
			strcat(buf128, port_id);
*/
			cmd_p(buf128);
			portsout("\n\r\n\r");
			return;
		}
		if (strcmp(temp, "tar") == 0) {
			if (!zcat) {
				strcpy(buf128, TAR);
				strcat(buf128, x_pathandfile);
			} else {
				strcpy(buf128, ZCAT);
				strcat(buf128, x_pathandfile);
				strcat(buf128, " | ");
				strcat(buf128, TAR);
				strcat(buf128, "-");
			}

			strcat(buf128, " > ");
			strcat(buf128, TMPFILE);
			strcat(buf128, port_id);
			portsout("\n\rOne moment please ....");
			(void) system(buf128);
			portsout("\n\r\n\r");
			strcpy(buf128, TMPFILE);
			strcat(buf128, port_id);
			cmd_p(buf128);
			portsout("\n\r\n\r");
			return;
		}
	}
	portsout("\n\r\n\rIllegal file extension!\n\r\n\r");
}
file_r()
{
	int             result;
	if (!listed_r) {
		portsout("\n\rOne moment please ....");
		strcpy(buf128, "ls -l ");
		strcat(buf128, f_pathname);
		strcat(buf128, " > ");
		strcat(buf128, TMPFILE);
		strcat(buf128, port_id);
		(void) system(buf128);
	}
	portsout("\n\r\n\r");
	strcpy(buf128, TMPFILE);
	strcat(buf128, port_id);
	cmd_p(buf128);
	portsout("\n\r\n\r");
}
msgck()
{
	portsout("A control-k will terminate the listing\n");
}
file_l()
{
	int             result;
	int             zz;
	char            timeptr[30];
	char           *fileptr;
	int             lnctx, xp;
	lnctx = 1;
	if (xpert)
		xp = 10;
	else
		xp = 5;
	xyy = atol(yy);
	strcpy(buf128, f_pathname);
	strcat(buf128, FILES);
	if ((rdstatbuf = fopen(buf128, "r")) == NULL) {
		portsout("\n\rThe are NO files available!\n\r");
		return;
	}
	msgck();
	portsout(CRLF);
	strcpy(buf128, TMPFILE);
	strcat(buf128, port_id);
	while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
		zz = 0;
		if (x_filename[0] == '~') {
			goto finis;	/* Special case so that that
					 * following files are not displayed
					 * - can be used to disallow uploads
					 * from being shown until they are
					 * validated. */
		}
		if (x_filename[0] == '+') {
			fileptr = x_filename + 1;
			strcpy(work_msg, fileptr);
			(void) fgets(buf128, 80, rdstatbuf);
			strcat(work_msg, buf128);
			strip(work_msg);
			goto arond;
		}
		if (x_filename[0] == '.') {
			strcpy(x_filename, "   ");
			strcpy(who_am_i, "   ");
			strcpy(who_am_I, "   ");
			zz++;
		}
		if (result = fgets(buf128, 55, rdstatbuf) == NULL) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		strip(buf128);
		if (!zz)
			term_space(buf128);
		result = strlen(buf128);
		if (result == 0) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		if (!zz) {
			strcpy(x_pathandfile, f_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				strcpy(who_am_i, "OFFLINE");
				strcpy(who_am_I, "    ");
				goto around;
			}
			xmm = statbuf.st_size;
			sprintf(who_am_i, "%6ld", xmm);
			xmm = statbuf.st_mtime;
			strcpy(timeptr, ctime(&xmm));
			substr(timeptr, bufx, 5, 6);
			substr(timeptr, z_dd, 23, 2);
			xmm = atol(z_dd);
			if (xyy > xmm) {
				substr(timeptr, bufx, 5, 3);
				strcat(bufx, "-");
				strcat(bufx, z_dd);
			}
			strcpy(who_am_I, bufx);
		}
around:
		sprintf(work_msg, "%-15s%-7s%-6s%-50s", x_filename, who_am_i, who_am_I, buf128);
arond:
		strip(work_msg);
		term_space(work_msg);

		sprintf(buf128, "%s\n\r", work_msg);
		portsout(buf128);
		if (stop_that) {
			fclose(rdstatbuf);
			stop_that = FALSE;
			return;
		}
		if (toggle) {
			lnctx++;
			if (lnctx == 23) {
				portsout(CRLF);
				portsout("*** Depress a key to continue ( control-k to quit ) ........ ");
				jnk[0] = portin();
				if (jnk[0] == CTL_K || stop_that) {
					stop_that = FALSE;
					fclose(rdstatbuf);
					return;
				}
				portsout(CRLF);
				lnctx = 1;
			}
		}
	}
finis:
	fclose(rdstatbuf);
finisl:
	if (toggle && lnctx > xp) {
		portsout(CRLF);
		portsout("*** Depress a key to continue ........ ");
		jnk[0] = portin();
		portsout(CRLF);
	}
	portsout(CRLF);
	portsout(CRLF);
}
file_loc( strg )
char *strg;
{
	int             result;
	int             i;
	int             zz;
	int             outok;
	int             len_in, len_file, times;
	long            foo;
	char            timeptr[30];
	char           *fileptr;
	char            temp[15];
	char            string_loc[20];
	int             lnctx, xp;
	
	if (xpert)
		xp = 10;
	else
		xp = 5;


	lnctx = 1;
	substr(z_date, z_mm, 1, 2);
	substr(z_date, z_dd, 4, 2);
	substr(z_date, z_yy, 7, 2);
	xmm = atol(z_mm);
	xdd = atol(z_dd);
	xyy = atol(z_yy);
	foo = atol(yy);
	outok = FALSE;
	old_long_date = (xyy * 10000L) + (xmm * 100L) + xdd;
	if( strg == NULL) {
		portsout("\n\r\n\rInput file name substring (max 14 characters): ");
		portsin(string_loc, 14);
		portsout(CRLF);
		fileptr = strchr(string_loc, '*');
		if( fileptr != NULL ) {
			portsout("\n\rDo not use an asterisk as part of the string.\n\r\n\r");
			return;
		}
	} else {
		strcpy(string_loc, strg );
	}
	len_in = strlen(string_loc);
	if (!len_in)
		return;
	strcpy(buf128, f_pathname);
	strcat(buf128, FILES);
	if ((rdstatbuf = fopen(buf128, "r")) == NULL) {
		portsout("\n\rThe are NO files available!\n\r");
		return;
	}
	msgck();
	portsout("\n\rSearching for a comparison\n\r\n\r");
	while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
		zz = 0;
		if (x_filename[0] == '~') {
			goto finisx;	/* Special case so that that
					 * following files are not displayed
					 * - can be used to disallow uploads
					 * from being shown until they are
					 * validated. */
		}
		if (x_filename[0] == '+') {
			fileptr = x_filename + 1;
			strcpy(work_msg, fileptr);
			(void) fgets(buf128, 80, rdstatbuf);
			goto xend;
		}
		if (x_filename[0] == '.') {
			strcpy(x_filename, "   ");
			strcpy(who_am_i, "   ");
			strcpy(who_am_I, "   ");
			zz++;
		}
		if (result = fgets(buf128, 55, rdstatbuf) == NULL) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		strip(buf128);
		if (!zz)
			term_space(buf128);
		result = strlen(buf128);
		if (result == 0) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		if (!zz) {
			len_file = strlen(x_filename);
			if (len_file < len_in) {
				outok = FALSE;
				goto xend;
			}
			strcpy(x_pathandfile, f_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				strcpy(who_am_i, "OFFLINE");
				strcpy(who_am_I, "    ");
				outok = FALSE;
				goto xend;
			}
			xmm = statbuf.st_size;
			sprintf(who_am_i, "%6ld", xmm);
			xmm = statbuf.st_mtime;
			strcpy(timeptr, ctime(&xmm));
			substr(timeptr, bufx, 5, 6);
			strcpy(who_am_I, bufx);
			substr(timeptr, bufx, 5, 3);
			substr(timeptr, z_dd, 9, 2);
			substr(timeptr, z_yy, 23, 2);
			xdd = atol(z_dd);
			xyy = atol(z_yy);
			if (foo > xyy) {
				strcpy(who_am_I, bufx);
				strcat(who_am_I, "-");
				strcat(who_am_I, z_yy);
			}
			times = len_file - len_in + 1;
			outok = FALSE;
			for (result = 1; result <= times; result++) {
				substr(x_filename, temp, result, len_in);
				if (strcmp(temp, string_loc) == 0) {
					outok = TRUE;
					break;
				}
			}
		}
		if (!outok)
			goto xend;
		sprintf(work_msg, "%-15s%-7s%-6s%-50s", x_filename, who_am_i, who_am_I, buf128);
		strip(work_msg);
		term_space(work_msg);

		sprintf(buf128, "%s\n\r", work_msg);
		portsout(buf128);
		if (stop_that) {
			fclose(rdstatbuf);
			stop_that = FALSE;
			return;
		}
		if (toggle) {
			lnctx++;
			if (lnctx == 23) {
				portsout(CRLF);
				portsout("*** Depress a key to continue ( control-k to quit ) ........ ");
				jnk[0] = portin();
				if (jnk[0] == CTL_K || stop_that) {
					stop_that = FALSE;
					fclose(rdstatbuf);
					return;
				}
				portsout(CRLF);
				lnctx = 1;
			}
		}
xend:
		;
	}
finisx:
	fclose(rdstatbuf);
	if (toggle && lnctx > xp) {
		portsout(CRLF);
		portsout("*** Depress a key to continue ........ ");
		jnk[0] = portin();
		portsout(CRLF);
	}
	portsout(CRLF);
	portsout(CRLF);
}
file_n()
{
	int             result;
	int             i;
	int             zz;
	int             outok;
	long            foo;
	char            timeptr[30];
	char           *fileptr;
	int             lnctx, xp;
	static char    *dates[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
				 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",};
	substr(z_date, z_mm, 1, 2);
	substr(z_date, z_dd, 4, 2);
	substr(z_date, z_yy, 7, 2);
	lnctx = 1;
	if (xpert)
		xp = 10;
	else
		xp = 5;
	xmm = atol(z_mm);
	xdd = atol(z_dd);
	xyy = atol(z_yy);
	foo = atol(yy);
	outok = FALSE;
	old_long_date = (xyy * 10000L) + (xmm * 100L) + xdd;
	strcpy(buf128, f_pathname);
	strcat(buf128, FILES);
	if ((rdstatbuf = fopen(buf128, "r")) == NULL) {
		portsout("\n\rThe are NO files available!\n\r");
		return;
	}
	strcpy(buf128, TMPFILE);
	strcat(buf128, port_id);
	msgck();
	portsout("\n\rStarting the new file search.\n\r\n\r");
	while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
		zz = 0;
		if (x_filename[0] == '~') {
			goto finisn;	/* Special case so that that
					 * following files are not displayed
					 * - can be used to disallow uploads
					 * from being shown until they are
					 * validated. */
		}
		if (x_filename[0] == '+') {
			fileptr = x_filename + 1;
			strcpy(work_msg, fileptr);
			(void) fgets(buf128, 80, rdstatbuf);
			goto nend;
		}
		if (x_filename[0] == '.') {
			strcpy(x_filename, "   ");
			strcpy(who_am_i, "   ");
			strcpy(who_am_I, "   ");
			zz++;
		}
		if (result = fgets(buf128, 55, rdstatbuf) == NULL) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		strip(buf128);
		if (!zz)
			term_space(buf128);
		result = strlen(buf128);
		if (result == 0) {
			if (!zz)
				strcpy(buf128, " ***** No description on file *****");
		}
		if (!zz) {
			strcpy(x_pathandfile, f_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				strcpy(who_am_i, "OFFLINE");
				strcpy(who_am_I, "    ");
				outok = FALSE;
				goto nend;
			}
			xmm = statbuf.st_size;
			sprintf(who_am_i, "%6ld", xmm);
			xmm = statbuf.st_mtime;
			strcpy(timeptr, ctime(&xmm));
			substr(timeptr, bufx, 5, 6);
			strcpy(who_am_I, bufx);
			substr(timeptr, bufx, 5, 3);
			substr(timeptr, z_dd, 9, 2);
			substr(timeptr, z_yy, 23, 2);
			xdd = atol(z_dd);
			xyy = atol(z_yy);
			if (foo > xyy) {
				strcpy(who_am_I, bufx);
				strcat(who_am_I, "-");
				strcat(who_am_I, z_yy);
			}
			for (result = 0; result < 12; result++) {
				i = strcmp(bufx, dates[result]);
				if (!i) {
					xmm = (long) result + 1;
					new_long_date = (xyy * 10000L) + (xmm * 100L) + xdd;
					if (new_long_date < old_long_date) {
						outok = FALSE;
						goto nend;
					}
					outok = TRUE;
					break;
				}
			}

		}
		if (!outok)
			goto nend;
aroundn:
		sprintf(work_msg, "%-15s%-7s%-6s%-50s", x_filename, who_am_i, who_am_I, buf128);
arondn:
		strip(work_msg);
		term_space(work_msg);

		sprintf(buf128, "%s\n\r", work_msg);
		portsout(buf128);
		if (stop_that) {
			fclose(rdstatbuf);
			stop_that = FALSE;
			return;
		}
		if (toggle) {
			lnctx++;
			if (lnctx == 23) {
				portsout(CRLF);
				portsout("*** Depress a key to continue ( control-k to quit ) ........ ");
				jnk[0] = portin();
				if (jnk[0] == CTL_K || stop_that) {
					stop_that = FALSE;
					fclose(rdstatbuf);
					return;
				}
				portsout(CRLF);
				lnctx = 1;
			}
		}
nend:
		;
	}
finisn:
	fclose(rdstatbuf);
finisln:
	if (toggle && lnctx > xp) {
		portsout(CRLF);
		portsout("*** Depress a key to continue ........ ");
		jnk[0] = portin();
		portsout(CRLF);
	}
	portsout(CRLF);
	portsout(CRLF);
}
file_u()
{
	char            choic1[2], *str_result;
	FILE           *storbuff;
	int             result, tryit, tryit1, code;
fileu:
	tryit = FALSE;
	tryit1 = FALSE;
	if_kermit = 0;
	portsout("\n\rYour usage time will be STOPPED during uploads and \n\r");
	portsout("the size of the file(s) will be added to your limit.\n\r");
	portsout(CRLF);
	portsout("Input filename for upload:  ");
	portsin(x_filename, 15);
	if (strlen(x_filename) < 1)
		return;
	if (x_filename[0] == '.' || x_filename[0] == '/' || x_filename[0] == ' ') {
		portsout("\n\r\n\rIllegal Filename!\n\r");
		return;
	}
	code = strlen(x_filename);
	code--;
	if (x_filename[code] == '.' || x_filename[code] == '/' || x_filename[code] == ' ') {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	code = strcmp(x_filename, "files.bbs");
	if (code == 0) {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	code = legalname("|`><!;:", x_filename);
	if (code == 0) {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	portsout(CRLF);
	str_result = strchr(x_filename, '*');
	if (str_result != NULL)
		tryit = TRUE;
	strcpy(x_pathandfile, u_pathname);
	strcat(x_pathandfile, x_filename);
	if (!tryit) {
		result = stat(x_pathandfile, &statbuf);
		if (result == 0) {
			portsout("That file already exists!\n\r");
			return;
		}
	}
	portsout(CRLF);
	if ( tryit ) {
		portsout("Options: K(ermit),  B(atch ymodem),  Z(modem),\n\r\n\r");
		portsout("Commands: K,B,Z  ===> ");
	}
	else {
		portsout("Options: X(modem), C(rc xmodem), B(atch ymodem), Y(modem), Z(modem),\n\r");
		portsout("         K(ermit), S(EAlink),    A(scii)\n\r\n\r");
		portsout("Commands: X,C,B,Y,Z,K,S,A  ===> ");
	}
	portsin(choic1, 1);
	portsout(CRLF);
	*choic1 = toupper(*choic1);
	if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
	code = fprintf(inbuf, "%s %s  ", "   UPLOAD  ", x_filename);
	if (code < 0) {
		portsout(CRLF);
		portsout("Caller file has problem writing");
		portsout(CRLF);
	} 
	fclose(inbuf);
	if (choic1[0] == 'K' || choic1[0] == 'B' || choic1[0] == 'Z')
		tryit1 = TRUE;
	if (tryit && !tryit1) {
		portsout("\n\rIllegal use of wildcards - Must be KERMIT, YMODEM BATCH, or ZMODEM\n\r");
		typexfr(11);
		return;
	}
	switch (choic1[0]) {
	case ('X'):
		strcpy(x_pathandfile, RB);
		strcat(x_pathandfile, u_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(5);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		updatef();
		enabletime();
		break;
	case ('Y'):
		strcpy(x_pathandfile, YMDR);
		strcat(x_pathandfile, u_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(3);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		updatef();
		enabletime();
		break;
	case ('C'):
		strcpy(x_pathandfile, CRCR);
		strcat(x_pathandfile, u_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(4);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		updatef();
		enabletime();
		break;
	case ('S'):
		strcpy(x_pathandfile, SEAR);
		strcat(x_pathandfile, u_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(7);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		updatef();
		enabletime();
		break;
	case ('A'):
		strcpy(x_pathandfile, u_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(8);
		if ((storbuff = fopen(x_pathandfile, "w")) == NULL) {
			portsout("\n\rError opening upload file!\n\r");
			break;
		}
		fds = fileno(storbuff);
		rewind(storbuff);
		locking(fds, LK_LOCK, 0L);
		portsout("\n\rTerminate the ASCII upload with a control d ( ^d )");
		portsout("\n\rReady to receive ASCII upload....\n\r");
		uploadtime();

		restoremodes();
		portrst();

		while ((fgets(buf128, 132, stdin)) != NULL) {
			result = fputs(buf128, storbuff);
		}
		rewind(storbuff);
		locking(fds, LK_UNLCK, 0L);
		fclose(storbuff);

		portinit();
		setmodes();

		updatef();
		enabletime();
		break;
	case ('B'):
		strcpy(x_pathandfile, YMR);
		portsout("Please start your YMODEM transfer");
		portsout(CRLF);
		if_kermit = 1;
		typexfr(2);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		strcpy(x_pathandfile, KRE);
		result = system(x_pathandfile);
		if ((rdstatbuf = fopen(FLIST, "r")) == NULL) {
			portsout("\n\rERROR: Unable to update!\n\r");
			exit(1);
		}
		while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
			strcpy(x_pathandfile, u_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				updatef();
			} else {
				portsout(CRLF);
				portsout(x_filename);
				portsout(":  Duplicate file deleted!\n\r");
				strcpy(x_pathandfile, USRBBS);
				strcat(x_pathandfile, x_filename);
				result = unlink(x_pathandfile);
			}
		}
		enabletime();
		fclose(rdstatbuf);
		break;
	case ('K'):
		strcpy(x_pathandfile, KRA);
		portsout("Please start your KERMIT transfer");
		portsout(CRLF);
		if_kermit = 1;
		typexfr(6);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		strcpy(x_pathandfile, KRE);
		result = system(x_pathandfile);
		if ((rdstatbuf = fopen(FLIST, "r")) == NULL) {
			portsout("\n\rERROR: Unable to update!\n\r");
			exit(1);
		}
		while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
			strcpy(x_pathandfile, u_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				updatef();
			} else {
				portsout(CRLF);
				portsout(x_filename);
				portsout(":  Duplicate file deleted!\n\r");
				strcpy(x_pathandfile, USRBBS);
				strcat(x_pathandfile, x_filename);
				result = unlink(x_pathandfile);
			}
		}
		enabletime();
		fclose(rdstatbuf);
		break;
	case ('Z'):
		strcpy(x_pathandfile, RZ);
		portsout("Please start your ZMODEM transfer");
		portsout(CRLF);
		if_kermit = 1;
		typexfr(1);
		uploadtime();
		result = system(x_pathandfile);
		restoresig();
		strcpy(x_pathandfile, KRE);
		result = system(x_pathandfile);
		if ((rdstatbuf = fopen(FLIST, "r")) == NULL) {
			portsout("\n\rERROR: Unable to update!\n\r");
			exit(1);
		}
		while (fscanf(rdstatbuf, "%14s", x_filename) != EOF) {
			strcpy(x_pathandfile, u_pathname);
			strcat(x_pathandfile, x_filename);
			result = stat(x_pathandfile, &statbuf);
			if (result != 0) {
				updatef();
			} else {
				portsout(CRLF);
				portsout(x_filename);
				portsout(":  Duplicate file deleted!\n\r");
				strcpy(x_pathandfile, USRBBS);
				strcat(x_pathandfile, x_filename);
				result = unlink(x_pathandfile);
			}
		}
		enabletime();
		fclose(rdstatbuf);
		break;
	default:
		portsout("Illegal option");
		portsout(CRLF);
		typexfr(11);
		break;
	}
	portsout(CRLF);
}
uploadtime()
{
	xsec = alarm(0);
	Ztime = xsec;
	alarm(32767);
}
enabletime()
{
	sec = xsec;
	alarm(sec);
}
digit(datr) char *
	                datr;
{
	int             res;
	char           *datr1;
	datr1 = datr;
	while (*datr1) {
		res = *datr1;
		if (!isdigit(res))
			*datr1 = ' ';
		datr1++;
	}
}


updatef()
{
	/*
	 * The following modifications to "updatef()" allow you to have
	 * MAX_DEC_LINES lines of description for uploaded files instead of
	 * just one. 
	 */
#define MAX_DESC_LINES  5
	int             code;
	int             index, index2;
	char            buf50[MAX_DESC_LINES][51], tmp[51];

	if (if_kermit == 0) {
		strcpy(buf128, u_pathname);
	} else {
		strcpy(buf128, USRBBS);
	}
	strcat(buf128, x_filename);
	(void) stat(buf128, &statbuf);
	if (statbuf.st_size == ((off_t) 0)) {
		unlink(buf128);
		return;
	}
	max_dload += statbuf.st_size;
	set_upd(-statbuf.st_size);
	portsout(CRLF);
	portsout("Please describe ");
	portsout(x_filename);
	sprintf(tmp, "    ( max of 50 characters on %d lines ) ", MAX_DESC_LINES);
	portsout(tmp);
	portsout(CRLF);
	portsout("NOTE: NO WORD WRAP.  Please watch how long your lines are!!");
	portsout(CRLF);
	portsout("Start with a / on line 1 for SYSOP ONLY!");
	portsout(CRLF);
	portsout("  ---------1---------2---------3---------4---------5");
	portsout(CRLF);
	index = 1;
	sprintf(tmp, "%1d:", index);
	portsout(tmp);
	portsin(buf50[0], 50);
	portsout(CRLF);
	while ((buf50[(index - 1)][0] != '\0') && (index < MAX_DESC_LINES)) {
		index++;
		sprintf(tmp, "%1d:", index);
		portsout(tmp);
		portsin(buf50[(index - 1)], 50);
		portsout(CRLF);
	}
	if (buf50[0][0] == '/') {
		portsout(CRLF);
		portsout(x_filename);
		portsout(" will NOT be logged\n\r");
		if ((inbuf = fopen(callers, "a")) == NULL) {
			portsout(CRLF);
			portsout("Can't open/create callers.bbs!");
			portsout(CRLF);
			return;
		}
		code = fprintf(inbuf, "%s %s", x_filename, buf50[0]);
		if (code < 0) {
			portsout(CRLF);
			portsout("Callers file has problem writing");
			portsout(CRLF);
		} else {
			fputs("\n", inbuf);
		}
		index2 = 1;
		while (index2 < index) {
			fprintf(inbuf, ". %s\n", buf50[index2]);
			index2++;
		}
		if( index == MAX_DESC_LINES )
			fprintf(inbuf, ".\n");
		fclose(inbuf);
		if (if_kermit == 0) {
			strcpy(x_pathandfile, u_pathname);
		} else {
			strcpy(x_pathandfile, USRBBS);
		}
		strcat(x_pathandfile, x_filename);
		strcpy(buf128, ORGPATH);
		strcat(buf128, x_filename);
		code = link(x_pathandfile, buf128);
		if( code == -1) {
			strcpy(buf128, "mv ");
			strcat(buf128, x_pathandfile);
			strcat(buf128, " ");
			strcat(buf128, ORGPATH);
			strcat(buf128, x_filename);
			(void)system(buf128);
			portsout("\n\r\n\rPlease leave a message to the sysop advising him that the\n");
			portsout("bbs users' home directory is NOT in the same filesystem as the upload path.\n\r\n\r");
		}
			
		(void)unlink(x_pathandfile);
		return;
	}
	strcpy(who_am_i, u_pathname);
	strcat(who_am_i, FILES);
	if ((inbuf = fopen(who_am_i, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create files.bbs!");
		portsout(CRLF);
		return;
	}
	fds = fileno(inbuf);
	rewind(inbuf);
	locking(fds, LK_LOCK, 0L);
	code = fprintf(inbuf, "%s %s", x_filename, buf50[0]);
	if (code < 0) {
		portsout(CRLF);
		portsout("List file has problem writing");
		portsout(CRLF);
	} else {
		fputs("\n", inbuf);	/* put lf on end of each record */
	}
	index2 = 1;
	while (index2 < index) {
		fprintf(inbuf, ". %s\n", buf50[index2]);
		index2++;
	}
	if( index == MAX_DESC_LINES )
		fprintf(inbuf, ".\n");
	rewind(inbuf);
	locking(fds, LK_UNLCK, 0L);
	fclose(inbuf);
	if (if_kermit != 0) {
		strcpy(x_pathandfile, USRBBS);
		strcat(x_pathandfile, x_filename);
		strcpy(buf128, u_pathname);
		strcat(buf128, x_filename);
		code = link(x_pathandfile, buf128);
		if( code == -1) {
			strcpy(buf128, "mv ");
			strcat(buf128, x_pathandfile);
			strcat(buf128, " ");
			strcat(buf128, u_pathname);
			strcat(buf128, x_filename);
			(void)system(buf128);
			portsout("\n\r\n\rPlease leave a message to the sysop advising him that the\n");
			portsout("bbs users' home directory is NOT in the same filesystem as the upload path.\n\r\n\r");
		}
			
		code = unlink(x_pathandfile);
	}
}
enough_time()
{
	long            lsec, lspeed;
	int             size, speed, code, result, astptr;
	static int      baud[15] = {0, 50, 75, 110, 134, 150, 200, 300, 600, 1200, 1800, 2400, 4800, 9600, 19200};
	char            data_buffer[600];
	char 		*ppr, *locptr;
	locptr = strchr(x_pathandfile, '*');
	if( locptr == NULL )
		astptr = 0;
	else
		astptr = 1;
	strcpy(data_buffer, "ls ");
	strcat(data_buffer, x_pathandfile);
	strcat(data_buffer, " > /tmp/wild");
	strcat(data_buffer, port_id);
	code = system(data_buffer);
	if( !astptr )
		x_pathandfile[0] = '\0';
	code = 0;
	sum_size = 0L;
	sum_lsec = 0L;
	strcpy(data_buffer, "/tmp/wild");
	strcat(data_buffer, port_id);
	portsout("\n\rThe following files will be sent:\n\r");
	if ((inbuf = fopen(data_buffer, "r")) == NULL)
		return (FALSE);
	while (fscanf(inbuf, "%s", data_buffer) != EOF) {
		result = stat(data_buffer, &statbuf);
		if( !astptr ) {
			strcat(x_pathandfile, data_buffer);
			strcat(x_pathandfile, " ");
		}
		ppr = strrchr(data_buffer, '/');
		if (ppr == NULL)
			ppr = data_buffer;
		else
			ppr++;
		if (result != 0) {
			fclose(inbuf);
			strcpy(data_buffer, "/tmp/wild");
			strcat(data_buffer, port_id);
			result = unlink(data_buffer);
			return (FALSE);
		}
		result = strcmp(ppr, "files.bbs");
		if( result == 0 ) {
			portsout("\n\rIllegal file request\n\r");
			return(FALSE);
		}
		portsout(ppr);
		portsout(CRLF);
		size = (statbuf.st_size / 128) + 1;
		ioctl(0, TCGETA, &ttyhold);
		speed = baud[ttyhold.c_cflag & 017];
		lspeed = speed;
		lsec = size;
		sum_lsec = sum_lsec + (lsec * 128L * 11L / lspeed);
		sum_size = sum_size + statbuf.st_size;
		code++;
	}
	if( ! astptr ) {
		ppr = strrchr( x_pathandfile, ' ');
		if( ppr != NULL )
			*ppr = '\0';
	}
	fclose(inbuf);
	strcpy(data_buffer, "/tmp/wild");
	strcat(data_buffer, port_id);
	result = unlink(data_buffer);
	strcpy(buf128, "\n\rTotal number of files = ");
	itoa(data_buffer, code);
	strcat(buf128, data_buffer);
	strcat(buf128, "\n\r");
	portsout(buf128);
	strcpy(buf128, "Total number of bytes = ");
	sprintf(data_buffer, "%ld", sum_size);
	strcat(buf128, data_buffer);
	portsout(buf128);
	strcpy(buf128, "\n\rTotal download time = ");
	sprintf(data_buffer, "%ld", sum_lsec);
	strcat(buf128, data_buffer);
	strcat(buf128, " seconds\n\r");
	portsout(buf128);
	xsec = alarm(0);
	Ztime = xsec;
	sec = xsec;
	alarm(sec);
	if (sum_lsec > xsec)
		return (FALSE);
	if ((sum_size + dload_total) > max_dload)
		return (FALSE);
	if( sum_size == 0L )
		return (FALSE);
	return (TRUE);
}
file_d()
{
	FILE		*zipp;
	char            choic2[2], *str_result, *ptr, *ptr1;
	long            lsec, hold_sec, jsec, ksec;
	unsigned        start_sec, stop_sec;
	long            var_sec;
	int             result, tryit, tryit1, size, speed, default_flag, code;
	int		mult;
	static int      baud[15] = {0, 50, 75, 110, 134, 150, 200, 300, 600, 1200, 1800, 2400, 4800, 9600, 19200};
filed:
	result = stat(DLMSG, &statbuf);
	if (!result) {
		portsout(CRLF);
		no_cntrl_k = TRUE;
		cmd_p(DLMSG);
		no_cntrl_k = FALSE;
		portsout(CRLF);
	}
	tryit = FALSE;
	tryit1 = FALSE;
	mult = FALSE;
	portsout(CRLF);
	portsout("Input file name(s) to download:  ");
	portsin(x_filename, 98);
	if (strlen(x_filename) < 1)
		return;
	if (x_filename[0] == '.' || x_filename[0] == '/' || x_filename[0] == ' ') {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	code = strlen(x_filename);
	code--;
	if (x_filename[code] == '.' || x_filename[code] == '/' || x_filename[code] == ' ') {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	code = strcmp(x_filename, "files.bbs");
	if (code == 0) {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	str_result = strchr(x_filename, '*');
	if (str_result != NULL)
		tryit = TRUE;

	str_result = strchr(x_filename, ' ');
	if (str_result != NULL) {
		tryit = TRUE;
		mult = TRUE;
	}

	portsout(CRLF);
	code = legalname("|`><!;:", x_filename);
	if (code == 0) {
		portsout("\n\r\n\rIllegal Filename! \n\r");
		return;
	}
	if( mult ) {
		ptr = x_filename;
		x_pathandfile[0] = '\0';
		while(1) {
			ptr1 = strchr(ptr, ' ');
			if(ptr1 == NULL)
				break;	
			*ptr1 = '\0';
			strcat(x_pathandfile, f_pathname);
			strcat(x_pathandfile, ptr);
			strcat(x_pathandfile, " ");
			*ptr1 = (char)' ';
			ptr = ptr1 + 1;
		}
		strcat(x_pathandfile, f_pathname);
		strcat(x_pathandfile, ptr);
	} else {
		strcpy(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
	}
	if (!tryit) {
		result = stat(x_pathandfile, &statbuf);
		if (result != 0) {
			portsout("\n\rThat file does not exist!\n\r");
			portsout("Remember that file names are CASE sensitive.\n\r");
			return;
		}
		size = (statbuf.st_size / 128) + 1;
		ioctl(0, TCGETA, &ttyhold);
		speed = baud[ttyhold.c_cflag & 017];
		lsec = size;
		lsec = lsec * 128L * 11L / speed;
		sum_size = statbuf.st_size;
		xsec = alarm(0);
		Ztime = xsec;
		sec = xsec;
		alarm(sec);
		hold_sec = lsec;
		if (lsec > xsec) {
			portsout("\n\rYou don't have enough time left to download that file.\n\r");
			return;
		}
		if ((statbuf.st_size + dload_total) > max_dload) {
			portsout("\n\rThis download will overrun your download limit.");
			portsout("\n\rUploads will increase your limit.\n\r");
			return;
		}
	} else {
		if (!enough_time()) {
			portsout("\n\rYou don't have enough time/bytes or an error was detected.\n\r");
			return;
		}
		hold_sec = sum_lsec;
	}
	hold_sec /= 2L;
	portsout(CRLF);
	if ( tryit ) 
		portsout("Multi-file options: Z(modem),  B(atch ymodem), K(ermit)");
	else {
		portsout("Options: Z(modem),  C(rc xmodem), X(modem), B(atch ymodem), Y(modem),\n\r");
		portsout("         K(ermit),  S(EAlink),    A(scii),  T(ype)");
	}
	portsout(CRLF);
	portsout(CRLF);
	if ( tryit )
		portsout("Commands: Z,B,K  ===> ");
	else
		portsout("Commands: Z,C,X,B,Y,K,S,A,T  ===> ");
	portsin(choic2, 1);
	portsout(CRLF);
	default_flag = 1;
	*choic2 = toupper(*choic2);
	if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
	code = fprintf(inbuf, "%s %s  ", "   DNLOAD  ", x_filename);
	if (code < 0) {
		portsout(CRLF);
		portsout("Caller file has problem writing");
		portsout(CRLF);
	} 
	fclose(inbuf);
	if (choic2[0] == 'K' || choic2[0] == 'B' || choic2[0] == 'Z')
		tryit1 = TRUE;
	if (tryit && !tryit1) {
		portsout("\n\rIllegal use of wildcards - Must be KERMIT, YMODEM BATCH, or ZMODEM\n\r");
		typexfr(11);
		return;
	}
	start_sec = stop_sec = 0;
	xsec = alarm(0);
	alarm(32767);
	switch (choic2[0]) {
	case ('T'):
		portsout("\n\r\n\rOne moment please while an ascii check is done on the file ......  ");
		if(!asciicheck(x_pathandfile)) {
			portsout("Sorry.\n\rEither the file does not exist or it is not printable ascii.\n\r\n\r");
			typexfr(10);
			return;
		}
		portsout("ok.\n\r\n\r");
		cmd_p(x_pathandfile);
		typexfr(9);
		break;
	case ('A'):
		strcpy(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
		portsout("\n\r\n\rOne moment please while an ascii check is done on the file ......  ");
		if(!asciicheck(x_pathandfile)) {
			portsout("Sorry.\n\rEither the file does not exist or it is not printable ascii.\n\r\n\r");
			typexfr(10);
			return;
		}
		portsout("ok.\n\r\n\r");
		typexfr(8);
		portsout("\n\rOnce the transfer starts, you may terminate it by typing a Control-K");
		portsout("\n\rType a character to start the transfer when you are ready ===>  ");
		portsin(choic2, 1);
		portsout(CRLF);
		no_cntrl_k = TRUE;
		if (!toggle) {
			cmd_p(x_pathandfile);
		} else {
			toggle = FALSE;
			cmd_p(x_pathandfile);
			toggle = TRUE;
		}
		no_cntrl_k = FALSE;
		sleep(3);
		break;
	case ('X'):
		strcpy(x_pathandfile, SB);
		strcat(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(5);
		result = system(x_pathandfile);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('Y'):
		strcpy(x_pathandfile, YMDS);
		strcat(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(3);
		result = system(x_pathandfile);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('C'):
		strcpy(x_pathandfile, CRCS);
		strcat(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(4);
		result = system(x_pathandfile);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('S'):
		strcpy(x_pathandfile, SEAS);
		strcat(x_pathandfile, f_pathname);
		strcat(x_pathandfile, x_filename);
		typexfr(7);
		result = system(x_pathandfile);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('Z'):
		strcpy(msg_text, SZ);
		strcat(msg_text, x_pathandfile);
		typexfr(1);
		result = system(msg_text);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('B'):
		strcpy(msg_text, YMS);
		strcat(msg_text, x_pathandfile);
		typexfr(2);
		result = system(msg_text);
		restoresig();
		start_sec = result;
		sleep(1);
		break;
	case ('K'):
		strcpy(msg_text, KS);
		strcat(msg_text, x_pathandfile);
		typexfr(6);
		portsout("Ready to start KERMIT transfer");
		portsout(CRLF);
		result = system(msg_text);
		restoresig();
		start_sec = result;
		break;
	default:
		portsout("Illegal option");
		typexfr(11);
		default_flag = 0;
		portsout(CRLF);
		break;
	}
	sec = alarm(0);
	jsec = 32767L - (long) sec;
	ksec = (long) xsec;
	ksec -= jsec;
	if (ksec <= 2L)
		ksec = 2L;
	xsec = (unsigned int) ksec;
	code = 0;
	if (default_flag) {
		if ((zipp = fopen(callers, "a")) == NULL) {	/* create or open for
								 * append */
			portsout(CRLF);
			portsout("Can't open/create callers file!");
			portsout(CRLF);
			return;
		}
		if (start_sec == 0) {
			dload_total += sum_size;
			set_upd(sum_size);
			code = fprintf(zipp, "      Transfer seems to be OK.\n");
		} else 
			code = fprintf(zipp, "      Transfer seems to have failed.\n");
		if (code < 0) {
			portsout(CRLF);
			portsout("Caller file has problem writing");
			portsout(CRLF);
		} 
		fclose(zipp);

	}
	alarm(xsec);
	portsout(CRLF);
}
typexfr(typex)  int typex;
{
	int code;
	if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
	switch (typex) {
		case (1): code = fprintf(inbuf, " using ZMODEM\n");
			break;
		case (2): code = fprintf(inbuf, " using BATCH YMODEM\n");
			break;
		case (3): code = fprintf(inbuf, " using YMODEM\n");
			break;
		case (4): code = fprintf(inbuf, " using XMODEM-CRC\n");
			break;
		case (5): code = fprintf(inbuf, " using XMODEM-CHECKSUM\n");
			break;
		case (6): code = fprintf(inbuf, " using KERMIT\n");
			break;
		case (7): code = fprintf(inbuf, " using SEALINK\n");
			break;
		case (8): code = fprintf(inbuf, " using ASCII\n");
			break;
		case (9): code = fprintf(inbuf, " using TYPE\n");
			break;
		case (10): code = fprintf(inbuf, " NOT printable ASCII\n");
			break;
		default:  code = fprintf(inbuf, " ......... illegal option!\n");
			break;
	}
	if (code < 0) {
		portsout(CRLF);
		portsout("Caller file has problem writing");
		portsout(CRLF);
	}
	fclose(inbuf);
}

cmd_e()
{				/* enter a message */
	int             entering, editing, char_cnt, temp_int, temp_int1;
	char            l_cnt[3], type[2], ans[2];
	char           *char_ptr;
	char            tmp[80];

	entering = editing = TRUE;
	cnt1 = 0;
	strcpy(l_cnt, "00");
	msg_text[0] = '\0';	/* init message text area */
	portsout(CRLF);
	portsout("This will be message # ");
	portsout(h_act_msg);
	portsout(CRLF);
	if (!reply_sw) {
		entr_name();
		entr_subj();
	}
	if (!end_msg)
		entr_priv();
	if (end_msg)
		strcpy(pubpriv, "5");

	portsout(CRLF);
	sprintf(tmp, "A line can contain 72 characters, up to %d lines.", MAX_MSG_LINES);
	portsout(tmp);
	portsout(CRLF);
	portsout("To end, enter a carriage return on an empty line.");
	portsout(CRLF);
	if(blocked_m)
		portsout("The lines will automatically word wrap and block.");
	else
		portsout("The lines will automatically word wrap.");
	portsout(CRLF);
Enter:
	portsout(CRLF);
	portsout("    .___.____1____.____2____.____3____.____4____.____5____.____6____.____7__");
	portsout(CRLF);

	char_cnt = 72;
	work_msg[0] = '\0';
	while (entering) {	/* get the text of the message */
		linecnt(l_cnt);	/* calc line count */

		portsout(l_cnt);/* show line count */
		portsout("> ");	/* and prompt */
		portsout(work_msg);
		strcpy(buf128, work_msg);
		in_the_buffer = strlen(buf128);
		work_msg[0] = '\0';
		portsinm(x_pathandfile, char_cnt, buf128);
		char_ptr = strrchr(x_pathandfile, ' ');
		temp_int = strlen(x_pathandfile);
		if (temp_int >= char_cnt) {
			if (x_pathandfile[temp_int - 1] == '\n' || x_pathandfile[temp_int - 1] == '\r' || x_pathandfile[temp_int - 1] == ' ') {
				char_cnt = 72;
				goto enter1;
			}
			if (char_ptr != NULL) {
				*char_ptr = '\0';
				char_ptr++;
				strcpy(work_msg, char_ptr);
				temp_int = strlen(work_msg);
				for (temp_int1 = 1; temp_int1 <= temp_int; temp_int1++)
					portsout("\b");
				for (temp_int1 = 1; temp_int1 <= temp_int; temp_int1++)
					portsout(" ");
				char_cnt = 72 - temp_int;

			} else {
				char_cnt = 72;
			}
		} else {
			char_cnt = 72;
			work_msg[0] = '\0';

		}
enter1:
		strcat(buf128, x_pathandfile);
		portsout(CRLF);

		strcat(buf128, "\n");	/* put a <lf> on each line */
		if(blocked_m) {
			strcpy(x_pathandfile, buf128);
			block_text();
		}

		if (strlen(buf128) < 2) {	/* count cr too */
			entering = FALSE;	/* all done */
		} else {
			strcat(msg_text, buf128);	/* append each line to
							 * text */
		}
		if ((++cnt1) > MAX_MSG_LINES) {	/* only allow 20 lines */
			entering = FALSE;	/* all done */
		}
	}

	while (editing) {	/* save it, fix it, list it, or get out */
		portsout(CRLF);
		portsout("(S)ave,    (L)ist,     (C)ontinue, or (Q)uit");
		portsout(CRLF);
		portsout("ce(N)ter,  (B)lock,    (D)elete,      (I)nsert,    (R)eplace,  or (E)dit line");
		portsout(CRLF);
		portsout("Change     sub(J)ect,  recei(V)er, or (P)rivilege ==> ");
		portsin(ans, 1);/* get a byte */
		portsout(CRLF);

		*ans = toupper(*ans);

		switch (ans[0]) {	/* get 1 byte */
		case ('S'):	/* save message */
			new_msg = atoi(h_act_msg);
			savemsg();
			editing = FALSE;	/* get out of while */
			break;
		case ('E'):	/* edit message */
		case ('I'):	/* edit message */
		case ('D'):	/* edit message */
		case ('R'):
		case ('N'):
		case ('B'):
			editmsg(*ans);
			break;
		case ('P'):
			if (end_msg) {
				portsout("\n\rCannot change the privilege on a log off message\n\r");
				break;
			}
			entr_priv();
			portsout(CRLF);
			break;
		case ('J'):
			if (end_msg) {
				portsout("\n\rCannot change the subject on a log off message\n\r");
				break;
			}
			if (reply_sw) {
				portsout("\n\rCannot change the subject on a reply to a message\n\r");
				break;
			}
			portsout(CRLF);
			entr_subj();
			portsout(CRLF);
			break;
		case ('V'):
			if (end_msg) {
				portsout("\n\rCannot change the name of the receiver on a log off message\n\r");
				break;
			}
			if (reply_sw) {
				portsout("\n\rCannot change the receiver's name on a message reply\n\r");
				break;
			}
			entr_name();
			break;
		case ('L'):	/* list message */
			listmsg();
			break;
		case ('Q'):	/* get out w/out saving */
			portsout("\n\r\n\rAre you sure you want to quit? (Y/n): ");
			portsin(ans, 1);
			portsout(CRLF);
			if (ans[0] == 'N' || ans[0] == 'n')
				break;
			editing = FALSE;	/* get out of while */
			break;
		case ('C'):
			if (cnt1 == MAX_MSG_LINES) {
				sprintf(tmp, "\n\rMessage is already %d lines!\n\r", MAX_MSG_LINES);
				portsout(tmp);
				break;
			}
			entering = TRUE;
			cnt1--;
			itoa(l_cnt, cnt1);
			goto Enter;
			break;
		default:
			portsout(CRLF);
			portsout("Shall we try that one again?\r\n");
			break;
		}
	}

}
/* end of function               */
entr_name()
{
	char            z_fname[11], z_lname[16], z_full[22];
	int             length, length1;
	char            firstz[20], lastz[20];
	char            priv[6];
	char            etime[9];
	char            esize[9];
enter_it_again:
	length1 = 0;
	portsout(CRLF);
	portsout("                                           ____.____1\r\n");
	portsout("Enter the FIRST NAME of the receiver ===>  ");
	portsin(z_fname, 10);
	length = strlen(z_fname);
	if (!length) {
		strcpy(z_fname, "All");
		z_lname[0] = '\0';
		goto bobble;
	}
	portsout(CRLF);
	portsout("                                           ____.____1____.\r\n");
	portsout("Enter the LAST NAME of the receiver ====>  ");
	portsin(z_lname, 15);
	length1 = strlen(z_lname);
bobble:
	portsout(CRLF);
	fix_name(z_fname);
	fix_name(z_lname);
	length += length1;
	if (length > 20) {
		portsout("\n\rI'm sorry; however, the name is TOO long to be posted!\n\r");
		goto enter_it_again;
	}
	strcpy(z_full, z_fname);
	strcat(z_full, " ");
	strcat(z_full, z_lname);
	strcpy(msg_to, z_full);
	portsout(CRLF);
	if ((inbuf = fopen(USERPRIV, "r")) == NULL) {
		portsout(CRLF);
		portsout("Can't open user priv file!");
		portsout(CRLF);
		exit(1);
	}
	while (fscanf(inbuf, "%s%s%s%s%s", firstz, lastz, priv, etime, esize) != EOF) {
		if ((strcmp(firstz, z_fname) == 0) &&
		    (strcmp(lastz, z_lname) == 0)) {
			return;
		}
	}
	fclose(inbuf);
	if( strcmp(z_fname, "Sysop") == 0 ) {
		strcpy(msg_to, SYSOP);
		return;
	}
	if( strcmp(z_fname, "All") == 0 ) {
		strcpy(msg_to, "All Users");
		return;
	}
	portsout("\n\rWarning: there is no user on this system by that name.\n\r");
	portsout("Do you still wish to use it? (Y/n): ");
	portsin(etime, 1);
	portsout(CRLF);
	if( etime[0] == 'N' || etime[0] == 'n' )
		goto enter_it_again;
}

entr_subj()
{
	int             length;
	portsout("                             ____.____1____.____2\n\r");
	portsout("What is the subject     ===> ");
	portsin(msg_subject, 20);
	length = strlen(msg_subject);
	if (!length) {
		strcpy(msg_subject, "*** NO SUBJECT ***");
	}
}
entr_priv()
{
	char            type[2];
	portsout(CRLF);
	portsout("Do you wish the message to be P(ublic) or pri(V)ate) (P/V) ?  ");
	portsin(type, 1);
	*type = toupper(*type);
	switch (type[0]) {
	case ('P'):
		strcpy(pubpriv, "0");
		break;
	case ('V'):
		strcpy(pubpriv, "5");
		break;
	default:
		portsout("\n\rDefaulting to public!\n\r");
		strcpy(pubpriv, "0");
		break;
	}
}
linecnt(lcnt)			/* 2 byte string of line numbers */
	char           *lcnt;
{
	int             icnt;
	char            xcnt[4];

	icnt = atoi(lcnt);
	if (++icnt < 10) {
		strcpy(lcnt, "0");
		itoa(xcnt, icnt);
		strcat(lcnt, xcnt);
	} else {
		itoa(xcnt, icnt);
		strcpy(lcnt, xcnt);
	}
	return;
}
/* end of function               */

savemsg()
{				/* save a message */
	int             fd;

	portsout("Saving...\r\n");

	strcpy(msg_delete, pubpriv);	/* delete byte */
	strcpy(msg_date, mm);
	strcat(msg_date, "/");
	strcat(msg_date, dd);
	strcat(msg_date, "/");
	strcat(msg_date, yy);

	strcpy(msg_time, ttime);/* and the time */

	strcpy(msg_from, w_fname);	/* and the from name */
	strcat(msg_from, " ");
	strcat(msg_from, w_lname);
	if ((inbuf = fopen(callers, "a")) == NULL) {	/* create or open for
							 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
	fd = fprintf(inbuf, "%s%s", "   Message being sent to ", msg_to);
	if (fd < 0) {
		portsout(CRLF);
		portsout("Caller file has problem writing");
		portsout(CRLF);
	} else {
		fputs("\n", inbuf);	/* put lf on end of each record */
	}
	fclose(inbuf);
	hdrread();		/* Guarantee proper header and table */
	if ((fd = msgopen(2)) == ERROR) {	/* open i/o */
		return (ERROR);
	}
	msgwrt(fd);		/* write the message */
	msgclose(fd);

	strcpy(h_date, msg_date);
	hdrwrt();		/* update the header file */
}
/* end of function               */


listmsg()
{
	char           *ptr, byte, lcnt[3];
	int             i;

	ptr = msg_text;		/* ptr points to start of text */
	strcpy(lcnt, "00");

	portsout(CRLF);
	while (*ptr != 0) {
		linecnt(lcnt);
		portsout(lcnt);	/* put out line number */
		portsout(">");
		while (byte = *ptr++) {
			if (byte == '\n') {	/* we dont save <cr>, so add *//* i
						 * t here when find a <cr> */
				portsout(CRLF);
				break;
			} else
				portout(byte);
		}
	}
}
/* end of function               */

editmsg(tflag) char
	tflag;
{
	char            ans[3];
	int             lnum;	/* line number to edit */
	char            tmp[80];

	while (1) {
		portsout(CRLF);
		portsout("Enter line number to ");
		if (tflag == 'E')
			portsout("edit,");
		else if (tflag == 'D')
			portsout("delete,");
		else if (tflag == 'I')
			portsout("insert after,");
		else if (tflag == 'R')
			portsout("replace,");
		else if (tflag == 'N')
			portsout("center,");
		else if (tflag == 'B')
			portsout("block,");
		else
			return;
		portsout(CRLF);
		portsout("   or RETURN to exit ==> ");
		portsin(ans, 2);/* only MAX_MSG_LINES lines possible */
		portsout(CRLF);
		if (tflag == 'I' && cnt1 == MAX_MSG_LINES) {
			sprintf(tmp, "\n\rMessage is already %d lines!\n\r", MAX_MSG_LINES);
			portsout(tmp);
			return;
		}
		lnum = atoi(ans);
		if (lnum <= 0) {
			break;	/* out of while and return */
		}
		if ((lnum < MAX_MSG_LINES) || ((lnum == MAX_MSG_LINES) && (tflag != 'I'))) {
			editline(lnum, tflag);
			break;
		} else {	/* else slap on hand and loop around */
			sprintf(tmp, "Aw come on, there can only be %d lines!", MAX_MSG_LINES);
			portsout(tmp);
			portsout(CRLF);
			portsout("Shall we try that again?");
			portsout(CRLF);
		}
	}
}
/* end of function               */

usenet()
{				/* added for 7.2.1 USENET access */


#ifdef  SYSV
#define logname getlogin
#endif

	char           *logname();

	static char     shell[] = "SHELL=/bin/sh";
	static char     home[150];
	static char     logn[50];
	char            cmd[512];
	char            news[520];
	char            tmp[512];
	FILE           *newsf;
	int             mask;
	char            term;

	strcpy(home, "HOME=");
	strcpy(logn,"LOGNAME=");
	strcat(home, ORGPATH);
	strcat(home, "usenet/");
	strcat(home, u_fname);
	strcat(home, "/");
	strcat(home, u_lname);
	strcat(logn, logname());

	sprintf(news, "%susenet/%s/%s/.newsrc", ORGPATH, u_fname, u_lname);
	if (access(news, 00) == -1) {
		mask = umask(0000);
		portsout("creating necessary news files\n\r");
		portsout("\n\r");
		sprintf(tmp, "/bin/mkdir %susenet/%s", ORGPATH, u_fname);
		system(tmp);
		strcat(tmp, "/");
		strcat(tmp, u_lname);
		system(tmp);
		if ((newsf = fopen(news, "w")) == NULL) {
			portsout("open of .newsrc failed\n\r");
			exit(-1);
		}
		fprintf(newsf, "");
		fclose(newsf);
		umask(mask);
	}
menu:
	portsout("\n\rWhich type of terminal do you have:\n\r");
	portsout("1) Ansi Standard Monitor\n\r");
	portsout("2) ANSI.SYS for MS-DOS\n\r");
	portsout("3) VT100\n\r");
	portsout("4) Macintosh MacTerm in VT-100 mode\n\r");
	portsout("5) VT52 Terminal\n\r");
	portsout("6) Televideo 925\n\r");
	portsout("7) Televideo 910\n\r");
	portsout("8) Tandy DT-100\n\r");
	portsout("9) Dumb  - Use this when nothing else works correctly.\n\r");
	portsout("           Instead of the normal \"- MORE -\" inbetween pages\n\r");
	portsout("           You will see nothing, BUT you will hear a beep.\n\r");
	portsout("           This is the same thing. \"?\" is for help\n\r");
	portsout("\n\rQ) Return to main menu\n\r");
	portsout("===> ");
	term = portin();
	portsout("\n\r");
	switch (term) {
	case ('1'):
		putenv("TERM=ansi");
		break;
	case ('2'):
		putenv("TERM=dosansi");
		break;
	case ('3'):
		putenv("TERM=vt100");
		break;
	case ('4'):
		putenv("TERM=macterm");
		break;
	case ('5'):
		putenv("TERM=vt52so");
		break;
	case ('6'):
		putenv("TERM=tvi925co");
		break;
	case ('7'):
		putenv("TERM=tvi910");
		break;
	case ('8'):
		putenv("TERM=dt100");
		break;
	case ('9'):
		putenv("TERM=dumb");
		break;
	case ('Q'):
	case ('q'):
		portsout("\n\r");
		return (0);
		break;
	default:
		portsout("\n\rYou have selected an unsupported type. Please try again\n\r");
		goto menu;
		break;
	}

	putenv(shell);
	putenv(home);
	putenv(logn);
choose:
	portsout("\n\rDo you wish to:\n\r");
	portsout("1) Readnews\n\r");
	portsout("2) Postnews\n\r");
	portsout("\n\rQ) Return to main menu\n\r");
	portsout("===>");
	term = portin();
	portsout("\n\r");
	switch (term) {
	case ('1'):
		restoremodes();
		portrst();
		STDerr = freopen("/dev/tty", "w+", stderr);
		sprintf(cmd, "%s -n all",READN);
		system(cmd);
		break;
	case ('2'):
		restoremodes();
		portrst();
		STDerr = freopen("/dev/tty", "w+", stderr);
		sprintf(cmd, "%s",POSTN);
		system(cmd);
		break;
	case ('Q'):
	case ('q'):
		portsout("\n\r");
		strcpy(home, "HOME=");
		strcpy(logn, "LOGNAME=");
		cmd[0] = '\0';
		news[0] = '\0';
		tmp[0] = '\0';
		return (0);
		break;
	default:
		portsout("Please try again\n\r");
		goto choose;
		break;
	}

	strcpy(home, "HOME=");
	strcpy(logn, "LOGNAME=");
	cmd[0] = '\0';
	news[0] = '\0';
	tmp[0] = '\0';

	strcpy(buf128, STDERR);
	strcat(buf128, port_id);
	STDerr = freopen(buf128, "w+", stderr);
	portinit();
	setmodes();
	restoresig();

}
restoresig()
{
	signal(SIGALRM, timer);
	signal(SIGHUP, hanged);
	signal(SIGUSR1, mon_toggle);
	signal(SIGUSR2, sys_toggle);
	signal(SIGPIPE, chat);

}
