/*------------------------------------------------------------------------
       Name: bbscarea.c
   Comments: Display file areas and select one
  ------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "bbscdef.h"

int             set_yet = FALSE;
extern int      user_priv;


change_area(type) int 
	type;
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char           *buf_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int		allx;

	if(type == -1)
		return;

	if(type > 1000) {
		type -=1000;
		allx = 1;
	}
	else
		allx = 0;

do_again:
	strcpy(buf128, AREAS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\rError Opening File Area List: Notify Sysop!\n\r");
		return (-1);
	}
	if(!type) {
		portsout("\n\r    Directory     Description                                      Upload Path\n\r");
		portsout("    ============= ==========================================       ============\n\r");
	}
	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 81);
		if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in File Area List: Notify Sysop!\n\r");
				return (-1);
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			substr(f_lines[line_cnt], dir_priv_ascii, 57, 5);
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 56;
			for (ptr = 0; ptr < 5; ptr++)
				*buf_ptr++ = ' ';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
			if (!type) {
				strip(buf128);
				term_space(buf128);
				portsout(buf128);
				portsout("\n\r");
			}
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	if (set_yet && !type) {
		portsout(CRLF);
		portsout(" Q) Quit to Previous Menu");
	}
	if(!type)portsout(CRLF);
	fclose(fpt);
	if(!type)portsout(CRLF);
	if (line_cnt <= 1)
		return;

	while (1) {
		if (!type) {
			portsout("Enter Selection ===> ");
			portsin_cmp(choice, 2, "Qq");
			portsout(CRLF);
			*choice = toupper(*choice);

			if (*choice == 'Q' && set_yet)
				return (-1);


			index_value = atoi(choice);
		} else
			index_value = type;
		if(allx && index_value >= line_cnt)
			return(999);
		if (index_value > 0 && index_value < line_cnt) {
			if (dir_priv[index_value] <= user_priv) {
				parse_args(f_lines[index_value]);
				set_yet = TRUE;
				itoa(buf128, index_value);
				if( !allx) {
					if(index_value > 9)
						strcpy(l_f_base, buf128);
					else {
						strcpy(l_f_base, "0");
						strcat(l_f_base, buf128);
					}
					rewritx();
				}
				return (0);
			}
		}
		if( type != 0 ) {
			type = 0;
			if(allx)
				return(99);
			portsout("\n\rInvalid directory request!\n\r");
			goto do_again;
		}
	}
}

allnew()
{
	char savef[99], saveu[99];
	char savea[99], savep[99];
	char strg[15], choice[5];
	int i, ret, choi;
	char *fileptr;
	strcpy(savef, f_pathname);
	strcpy(saveu, u_pathname);
	strcpy(savea, area_name);
	strcpy(savep, f_pathtext);
	bbsmenu(5,0);
	portsin(choice, 1);
	portsout(CRLF);
	switch(choice[0]) {
	case ('L'):
	case ('l'):
		choi = 1;
		portsout("\n\r\n\rInput file name substring (max 14 characters): ");
		portsin(strg, 14);
		ret = strlen(strg);
		portsout(CRLF);
		if (!ret)
			return;
		fileptr = strchr(strg, '*');
		if( fileptr != NULL ) {
			portsout("\n\rDo not use an asterisk as part of the string.\n\r\n\r");
			return;
		}
		break;
	case ('F'):
	case ('f'):
		choi = 2;
		break;
	case ('N'):
	case ('n'):
		choi = 3;
		break;
	case ('R'):
	case ('r'):
		choi = 4;
		break;
	default:
		return;
	}
	for( i=1001; i<1100; i++) {
		if (stop_that) {
			stop_that = FALSE;
			strcpy(f_pathname, savef);
			strcpy(u_pathname, saveu);
			strcpy(area_name, savea);
			strcpy(f_pathtext, savep);
			return;
		}
		ret = change_area(i);
		if (stop_that) {
			stop_that = FALSE;
			strcpy(f_pathname, savef);
			strcpy(u_pathname, saveu);
			strcpy(area_name, savea);
			strcpy(f_pathtext, savep);
			return;
		}
		if( ret == 999) {
			strcpy(f_pathname, savef);
			strcpy(u_pathname, saveu);
			strcpy(area_name, savea);
			strcpy(f_pathtext, savep);
			return;
		}
		if( ret == 99)
			continue;
		portsout("\n\r-------------------------------------------------------------------\n\r");
		portsout("\n\r\n\rFile listing for area '");
		portsout(area_name);
		portsout("'\n\r");
		switch(choi){
		case (1):
			file_loc(strg);
			break;
		case (2):
			file_l();
			break;
		case (3):
			file_n();
			break;
		case (4):
			file_r();
			break;
		}
	}
	strcpy(f_pathname, savef);
	strcpy(u_pathname, saveu);
	strcpy(area_name, savea);
	strcpy(f_pathtext, savep);
	return;
}
		
		




parse_args(string)
	char           *string;
{

	register char  *file_ptr, *name_ptr, *up_ptr, *desc_ptr;
	register int    i;

	strcpy(f_pathname, ORGPATH);
	strcpy(u_pathname, ORGPATH);
	file_ptr = (f_pathname + strlen(f_pathname));
	up_ptr = (u_pathname + strlen(u_pathname));

	name_ptr = area_name;
	desc_ptr = f_pathtext;

	i = 0;
	while (string[i] != ' ') {
		*file_ptr = string[i];
		*name_ptr = string[i];
		++file_ptr;
		++name_ptr;
		++i;
	}
	*file_ptr = '/';
	++file_ptr;
	*file_ptr = '\0';
	*name_ptr = '\0';

	for (i = 14; i < 61; ++i) {
		*desc_ptr = string[i];
		++desc_ptr;
	}
	*desc_ptr = '\0';

	i = 63;
	while ((string[i] != ' ') && (string[i] != '\n')) {
		*up_ptr = string[i];
		++up_ptr;
		++i;
	}
	*up_ptr = '/';
	++up_ptr;
	*up_ptr = '\0';
}
