/* Conference Section     05/01/90      */
#include <sys/types.h>
#include <sys/stat.h>
#include <utmp.h>
#include <string.h>
#include <fcntl.h>
#include <pwd.h>
#include <signal.h>
#include "bbscdef.h"

#ifdef SYSV
#include <dirent.h>
#include <sys/dir.h>
#else
#include <sys/ndir.h>
#endif

extern int      no_cntrl_k;
struct stat     thisstat;
char           *getlogin();

#ifdef SYSV
#ifndef ESIX54
#define	opendir(path) fopen (path, "r")
#define closedir(dirp) fclose (dirp)
struct dirent  *
readdir(dirp)
    DIR            *dirp;
{
    static struct dirent entry;
    if (dirp == NULL)
	return (NULL);
    for (;;) {
	if (fread(&entry, sizeof(struct dirent), 1, dirp) == 0)
	    return (NULL);
	if (entry.d_ino)
	    return (&entry);
    }
}
#endif
#endif

conf()
{
    int             mypid, loginpid, uid;
    register struct utmp *u;
    extern struct utmp *getutent();
    struct passwd  *getpwuid();
    struct passwd  *pwd;
    char            mybyte;
    char            byten, byter, bytes, bytet;
    char           *bufptr, *myname, *cmf;
    char            buffer[20], my_ext[10];
    char            buffs[99];
    int             length, handle, handlex;
    int             match, sigrets, pidrets, cmpflag;
    FILE           *infile;
    match = 1;
    byten = (char) '\n';
    byter = (char) '\r';
    bytes = (char) ' ';
    mypid = getpid();
    myname = getlogin();
    uid = getuid();
    loginpid = getppid();
    pwd = getpwuid(uid);
/*
     *Check to see if the login name is the same as the present users pw
     * name. If it isn't, let's play around a little and make it work for us!
*/
    strcpy(who_am_i, myname);
    strcpy(who_am_I, pwd->pw_name);
    handle = strcmp(who_am_i, who_am_I);
    if (handle != 0)
	match = 0;
/*
     *Flag that we are in conference!
*/
    while ((u = getutent()) != NULL) {
	handle = strcmp(u->ut_user, myname);
	if (match) {
	    if (handle == 0 && u->ut_pid == mypid) {
		strcpy(my_ext, u->ut_id);
		strcpy(who_am_I, u->ut_line);
	    }
	} else {
	    if (handle == 0 && u->ut_pid == loginpid) {
		strcpy(my_ext, u->ut_id);
		strcpy(who_am_I, u->ut_line);
	    }
	}
    }
    endutent();
    strcpy(who_am_i, "/tmp/conf");
    strcat(who_am_i, my_ext);
    if ((inbuf = fopen(who_am_i, "w")) == NULL) {
	portsout("\n\rError opening flag file!\n\r");
	exit(1);
    }
    fprintf(inbuf, "%s %s %s\n", w_fname, w_lname, who_am_I);
    fclose(inbuf);
/*
     *Flag all users that I just went into conference
*/
    strcpy(buf128, "ls /tmp/pid* > /tmp/on.sys.");
    strcat(buf128, my_ext);
    (void) system(buf128);
    strcpy(buf128, "/tmp/on.sys.");
    strcat(buf128, my_ext);
    if ((otbuf = fopen(buf128, "r")) == NULL) {
	portsout("\n\rError opening list file!\n\r");
	exit(1);
    }
    while (fscanf(otbuf, "%s", buffs) != EOF) {
	infile = fopen(buffs, "r");
	cmpflag = strlen(buffs);
	cmf = buffs + cmpflag - 2;
	strcpy(buffer, cmf);
	fgets(buffs, 6, infile);
	fclose(infile);
	pidrets = atoi(buffs);
	if ((sigrets = kill(pidrets, 0)) != 0)
	    continue;		/* not valid  */
	setutent();
	cmpflag = 0;
	while ((u = getutent()) != NULL) {
	    if (u->ut_pid == pidrets) {
		cmpflag = 1;
		strcpy(buf128, "/dev/");
		strcat(buf128, u->ut_line);
		handle = open(buf128, O_WRONLY);
		sprintf(buf128, "\n\r**** %s %s went into conference ****\n\r", w_fname, w_lname);
		write(handle, buf128, strlen(buf128));
		close(handle);
	    }
	}
	endutent();
	if (!cmpflag) {
	    setutent();
	    while ((u = getutent()) != NULL) {
		cmpflag = strlen(u->ut_line);
		cmf = u->ut_line + cmpflag - 2;
		if ((strcmp(cmf, buffer)) == 0) {
		    strcpy(buf128, "/dev/");
		    strcat(buf128, u->ut_line);
		    handle = open(buf128, O_WRONLY);
		    sprintf(buf128, "\n\r**** %s %s went into conference ****\n\r", w_fname, w_lname);
		    write(handle, buf128, strlen(buf128));
		    close(handle);
		}
	    }
	    endutent();
	}
	cmpflag = 0;
    }
    fclose(otbuf);


/*   
     *List the users that are presently in conference
*/
    portsout("\n\r\n\rThe following users are presently in conference\n\r");
    no_cntrl_k = 1;
    strcpy(buf128, "ls /tmp/conf* > /tmp/inconf.");
    strcat(buf128, my_ext);
    (void) system(buf128);
    strcpy(buf128, "/tmp/inconf.");
    strcat(buf128, my_ext);
    if ((otbuf = fopen(buf128, "r")) == NULL) {
	portsout("\n\rError opening list file!\n\r");
	exit(1);
    }
    while (fscanf(otbuf, "%s", who_am_i) != EOF) {
	cmd_p(who_am_i);
    }
    fclose(otbuf);
    no_cntrl_k = 0;
/*
     *Start the loop for input
*/

    portsout("\n\rDepressing the escape key will exit the conference!\n\r");
    strcpy(who_am_I, "<");
    strcat(who_am_I, w_fname);
    strcat(who_am_I, " ");
    strcat(who_am_I, w_lname);
    strcat(who_am_I, "> ");
    buf128[0] = '\0';
    while (1) {
	bufptr = buf128;
	*bufptr = '\0';
      conf_loop:
	mybyte = portin_chat();
	if (mybyte == '\033')
	    break;
	if (mybyte == 127)
	    mybyte = '\b';
	if (mybyte == '\b') {
	    length = strlen(buf128);
	    if (!length)
		goto conf_loop;
	    length--;
	    portout_chat(mybyte);
	    portout_chat(bytes);
	    portout_chat(mybyte);
	    bufptr = length + buf128;
	    *bufptr = '\0';
	    goto conf_loop;
	}
	portout_chat(mybyte);
	length = strlen(buf128);
	bufptr = length + buf128;
	*bufptr++ = mybyte;
	*bufptr = '\0';
	if (mybyte == '\n' || mybyte == '\r')
	    goto saver;
	goto conf_loop;
      saver:
	if (mybyte == '\n')
	    bytet = byter;
	else
	    bytet = byten;
	portout_chat(bytet);
	length = strlen(buf128);
	bufptr = length + buf128;
	*bufptr++ = bytet;
	*bufptr = '\0';
	strcpy(who_am_i, "ls /tmp/conf* > /tmp/inconf.");
	strcat(who_am_i, my_ext);
	(void) system(who_am_i);
	strcpy(who_am_i, "/tmp/inconf.");
	strcat(who_am_i, my_ext);
	if ((inbuf = fopen(who_am_i, "r")) == NULL) {
	    portsout("\n\rError opening list file!\n\r");
	    exit(1);
	}
	while (fscanf(inbuf, "%s", who_am_i) != EOF) {
	    handle = strlen(who_am_i);
	    handlex = strlen(my_ext);
	    length = handle - handlex + 1;
	    substr(who_am_i, x_pathandfile, length, handlex);
	    length = strcmp(x_pathandfile, my_ext);
	    if (length != 0) {
		otbuf = fopen(who_am_i, "r");
		fscanf(otbuf, "%s%s%s", who_am_i, x_filename, x_pathandfile);
		fclose(otbuf);
		strcpy(who_am_i, "/dev/");
		strcat(who_am_i, x_pathandfile);
		handle = open(who_am_i, O_WRONLY);
		length = strlen(who_am_I);
		write(handle, who_am_I, length);
		length = strlen(buf128);
		write(handle, buf128, length);
		close(handle);
	    }
	}
	fclose(inbuf);
    }
    strcpy(who_am_i, "/tmp/conf");
    strcat(who_am_i, my_ext);
    unlink(who_am_i);
}
who_is_there()
{
    DIR            *dirp;
    FILE           *infile;

#ifdef SYSV
    struct dirent  *readdir();
    struct dirent  *dp;
#else
    struct direct  *readdir();
    struct direct  *dp;
#endif

    char           *ptr1, *ptr2;
    int             i, j;
    portsout("\n\r\n\r");
    dirp = opendir("/tmp");
    while ((dp = readdir(dirp)) != NULL) {
	strcpy(who_am_i, dp->d_name);
	ptr1 = who_am_i;
	ptr2 = who_am_I;
	for (i = 0; i < 3; i++)
	    *ptr2++ = *ptr1++;
	*ptr2 = '\0';
	j = strcmp(who_am_I, "pid");
	if (!j) {
	    strcpy(who_am_I, "/tmp/");
	    strcat(who_am_I, dp->d_name);
	    infile = fopen(who_am_I, "r");
	    fgets(who_am_I, 6, infile);
	    i = atoi(who_am_I);
	    fclose(infile);
	    j = kill(i, 0);	/* see if it is a good pid */
	    if (!j) {
		strcpy(buf128, ORGPATH);
		strcat(buf128, "lastcall.bbs");
		ptr1 = who_am_i + 3;
		ptr2 = who_am_I;
		for (i = 3; i < 5; i++)
		    *ptr2++ = *ptr1++;
		*ptr2 = '\0';
		strcat(buf128, who_am_I);
		infile = fopen(buf128, "r");
		fgets(buf128, 99, infile);
		strip(buf128);
		portsout("On port ");
		portsout(who_am_I);
		portsout(" -- ");
		portsout(buf128);
		portsout(CRLF);
		fclose(infile);
	    }
	}
    }
    closedir(dirp);
    portsout("\n\r\n\r");
}
