/*
        bbscdef.h

        Global defines and storage definitions for use by
        BBSc system.
        Last modification date: Mar  21, 1990
                  Version 7.91 and above!

*/



/* --------------------------------------------------------------------- */
#include <stdio.h>
#define MAXLINE 82
#define CPMEOF 0x1a
#define TRUE      1
#define FALSE     0
#define ERROR    -1
#define OK        1
#define READ      0
#define WRITE     1
#define UPDATE    2
#define STDIN     0
#define STDOUT    1
/* --------------------------------------------------------------------- */

#define ESC       0x1b
#define CR        0x0d
#define LF        0x0a
#define BELL      0x07                  /* Avon calling */
#define CRLF      "\r\n"                /* <cr><lf> */
#define CTL_D     0x04                  /* <ctl-d> */
#define CTL_K     0x0b                  /* <ctl-k> */
#define CTL_X     0x18                  /* <ctl-x> */


#define IF_MONITOR TRUE                 /* Set True if you want to monitor
                                           the input/output on another
                                           device                     */
/*      defines used by the bbscfile.c routine     */

#define MSG1MAX 102             /* max. piece of message to put in 128 */
                                /*  byte chunk of msg file */
#define MSGSECT 128             /* size of message sector */

/*                      end of defines used by the bbscfile.c routine */
#define MESSAGES  "messages.bbs"        /* file name */
#define HEADER    "header.bbs"
#define MSGLOG    "messages.log"
#define BBSMAIL   "/usr/spool/mail/bbsuser"             /* group mail */
#define CROSSREF  "crossref.bbs"
#define FILES     "files.bbs"
#define TMPFILE   "/tmp/files"
#define FLIST     "/tmp/flist"
#define STDERR    "/tmp/error_out"
#define SYSTTY    "/tmp/ttydev"
char FOO[10];
char TAR[50];
char ZCAT[50];
char ARC[50];
char ZIP[50];
char MONITOR[30];               /* Monitor device */
char CONSOLE[30];               /* The main console */
char WELCOME[50];       /* file name */
char BULLETINS[50];     /* file name */
char NEWUSER[50];       /* file name */
char SYSTEM[50];        /* file name */
char CALLERS[50];       /* file name */
char LASTCALL[50];      /* file name */
char USERS[50];         /* file name */
char QUESTION[50];
char LISTFILES[50];
char ANSWER[50];
char UNIXMSG[50];
char DLMSG[50];         /* Download message */
char HUMOR[50];         /* file name */
char HELP[50];          /* file name */
char HELPFILE[50];
char HELPMSG[50];
char USERPRIV[50];
char MAINPRIV[50];
char FILEPRIV[50];
char ADDITN[50];
char TODAY[99];
char ORGPATH[50];
char AREAS[50];
char SIGS[50];
char MSGS[50];
char USRBBS[50];
char RB[50];
char SB[50];
char RZ[50];
char SZ[50];
char CRCR[50];
char CRCS[50];
char YMDR[50];
char YMDS[50];
char YMS[50];
char YMR[50];
char KS[50];
char KRA[50];
char KRE[50];
char SEAR[50];
char SEAS[50];
char SYSOP[30]; 
char SHELL[30];
int LOGTIME;    /* Login Time    */
int RUNTIME;    /* Usage Time    */
int WAITTIME;   /* Response Time */
int NEWPRIV;
int MAXPRIV;
int MAXSEC;
int MAXKBYTE;


                                /* global variables */
char    portin();               /* in routine returns a character */
char    *gb4sin();              /* returns pointer to character */

FILE    *inbuf ;                /* handy input buffer pointer */
FILE    *otbuf ;                /* another handy buffer pointer */
FILE    *itbuf ;                /* pointer used to read/write user file */
FILE    *rdstatbuf;
FILE    *wtstatbuf;
FILE    *STDerr;

char    w_fname[25];            /* first name on signon */
char    w_lname[25];            /* last  name on signon */
char    w_password[13];         /* password   on signon */
char    *passptr;               /* ptr to password */

                                /* define user file fields */
char    u_fname[25];
char    u_lname[25];
char    u_password[13];
char    u_time1[12];            /* first time on system */
char    u_date1[9];             /* first date on system */
char    u_time2[12];            /* last  time on system */
char    u_date2[9];             /* last  date on system */
char    u_city[31];             /* city, state */

char    z_date[9];
char	z_time[9];
                                /* define message file fields   */
char    msg_no[12];             /* message number */
char    msg_date[10];           /* date of message */
char    msg_time[16];           /* time of message */
char    msg_to[22];             /* who message is to */
char    msg_from[22];           /* who message is from */
char    msg_pass[12];           /* password */
char    msg_subject[22];        /* what it's all about */
#define MAX_MSG_LINES   99
char    msg_text[(MAX_MSG_LINES * 74)+74];         /* text of message MAX_MSG_LINES lines */
                                /*  by 72 wide */
char    msg_delete[3];          /* indicates msg status */
                                /*  0 = active */
                                /*  9 = deleted */
                                /*  5 = active private */
char    pubpriv[2];             /* temporary message type */

char    z_mm[3];
char    z_dd[3];
char    z_yy[3];
char    buf128[384];

char    l_m_base[3];
char    l_f_base[3];
char    xprt_a[2];
char    tggl_a[2];

int     maxkbyte,
        logtime,
        runtime,
        waittime,
        newpriv;
int     mon_handle;             /* Monitor Handle */
int     debug;                  /* switch for debug mode */
int     offline;                /* switch for offline mode */
int     xpert;                  /* switch */
int     toggle;                 /* switch for list mode */
int     which_timer;
int     char_in_passwd;         /* Number of characters in the password */
int     if_monitor;
int     in_the_buffer;
int     active;                 /* indicates if logged on */
int     statcnt;                /* count used for status routines */
int     stop_that;              /* switch - true indicates ctl-K */
                                /*  or K received in portout routine */
                                /* date/time fields - used by bbsclock.c */
/*
 ****************** Start of Priv Table *********************
*/
int     mpB,
        mpK,
        mpE,
        mpG,
        mpN,
        mpQ,
        mpR,
        mpS,
        mpW,
        mpM,
        mpX,
        mpF,
        mpC,
        mpH,
        mpT,
        mpD,
        mpY,
        mpP,
        mpA,
        mpU,
        mpCHAT,
        mpQUEST,
        mpMS,
        mpRF,
        mpCONF,
	mpUSENET,
        mpL,
        mpZ;
int     fpL,
        fpU,
        fpD,
        fpM,
        fpG,
        fpR;
/*
 **************** End of Priv Table *******************
*/
char    mm[3];
char    dd[3];
char    yy[3];
char    month[20];              /* ie. January */
char    day[3];                 /* dd */
char    year[5];                /* 19yy */
char    date[30];               /* ie. January 31, 1983 */ 
char    week[20];               /* day of week Monday, Tuesday... */
char    ttime[12];              /* time of day  HH:MM:SS xM */
                                /*          where x = A or P */

/*                      variables used by the bbscfile.c routine */

char    h_next_msg[10];         /* next avail. message # */
char    h_date[10];             /* last update date of header file */
char    h_act_msg[10];
char    jnk[2];
int     lnctx;
int     chat_in_progress;
int     stop_chat;
int     h_act;
int     h_next;                 /* next avail. message # in integer */
long    xtable[1000];
long    save_d_pos;

long    d_pos;
long    old_long_date;
long    new_long_date;
long    xmm;
long    xdd;
long    xyy;
char    f_pathname[99];
char    u_pathname[99];
char    m_pathname[99];
char    c_pathname[99];
char    area_name[80];
char    f_pathtext[80];

/*                      end of variables used by bbscfile.c */
/*         Variables used by xmodem.c               */
char    x_filename[99];         /* filename */
char    x_pathandfile[512];      /* the full string */
char    who_am_i[99];
char    who_am_I[99];
char    f_lines[99][83];
int     dir_priv[99];

                        /* end of globals */

/* end of program */
