/*------------------------------------------------------------------------
       Name: bbsclist.c
   Comments: Display file areas and select one
  ------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "bbscdef.h"


extern int      user_priv;
extern char     port_id[4];
extern timer(), mon_toggle(), sys_toggle(), chat();


file_list()
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char           *buf_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int             length;

	while (1) {

	strcpy(buf128, LISTFILES);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\r\n\rThere are no files to read today!\n\r\n\r");
		return ;
	}
	portsout("\n\r\n\r\n\r                  *********************************\n\r");
	portsout("                  * Available Files To Read Today *\n\r");
	portsout("                  *********************************\n\r\n\r");
	portsout("\n\r                      Filename                         Description   \n\r");
	portsout("    ================================================== ================== \n\r");

	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 83);
		if ((fgets(f_lines[line_cnt], 82, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in File List: Notify Sysop!\n\r");
				return;
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 74;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 74, length);
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 73;
			strip(who_am_i);
			for (ptr = 0; ptr < 6; ptr++)
				*buf_ptr++ = '\0';
			*buf_ptr = '\0';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
			strip(buf128);
			term_space(buf128);
			portsout(buf128);
			portsout("\n\r");
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	if (line_cnt <= 1)
		{
		portsout("\n\r\n\rThere are no files to read today!\n\r\n\r");
		return;
		}
	portsout(CRLF);
	portsout(" Q) Quit --- exit file read section");
	portsout(CRLF);
	fclose(fpt);
	portsout(CRLF);

		portsout("Enter Selection ===> ");
		portsin_cmp(choice, 2, "Qq");
		portsout(CRLF);
		*choice = toupper(*choice);

		if (*choice == 'Q')
			return;


		index_value = atoi(choice);
		if (index_value > 0 && index_value < line_cnt) {
			if (dir_priv[index_value] <= user_priv) {
				parse_red(f_lines[index_value]);
				continue;
			}
		}
	}
}





parse_red(string)
	char           *string;
{

	register char  *file_ptr, *xptr;
	register int    i;

	file_ptr = buf128;
	substr(string, buf128, 1, 50);
	strip(buf128);
	term_space(buf128);
	cmd_p(buf128);
}
