/*------------------------------------------------------------------------
       Name: bbscarea.c
   Comments: Display file areas and select one
  ------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "bbscdef.h"


int             set_yet_m = FALSE;
extern int      user_priv;


change_msga( type ) int type;
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif

	char           *buf_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int             length;

	if( type == -1)
		return;

do_again:
	strcpy(buf128, MSGS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\rError Opening File Area List: Notify Sysop!\n\r");
		return (-1);
	}
	if(!type) {
	portsout("\n\r    Directory     Description                                      \n\r");
	portsout("    ============= ========================================== \n\r");
	}

	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 81);
		if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in Message Area List: Notify Sysop!\n\r");
				return (-1);
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 57;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 57, length);
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 56;
			for (ptr = 0; ptr < 6; ptr++)
				*buf_ptr++ = ' ';
			*buf_ptr = '\0';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
			if(!type) {
			strip(buf128);
			term_space(buf128);
			portsout(buf128);
			portsout("\n\r");
			}
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	if (line_cnt <= 1)
		return;
	if (set_yet_m && !type) {
		portsout(CRLF);
		portsout(" Q) Quit to Previous Menu");
	}
	if(!type)portsout(CRLF);
	fclose(fpt);
	if(!type)portsout(CRLF);

	while (1) {
		if(!type) {
		portsout("Enter Selection ===> ");
		portsin_cmp(choice, 2, "Qq");
		portsout(CRLF);
		*choice = toupper(*choice);

		if (*choice == 'Q' && set_yet_m)
			return (-1);


		index_value = atoi(choice);
		}
		else index_value = type;
		if (index_value > 0 && index_value < line_cnt) {
			if (dir_priv[index_value] <= user_priv) {
				parse_arg(f_lines[index_value]);
				set_yet_m = TRUE;
				hdrread();
				itoa(buf128,index_value);
				if(index_value > 9)
					{
					strcpy(l_m_base, buf128);
					}
				else
					{
					strcpy(l_m_base, "0");
					strcat(l_m_base,buf128);
					}
				
				rewritx();
				return (0);
			}
		}
		if( type != 0 ) {
			type = 0;
			portsout("\n\rInvalid directory request!\n\r");
			goto do_again;
		}
	}
}





parse_arg(string)
	char           *string;
{

	register char  *file_ptr, *xptr;
	register int    i;

	strcpy(m_pathname, ORGPATH);
	file_ptr = (m_pathname + strlen(m_pathname));
	xptr = who_am_I;

	i = 0;
	while (string[i] != ' ') {
		*file_ptr = string[i];
		*xptr = string[i];
		++xptr;
		++file_ptr;
		++i;
	}
	*file_ptr = '/';
	++file_ptr;
	*file_ptr = '\0';
	*xptr = '\0';

}
check_msga()
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char           *buf_ptr, *file_ptr, *char_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int             length, strl, ii;


	strcpy(buf128, MSGS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\rError Opening File Area List: Notify Sysop!\n\r");
		return (-1);
	}
	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 81);
		if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in Message Area List: Notify Sysop!\n\r");
				return (-1);
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 57;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 57, length);
			strl = strlen(dir_priv_ascii);
			if (strl == 0) {
				portsout("\n\rError reading privilege level\n\r");
				exit(1);
			}
			char_ptr = strchr(dir_priv_ascii, '*');
			if (char_ptr != NULL) {
				strcpy(c_pathname, ORGPATH);
				file_ptr = (c_pathname + strlen(c_pathname));
				ii = 0;
				while (f_lines[line_cnt][ii] != ' ') {
					*file_ptr = f_lines[line_cnt][ii];
					++file_ptr;
					++ii;
				}
				*file_ptr = '/';
				++file_ptr;
				*file_ptr = '\0';
				*char_ptr = '\0';
			}
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 56;
			for (ptr = 0; ptr < 5; ptr++)
				*buf_ptr++ = ' ';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	fclose(fpt);

	if (line_cnt <= 1)
		return;


	for (index_value = 1; index_value < line_cnt; index_value++) {
		if (dir_priv[index_value] <= user_priv) {
			parse_arg(f_lines[index_value]);
			hdrread();
			portsout("\n\rMail check for area '");
			portsout(who_am_I);
			portsout("'\n\r");
			mail_to_you();
			portsout("\n\r*************************************************\n\r");
		}
	}
/*                      SIG checking                         */
	strcpy(buf128, SIGS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		fclose(fpt);
		return;      /* No sigs */
	}
	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 83);
		if ((fgets(f_lines[line_cnt], 82, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in SIG Area List: Notify Sysop!\n\r");
				return (-1);
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 74;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 74, length);
			strl = strlen(dir_priv_ascii);
			if (strl == 0) {
				portsout("\n\rError reading privilege level\n\r");
				exit(1);
			}
			char_ptr = strchr(dir_priv_ascii, '*');
			if (char_ptr != NULL) {
				*char_ptr = '\0';
			}
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read_sig;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 73;
			for (ptr = 0; ptr < 5; ptr++)
				*buf_ptr++ = ' ';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
		}
next_read_sig:
		++line_cnt;
	}			/* end of while (fpt) */
	fclose(fpt);

	if (line_cnt <= 1)
		return;


	for (index_value = 1; index_value < line_cnt; index_value++) {
		if (dir_priv[index_value] <= user_priv) {
			parse_arg(f_lines[index_value]);
			strcat(m_pathname, "msgs/");
			hdrread();
			portsout("\n\rMail check for SIG area '");
			portsout(who_am_I);
			portsout("'\n\r");
			mail_to_you();
			portsout("\n\r*************************************************\n\r");
		}
	}
/*                   End of SIG checking                     */
}
check_msga_n()
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char           *buf_ptr, *file_ptr, *char_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int             length, strl, ii;


	strcpy(buf128, MSGS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\rError Opening File Area List: Notify Sysop!\n\r");
		return (-1);
	}
	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 81);
		if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in Message Area List: Notify Sysop!\n\r");
				return (-1);
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 57;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 57, length);
			strl = strlen(dir_priv_ascii);
			if (strl == 0) {
				portsout("\n\rError reading privilege level\n\r");
				exit(1);
			}
			char_ptr = strchr(dir_priv_ascii, '*');
			if (char_ptr != NULL) {
				strcpy(c_pathname, ORGPATH);
				file_ptr = (c_pathname + strlen(c_pathname));
				ii = 0;
				while (f_lines[line_cnt][ii] != ' ') {
					*file_ptr = f_lines[line_cnt][ii];
					++file_ptr;
					++ii;
				}
				*file_ptr = '/';
				++file_ptr;
				*file_ptr = '\0';
				*char_ptr = '\0';
			}
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read_n;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 56;
			for (ptr = 0; ptr < 5; ptr++)
				*buf_ptr++ = ' ';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
		}
next_read_n:
		++line_cnt;
	}			/* end of while (fpt) */
	fclose(fpt);

	if (line_cnt <= 1)
		return;


	for (index_value = 1; index_value < line_cnt; index_value++) {
		if (dir_priv[index_value] <= user_priv) {
			parse_arg(f_lines[index_value]);
			hdrread();
		}
	}
}
