#include <termio.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#define lowbyte(w) ((w) & 0377)
#define highbyte(w) lowbyte((w)>>8)
#define EMPTY '\0'
typedef enum {
	FALSE, TRUE
}               BOOLEAN;
static char     cbuf = EMPTY;
static struct termio tbufsave;

syserr(msg)
	char           *msg;
{
	extern int      errno, sys_nerr;
	extern char    *sys_errlist[];

	fprintf(stderr, "ERROR:%s (%d", msg, errno);
	if (errno > 0 && errno < sys_nerr)
		fprintf(stderr, ";%s)\n", sys_errlist[errno]);
	else
		fprintf(stderr, ")\n");
	exit(1);
}
fatal(msg)
	char           *msg;
{
	fprintf(stderr, "ERROR:%s\n", msg);
	exit(1);
}

setraw()
{
	struct termio   tbuf;
	if (ioctl(0, TCGETA, &tbuf) == -1)
		syserr("ioctl");
	tbufsave = tbuf;
	tbuf.c_iflag = 0;
	tbuf.c_iflag |= IXON;
	tbuf.c_iflag |= IXANY;

	tbuf.c_oflag &= ~OPOST;
	tbuf.c_lflag &= ~(ICANON | ISIG | ECHO);
	tbuf.c_cc[4] = 1;
	tbuf.c_cc[5] = 0;
	if (ioctl(0, TCSETAF, &tbuf) == -1)
		syserr("ioctl2");
}

restore()
{
	if (ioctl(0, TCSETAF, &tbufsave) == -1)
		syserr("ioctl3");
}
