#include <stdio.h>
#include <string.h>
#include <pwd.h>

struct name_list {
	char fname[99] ;
	char lname[99] ;
	struct name_list *next ;
} ;

struct name_list *nlhead ;

void add_to_nl();
void clean_up_nl() ;

main()
{
FILE *inbuf, *outbuf;
struct passwd *pw ;
int code;
int count;
char infile[99], outfile[99];
char cut_off[99] ;
char u_fname[99], u_lname[99], u_password[99], u_time1[99];
char u_date1[99], u_time2[99], u_date2[99], u_city[99];
char l_m_base[5], l_f_base[5], xprt[3], toggle[3];
long priv, l1, l2 ;

nlhead = (struct name_list *)NULL ;
printf("\nPurguser : a user purge by date program for XBBS\n");
printf("by Chuck Brandt 89.10.12 CIMTECHNOLOGIES XBBS (515)232-0072\n");
printf("This program will remove users who have not logged on your XBBS\n");
printf("since the date you specify.  It modifies users.bbs and userpriv.bbs\n");
printf("and saves backups of each file with an additional extension of .o\n");
printf("If you don't want to do this press <DEL> now!\n") ;

printf("\nInput the full path name of the user file: ");
scanf("%s", outfile);
printf("\n");
printf("\nEnter cut off date in the form MM/DD/YY: ") ;
scanf("%s", cut_off) ;
printf("\n") ;
strcpy(infile,outfile) ;
strcat(infile,".o") ;
unlink(infile) ;
link(outfile,infile) ;
unlink(outfile) ;
if((inbuf = fopen(infile, "r" )) == NULL) {
	printf("\n\rError opening input users file.\n\r");
	exit(1);
}
if((outbuf = fopen(outfile, "w" )) == NULL) {
	printf("\n\rError opening output users file.\n\r");
	exit(1);
}

while(1) {
	code = fscanf(inbuf,"%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~\n",
	u_fname, u_lname, u_password, u_time1, u_date1,
	u_time2, u_date2, u_city, l_m_base, l_f_base, xprt, toggle);
	if(code < 12 ) break;
	if ((date_compare(cut_off,u_date2)) <= 0) 
		fprintf(outbuf,"%s~%s~%s~%s~%s~%s~%s~%s~%s~%s~%s~%s~\n",
		u_fname, u_lname, u_password, u_time1, u_date1,
		u_time2, u_date2, u_city, l_m_base, l_f_base, xprt, toggle);
	else
		add_to_nl( u_fname, u_lname ) ;
}

fclose(inbuf);
fclose(outbuf) ;
chmod(outfile,0660) ;
pw = getpwnam("bbs") ;

if (pw != (struct passwd *)NULL) 
	chown(outfile,pw->pw_uid,pw->pw_gid) ;	

/* update userpriv.bbs */
printf("\nInput the full path name of the userpriv file: ");
scanf("%s", outfile);
printf("\n");
strcpy(infile,outfile) ;
strcat(infile,".o") ;
unlink(infile) ;
link(outfile,infile) ;
unlink(outfile) ;
if((inbuf = fopen(infile, "r" )) == NULL) {
	printf("\n\rError opening input userpriv file.\n\r");
	exit(1);
}
if((outbuf = fopen(outfile, "w" )) == NULL) {
	printf("\n\rError opening output userpriv file.\n\r");
	exit(1);
}
while (1) {
	code = fscanf(inbuf,"%s %s %ld %ld %ld\n",u_fname, u_lname, &priv, &l1, &l2) ;	
	if (code != 5) break ;
	if (!in_list(u_fname, u_lname))
		fprintf(outbuf,"%s %s %ld %ld %ld\n",u_fname, u_lname, priv, l1, l2) ;
}
clean_up_nl() ;
fclose(inbuf);
fclose(outbuf) ;
chmod(outfile,0660) ;
pw = getpwnam("bbs") ;

if (pw != (struct passwd *)NULL) 
	chown(outfile,pw->pw_uid,pw->pw_gid) ;	
	
}

void add_to_nl( first, last ) 
char *first, *last ;
{
struct name_list *cur, *new ;

new = (struct name_list *)malloc(sizeof(struct name_list)) ;
if (new == (struct name_list *)NULL) {
	fprintf(stderr,"purguser : ran out of memory!\n") ;
	return;
}
new->next = (struct name_list *)NULL ;
strcpy(new->fname,first) ;
strcpy(new->lname,last) ;

if (nlhead == (struct name_list *)NULL)  {
	nlhead = new ;
	return ;
}
cur = nlhead ;
while (cur->next != (struct name_list *)NULL)
	cur = cur->next ;
cur->next = new ;
return ;
}

int in_list(first, last)
char *first, *last ;
{
struct name_list *cur ;

cur = nlhead ;
while (cur) {
	if ((!strcmp(first,cur->fname)) && (!strcmp(last,cur->lname)))
		return(1) ;
	cur = cur->next ;
}
return(0) ;
}

void clean_up_nl()
{
struct name_list *cur, *pv ;

cur = nlhead ;
while (cur) {
	pv = cur ;
	cur = cur->next ;
	free(pv) ;
}
}

int date_compare( d1, d2 )
char *d1, *d2 ;
{
int mon1, day1, yr1, mon2, day2, yr2 ;

sscanf(d1,"%d/%d/%d", &mon1, &day1, &yr1) ;
sscanf(d2,"%d/%d/%d", &mon2, &day2, &yr2) ;
yr1 = yr1 + 1900 ;
yr2 = yr2 + 1900 ;

if (yr1 == yr2) {
	if (mon1 == mon2) {
		if (day1 == day2) 
			return(0) ;
		else { 
			if (day1 > day2) 
				return(1) ;
			else 
				return(-1) ;
		}
	}
	else  {
	      	if (mon1 > mon2) 
			return(1) ;
	 	else 
			return(-1) ;
	}
}
if (yr1 > yr2) return(1) ;
else return(-1) ;
}
 
