; Common Lisp compatibility macros

(define-macro (defun name args &rest body)
  `(define ,(cons name args)
     ,@body))

(define-macro (defmacro name args &rest body)
  `(define-macro ,(cons name args)
     ,@body))

(define-macro (setq place value)
  `(set! ,place ,value))

(define-macro (progn &rest body)
  `(begin ,@body))

(define-macro (function f)
  f)

(define (putprop sym val tag)
  (put sym tag val))

; Common Lisp names for the built in functions
(define RPLACA set-car!)
(define RPLACD set-cdr!)
(define NCONC append!)
(define LAST last-pair)
(define NTH list-ref)
(define NTHCDR list-tail)
(define BOUNDP bound?)
(define SET set-symbol-value!)
(define CHAR-INT char->integer)
(define INT-CHAR integer->char)
(define NULL null?)
(define ATOM atom?)
(define LISTP list?)
(define ENDP end?)
(define NUMBERP number?)
(define CONSP pair?)
(define SYMBOLP symbol?)
(define FLOATP real?)
(define INTEGERP integer?)
(define CHARACTERP char?)
(define STRINGP string?)
(define ARRAYP vector?)
(define STREAMP port?)
(define EQ eq?)
(define EQL eqv?)
(define EQUAL equal?)
(define ZEROP zero?)
(define PLUSP positive?)
(define MINUSP negative?)
(define ODDP odd?)
(define EVENP even?)
(define 1- -1+)
(define REM remainder)
(define MOD modulo)
(define SUBSEQ substring)
(define NSTRING-UPCASE string-upcase!)
(define NSTRING-DOWNCASE string-downcase!)
(define STRING< string<?)
(define STRING<= string <=?)
(define STRING= string=?)
(define STRING/= string/=?)
(define STRING>= string>=?)
(define STRING> string>?)
(define STRING-LESSP string-ci<?)
(define STRING-NOT-GREATERP string-ci<=?)
(define STRING-EQUAL string-ci=?)
(define STRING-NOT-EQUAL string-ci=?)
(define STRING-NOT-LESSP string-ci>=?)
(define STRING-GREATERP string-ci>?)
(define DIGIT-CHAR digit->char)
(define CHAR-CODE char->integer)
(define CODE-CHAR integer->char)
(define CHAR< char<?)
(define CHAR<= char<=?)
(define CHAR= char=?)
(define CHAR/= char/=?)
(define CHAR>= char>=?)
(define CHAR> char>?)
(define CHAR-LESSP char-ci<?)
(define CHAR-NOT-GREATERP char-ci<=?)
(define CHAR-EQUAL char-ci=?)
(define CHAR-NOT-EQUAL char-ci/=?)
(define CHAR-NOT-LESSP char-ci>=?)
(define CHAR-GREATERP char-ci>?)
(define UPPER-CASE-P char-upper-case?)
(define LOWER-CASE-P char-lower-case?)
(define BOTH-CASE-P char-alphabetic?)
(define DIGIT-CHAR-P char-numeric?)
(define ALPHANUMERICP char-alphanumeric?)
(define LISTEN char-ready?)
(define PRIN1 write)
(define PRINC display)
(define TERPRI newline)
(define FLATSIZE write-size)
(define FLATC display-size)
