/* msstuff.c - ms-dos specific routines */

#include <conio.h>
#include <time.h>
#include <signal.h>
#include <sys/stat.h>
#include "xlisp.h"

#ifdef MERLIN
#include "mstuff.h"
#include "math64.h"
#endif
#ifdef COLORIMG
#include "xlcolori.h"
#endif

#define LBSIZE 255

/* external variables */
extern LVAL s_unbound;
extern FILE *tfp;

/* local variables */
static LVAL s_usestdio = NULL;
static char progpath[LBSIZE+1];
static char lbuf[LBSIZE+1];
static int lpos[LBSIZE];
static int lindex;
static int lcount;
static int lposition;

static int xgetc(void);
static void xputc(int ch);

typedef LVAL (*FP)(void);

LVAL xsystem(void);
LVAL xrunprogram(void);

FUNDEF ossubrtab[] = {
{	"SYSTEM",		xsystem,		PKG_SYSTEM	},
{       "RUN-PROGRAM",          xrunprogram,            PKG_SYSTEM      },
{0,0,0}};

FUNDEF osxsubrtab[] = {
{0,0,0}};

/* main - the main routine */
int main(int argc,char *argv[])
{
    char *p;

    /* get the program path */
    strcpy(progpath,argv[0]);
    if ((p = strrchr(progpath,'\\')) != NULL
    ||  (p = strrchr(progpath,':')) != NULL)
	*++p = '\0';
    else
	strcpy(progpath,"");

    /* setup the timezone */
#if defined(IBM_CSET) || defined(MSC)
    _tzset();
#else
    tzset();
#endif

    xlmain(argc,argv);
    return 0;
}

/* osloadpath - return the load path */
char *osloadpath(char **pp)
{
    static char buf[256];
    char *src,*dst;
    
    /* initialize */
    if ((src = *pp) == NULL
    &&  (src = getenv("XLISP")) == NULL)
	src = progpath;

    /* find the next directory in the path */
    for (dst = buf; *src != '\0'; *dst++ = *src++)
	if (*src == ';') {
	    ++src;
	    break;
	}
    *dst = '\0';

    /* make sure the directory ends with a backslash */
    if (dst > buf && dst[-1] != '\\')
	strcat(dst,"\\");
    
    /* return this directory and position in the path */
    *pp = src;
    return dst == buf ? NULL : buf;
}

/* osexit - exit from XLISP */
void osexit(int sts)
{
    exit(sts);
}

int cc_happened = FALSE;

/* cc_handler - control-c handler */
void cc_handler(int signo)
{
    signal(SIGINT,cc_handler);
    cc_happened = TRUE;
}

/* osinit - initialize */
void osinit(char *banner)
{
    signal(SIGINT,cc_handler);
    ostputs(banner);
    ostputc('\n');
    lposition = 0;
    lindex = 0;
    lcount = 0;
}

/* osenter - enter os specific symbols and functions */
void osenter(void)
{
    FUNDEF *fdp;
    setvalue(xlenter("*SOFTWARE-TYPE*"),xlenter("WIN95-CONSOLE"));
    s_usestdio = xlenter("*USE-STDIO*");
    setvalue(s_usestdio,v_false);
    for (fdp = ossubrtab; fdp->fd_name != NULL; ++fdp)
        xlsubr(getpackagebyid(fdp->fd_pkgid),SUBR,fdp);
    for (fdp = osxsubrtab; fdp->fd_name != NULL; ++fdp)
        xlsubr(getpackagebyid(fdp->fd_pkgid),XSUBR,fdp);
#ifdef MERLIN
    menter();
    m64enter();
#endif
#ifdef COLORIMG
    cienter();
#endif
}

/* osfindsubr - find an os specific function */
FUNDEF *osfindsubr(char *name,int *ptype)
{
    FUNDEF *fdp;
    for (fdp = ossubrtab; fdp->fd_name != NULL; ++fdp)
        if (strcmp(fdp->fd_name,name) == 0) {
            *ptype = SUBR;
	    return fdp;
	}
    for (fdp = osxsubrtab; fdp->fd_name != NULL; ++fdp)
        if (strcmp(fdp->fd_name,name) == 0) {
            *ptype = XSUBR;
	    return fdp;
	}
#ifdef MERLIN
    if ((fdp = mfindsubr(name,ptype)) != NULL)
	return fdp;
    if ((fdp = m64findsubr(name,ptype)) != NULL)
	return fdp;
#endif
#ifdef COLORIMG
    if ((fdp = cifindsubr(name,ptype)) != NULL)
	return fdp;
#endif
    return NULL;
}

/* oserror - print an error message */
void oserror(char *msg)
{
    ostputs("error: ");
    ostputs(msg);
    ostputc('\n');
}

/* osfmodtime - return the modification time of a file */
int osfmodtime(char *fname,FIXTYPE *pModTime)
{                        
    struct stat info;
    int sts = stat(fname,&info);
    *pModTime = info.st_mtime;
    return sts == 0;
}

/* ostgetc - get a character from the terminal */
int ostgetc(void)
{
    int ch;

    /* check for stdio input */
    if (s_usestdio && getvalue(s_usestdio) != v_false)
        return getchar();
    
    /* check for a buffered character */
    if (lcount--)
	return (lbuf[lindex++]);

    /* get an input line */
    for (lcount = 0; ; )
	switch (ch = xgetc()) {
	case '\r':
		if (lcount >= LBSIZE)
		    xlfmterror("line too long");
		lbuf[lcount++] = '\n';
		xputc('\r'); xputc('\n'); lposition = 0;
		if (tfp)
		    for (lindex = 0; lindex < lcount; ++lindex)
			putc(lbuf[lindex],tfp);
		lindex = 0; lcount--;
		return (lbuf[lindex++]);
	case '\010':
	case '\177':
		if (lcount) {
		    lcount--;
		    while (lposition > lpos[lcount]) {
			xputc('\010'); xputc(' '); xputc('\010');
			lposition--;
		    }
		}
		break;
	case '\032':
		ostflush();
		return (EOF);
	default:
		if (lcount >= LBSIZE)
		    xlfmterror("line too long");
		if (ch == '\t' || (ch >= 0x20 && ch < 0x7F)) {
		    lbuf[lcount] = ch;
		    lpos[lcount] = lposition;
		    if (ch == '\t')
			do {
			    xputc(' ');
			} while (++lposition & 7);
		    else {
			xputc(ch); lposition++;
		    }
		    lcount++;
		}
		else {
		    ostflush();
		    switch (ch) {
		    case '\003':	xltoplevel();	/* control-c */
		    case '\007':	xlcleanup();	/* control-g */
		    case '\020':	xlcontinue();	/* control-p */
		    case '\032':	return (EOF);	/* control-z */
		    case '\034':	xlwrapup();	/* control-\ */
		    default:		return (ch);
		    }
		}
	}
}

/* ostputc - put a character to the terminal */
void ostputc(int ch)
{
    /* check for control characters */
    oscheck();

    /* check for stdio input */
    if (s_usestdio && getvalue(s_usestdio) != v_false) {
       if (ch == '\n')
            lposition = 0;
       else
            ++lposition;
       putchar(ch);
    }
    
    /* console output */
    else {
        /* output the character */
        if (ch == '\n') {
	    xputc('\r'); xputc('\n');
	    lposition = 0;
        }
        else {
	    xputc(ch);
	    lposition++;
       }
    }

   /* output the character to the transcript file */
   if (tfp)
	putc(ch,tfp);
}

/* ostatbol - are we at the beginning of a line? */
int ostatbol(void)
{
    return lposition == 0;
}

/* ostflush - flush the terminal input buffer */
void ostflush(void)
{
    lindex = lcount = lposition = 0;
}

/* ostcheck - check for control characters during execution */
int ostcheck(void)
{
    if (cc_happened) {
	cc_happened = FALSE;
	return 'C' - 0x40;
    }
    else
	return kbhit() ? getch() : 0;
}

/* osflushoutput - flush the output buffer */
void osflushoutput(void)
{
}

/* xgetc - get a character from the terminal without echo */
static int xgetc(void)
{
    return getch();
}

/* xputc - put a character to the terminal */
static void xputc(int ch)
{
    putch(ch);
}

/* xsystem - execute a system command */
LVAL xsystem(void)
{
    char *cmd = "COMMAND";
    if (moreargs())
	cmd = getstring(xlgastring());
    xllastarg();
    return cvfixnum((FIXTYPE)system(cmd));
}

/* xrunprogram - run a program */
LVAL xrunprogram(void)
{
    char cmdLine[256];
    strcpy(cmdLine,getstring(xlgastring()));
    while (moreargs()) {
        strcat(cmdLine," ");
	strcat(cmdLine,getstring(xlgastring()));
    }
    xllastarg();
    return cvfixnum((FIXTYPE)system(cmdLine));
}
