/* xlansi.c - ansi i/o functions */
/*	Copyright (c) 1995, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xlisp.h"

/* local variables */
static long rseed = 1L;

/* ossetrand - set random number seed */
void ossetrand(long seed)
{
    rseed = seed;
}

/* osrand - return a random number between 0 and n-1 */
long osrand(long n)
{
    long k1;

    /* make sure we don't get stuck at zero */
    if (rseed == 0L) rseed = 1L;

    /* algorithm taken from Dr. Dobbs Journal, November 1985, page 91 */
    k1 = rseed / 127773L;
    if ((rseed = 16807L * (rseed - k1 * 127773L) - k1 * 2836L) < 0L)
	rseed += 2147483647L;

    /* return a random number between 0 and n-1 */
    return rseed % n;
}

/* osaopen - open an ascii file */
FILE *osaopen(char *name,char *mode)
{
    return fopen(name,mode);
}

/* osbopen - open a binary file */
FILE *osbopen(char *name,char *mode)
{
    char bmode[10];
    strcpy(bmode,mode); strcat(bmode,"b");
    return fopen(name,bmode); 
}

/* osclose - close a file */
int osclose(FILE *fp)
{
    return fclose(fp);
}

/* ostell - get the current file position */
long ostell(FILE *fp)
{
    return ftell(fp);
}

/* osseek - set the current file position */
int osseek(FILE *fp,long offset,int whence)
{
    return fseek(fp,offset,whence);
}

/* ostputs - output a string to the terminal */
void ostputs(char *str)
{
    while (*str != '\0')
	ostputc(*str++);
}

/* oscheck - check for control characters during execution */
void oscheck(void)
{
    switch (ostcheck()) {
    case '\002':	/* control-b */
	ostflush();
	xlbreak();
	break;
    case '\003':	/* control-c */
	ostflush();
	xltoplevel();
	break;
    case '\024':	/* control-t */
	osinfo();
	break;
    case '\023':	/* control-s */
	while (ostcheck() != '\021')
	    ;
	break;
    case '\034':	/* control-\ */
	xlwrapup();
	break;
    }
}

/* osinfo - show information on control-t */
void osinfo(void)
{
    extern FIXTYPE nfree,gccalls,total;
    char buf[80];
    sprintf(buf,"\n[ Free: %ld, GC calls: %ld, Total: %ld ]",nfree,gccalls,total);
    errputstr(buf);
}

/* ostime - return the time */
time_t ostime(void)
{
    return time(0);
}

/* osalloc - allocate memory */
void *osalloc(FIXTYPE size)
{
    return calloc(1,(size_t)size);
}

/* osfree - free memory */
void osfree(void *ptr)
{
    free(ptr);
}

