/* xlbcode.h - xlisp compiler byte code definitions */
/*	Copyright (c) 1995, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#ifndef __XLBCODE_H__
#define __XLBCODE_H__

#define OP_NOP		0x00	/* nop */
#define OP_BRT		0x01	/* branch on true */
#define OP_BRF		0x02	/* branch on false */
#define OP_BR		0x03	/* branch unconditionally */
#define OP_LIT		0x04	/* load literal */
#define OP_GREF		0x05	/* global symbol value */
#define OP_GSET		0x06	/* set global symbol value */
#define OP_EREF		0x07	/* environment variable value */
#define OP_IREF		0x08	/* instance variable value (must be OP_EREF + 1) */
#define OP_ESET		0x09	/* set environment variable value */
#define OP_ISET		0x0A	/* set instance variable value (must be OP_ESET + 1) */
#define OP_CALL		0x0B	/* call a function */
#define OP_TCALL	0x0C	/* tail recursive call */
#define OP_RETURN	0x0D	/* return from a function */
#define OP_T		0x0E	/* load 'val' with t */
#define OP_NIL		0x0F	/* load 'val' with nil */
#define OP_PUSH		0x10	/* push the 'val' register */
#define OP_CLOSE	0x11	/* create a closure */
#define OP_ARGSEQ	0x12	/* argument count == m, n extra slots */
#define OP_ARGSGE	0x13	/* argument count >= min, m extra slots */
#define OP_ARGSBT	0x14	/* argument count >= min, <= max, n extra slots */
#define OP_OPTARG	0x15	/* check for an &optional argument */
#define OP_REST		0x16	/* build a &rest list with arguments n... */
#define OP_DELAY	0x17	/* create a promise */

#define OP_ATOM		0x18	/* atom predicate */
#define OP_EQ		0x19	/* eq? predicate */
#define OP_NULL		0x1A	/* null? (or not) predicate */
#define OP_CONS		0x1B	/* cons */
#define OP_CAR		0x1C	/* car */
#define OP_CDR		0x1D	/* cdr */
#define OP_SETCAR	0x1E	/* set-car! */
#define OP_SETCDR	0x1F	/* set-cdr! */

#define OP_ADD		0x20	/* add two numeric expressions */
#define OP_SUB		0x21	/* subtract two numeric expressions */
#define OP_MUL		0x22	/* multiply two numeric expressions */
#define OP_QUO		0x23	/* divide two integer expressions */
#define OP_LSS		0x24	/* less than */
#define OP_EQL		0x25	/* equal to */
#define OP_GTR		0x26	/* greater than */

#define OP_KEYARG	0x27	/* check for a &key argument */
#define OP_FRAME	0x28	/* create a new environment frame */
#define OP_UNFRAME	0x29	/* remove an environment frame */
#define OP_MVFRAME	0x2A	/* create a multiple value environment frame */
#define OP_MVPUSH	0x2B	/* push multiple values */
#define OP_MVCALL	0x2C	/* call a function with multiple values */
#define OP_MVTCALL	0x2D	/* tail recursive MVCALL */
#define OP_METHOD	0x2E	/* mark the current frame as a method frame */

#define OP_CATCH	0x2F	/* push a throw target frame */
#define OP_UNCATCH	0x30	/* pop a throw target frame */
#define OP_PROTECT	0x31	/* push a protect frame */
#define OP_UNPROTECT	0x32	/* pop a protect frame */

#define OP_MVPOP	0x33	/* pop multiple values */

#endif