/* xlftab.c - built-in function table */
/*	Copyright (c) 1995, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xlisp.h"

typedef LVAL (*FP)(void);

/* functions that call eval or apply */
FUNDEF xsubrtab[] = {

{	"APPLY",			(FP)xapply,	   	PKG_SCHEME	},
{	"CALL-WITH-CURRENT-CONTINUATION",(FP)xcallcc,	   	PKG_SCHEME	},
{	"CALL/CC",			(FP)xcallcc,	   	PKG_SCHEME	},
{	"MAP",				(FP)xmapcar,	   	PKG_SCHEME	},
{	"FOR-EACH",			(FP)xmapc,	   	PKG_SCHEME	},
{	"CALL-WITH-INPUT-FILE",		(FP)xcallwi,	   	PKG_SCHEME	},
{	"CALL-WITH-OUTPUT-FILE",	(FP)xcallwo,	   	PKG_SCHEME	},
{	"LOAD",				(FP)xload,	   	PKG_SCHEME	},
{	"LOAD-NOISILY",			(FP)xloadnoisily,  	PKG_SCHEME	},
{	"FORCE",			(FP)xforce,	   	PKG_SCHEME	},
{	"THROW",			(FP)xthrow,	   	PKG_XLISP	},
{	"THROW-ERROR",			(FP)xthrowerror,   	PKG_XLISP	},
{	"VALUES",			(FP)xvalues,	   	PKG_XLISP	},
{	"VALUES-LIST",			(FP)xvalueslist,   	PKG_XLISP	},
{	"INTERN",			(FP)xintern,	   	PKG_XLISP	},
{	"FIND-SYMBOL",			(FP)xfindsymbol,   	PKG_XLISP	},
{	"MAPCAR",			(FP)xmapcar,	   	PKG_XLISP	},
{	"MAPC",				(FP)xmapc,	   	PKG_XLISP	},
{	"MAPCAN",			(FP)xmapcan,	   	PKG_XLISP	},
{	"MAPLIST",			(FP)xmaplist,	   	PKG_XLISP	},
{	"MAPL",				(FP)xmapl,	   	PKG_XLISP	},
{	"MAPCON",			(FP)xmapcon,	   	PKG_XLISP	},
{	"SOME",				(FP)xsome,	   	PKG_XLISP	},
{	"EVERY",			(FP)xevery,	   	PKG_XLISP	},
{	"NOTANY",			(FP)xnotany,	   	PKG_XLISP	},
{	"NOTEVERY",			(FP)xnotevery,	   	PKG_XLISP	},
{	"FIND",				(FP)xfind,	   	PKG_XLISP	},
{	"FIND-IF",			(FP)xfindif,	   	PKG_XLISP	},
{	"FIND-IF-NOT",			(FP)xfindifnot,	   	PKG_XLISP	},
{	"MEMBER",			(FP)xmember,	   	PKG_XLISP	},
{	"MEMBER-IF",			(FP)xmemberif,	   	PKG_XLISP	},
{	"MEMBER-IF-NOT",		(FP)xmemberifnot,  	PKG_XLISP	},
{	"ASSOC",			(FP)xassoc,	   	PKG_XLISP	},
{	"ASSOC-IF",			(FP)xassocif,	   	PKG_XLISP	},
{	"ASSOC-IF-NOT",			(FP)xassocifnot,   	PKG_XLISP	},
{	"RASSOC",			(FP)xrassoc,	   	PKG_XLISP	},
{	"RASSOC-IF",			(FP)xrassocif,	   	PKG_XLISP	},
{	"RASSOC-IF-NOT",		(FP)xrassocifnot,  	PKG_XLISP	},
{	"REMOVE",			(FP)xremove,	   	PKG_XLISP	},
{	"REMOVE-IF",			(FP)xremoveif,	   	PKG_XLISP	},
{	"REMOVE-IF-NOT",		(FP)xremoveifnot,  	PKG_XLISP	},
{	"DELETE",			(FP)xdelete,	   	PKG_XLISP	},
{	"DELETE-IF",			(FP)xdeleteif,	   	PKG_XLISP	},
{	"DELETE-IF-NOT",		(FP)xdeleteifnot,  	PKG_XLISP	},
{	"COUNT",			(FP)xcount,	   	PKG_XLISP	},
{	"COUNT-IF",			(FP)xcountif,	   	PKG_XLISP	},
{	"COUNT-IF-NOT",			(FP)xcountifnot,   	PKG_XLISP	},
{	"POSITION",			(FP)xposition,	   	PKG_XLISP	},
{	"POSITION-IF",			(FP)xpositionif,   	PKG_XLISP	},
{	"POSITION-IF-NOT",		(FP)xpositionifnot,	PKG_XLISP	},

	/* read macros */
{	"%RM-HASH",			(FP)xrmhash,	   	PKG_SYSTEM	},
{	"%RM-QUOTE",			(FP)xrmquote,	   	PKG_SYSTEM	},
{	"%RM-DOUBLE-QUOTE",		(FP)xrmdquote,	   	PKG_SYSTEM	},
{	"%RM-BACKQUOTE",		(FP)xrmbquote,	   	PKG_SYSTEM	},
{	"%RM-COMMA",			(FP)xrmcomma,	   	PKG_SYSTEM	},
{	"%RM-LEFT-PAREN",		(FP)xrmlparen,	   	PKG_SYSTEM	},
{	"%RM-RIGHT-PAREN",		(FP)xrmrparen,	   	PKG_SYSTEM	},
{	"%RM-SEMICOLON",		(FP)xrmsemi,	   	PKG_SYSTEM	},

	/* methods */
{	"%CLASS-NEW",			(FP)clnew,	   	PKG_SYSTEM	},
{	"%SEND-SUPER",			(FP)xsendsuper,	   	PKG_SYSTEM	},

	/* system functions */
{	"SHOW-STACK",			(FP)xshowstack,		PKG_SYSTEM	},
{	"SHOW-CONTROL-STACK",		(FP)xshowcontrolstack,	PKG_SYSTEM	},
{	"SHOW-VALUE-STACK",		(FP)xshowvaluestack,	PKG_SYSTEM	},

{0,0,0} /* end of table marker */
};

/* normal functions */
FUNDEF subrtab[] = {

	/* list functions */
{	"CONS",				xcons,			PKG_SCHEME	},
{	"ACONS",			xacons,			PKG_XLISP	},
{	"CAR",				xcar,			PKG_SCHEME	},
{	"FIRST",			xcar,			PKG_XLISP	},
{	"CDR",				xcdr,			PKG_SCHEME	},
{	"REST",				xcdr,			PKG_XLISP	},
{	"CAAR",				xcaar,			PKG_XLISP	},
{	"CADR",				xcadr,			PKG_XLISP	},
{	"SECOND",			xcadr,			PKG_XLISP	},
{	"CDAR",				xcdar,			PKG_XLISP	},
{	"CDDR",				xcddr,			PKG_XLISP	},
{	"CAAAR",			xcaaar,			PKG_XLISP	},
{	"CAADR",			xcaadr,			PKG_XLISP	},
{	"CADAR",			xcadar,			PKG_XLISP	},
{	"CADDR",			xcaddr,			PKG_XLISP	},
{	"THIRD",			xcaddr,			PKG_XLISP	},
{	"CDAAR",			xcdaar,			PKG_XLISP	},
{	"CDADR",			xcdadr,			PKG_XLISP	},
{	"CDDAR",			xcddar,			PKG_XLISP	},
{	"CDDDR",			xcdddr,			PKG_XLISP	},
{	"CAAAAR", 			xcaaaar,		PKG_XLISP	},
{	"CAAADR",			xcaaadr,		PKG_XLISP	},
{	"CAADAR",			xcaadar,		PKG_XLISP	},
{	"CAADDR",			xcaaddr,		PKG_XLISP	},
{	"CADAAR",		 	xcadaar,		PKG_XLISP	},
{	"CADADR",			xcadadr,		PKG_XLISP	},
{	"CADDAR",			xcaddar,		PKG_XLISP	},
{	"CADDDR",			xcadddr,		PKG_XLISP	},
{	"FOURTH",			xcadddr,		PKG_XLISP	},
{	"CDAAAR",			xcdaaar,		PKG_XLISP	},
{	"CDAADR",			xcdaadr,		PKG_XLISP	},
{	"CDADAR",			xcdadar,		PKG_XLISP	},
{	"CDADDR",			xcdaddr,		PKG_XLISP	},
{	"CDDAAR",			xcddaar,		PKG_XLISP	},
{	"CDDADR",			xcddadr,		PKG_XLISP	},
{	"CDDDAR",			xcdddar,		PKG_XLISP	},
{	"CDDDDR",			xcddddr,		PKG_XLISP	},
{	"LIST",				xlist,			PKG_SCHEME	},
{	"LIST*",			xliststar,		PKG_XLISP	},
{	"PAIRLIS",			xpairlis,		PKG_XLISP	},
{	"COPY-LIST",			xcopylist,		PKG_XLISP	},
{	"COPY-TREE",			xcopytree,		PKG_XLISP	},
{	"COPY-ALIST",			xcopyalist,		PKG_XLISP	},
{	"APPEND",			xappend,		PKG_SCHEME	},
{	"REVERSE",			xreverse,		PKG_SCHEME	},
{	"LAST-PAIR",			xlast,			PKG_SCHEME	},
{	"LENGTH",			xlength,		PKG_SCHEME	},
{	"MEMBER",			xxmember,		PKG_SCHEME	},
{	"MEMV",				xxmemv,	   		PKG_SCHEME	},
{	"MEMQ",				xxmemq,	   		PKG_SCHEME	},
{	"ASSOC",			xxassoc,		PKG_SCHEME	},
{	"ASSV",				xxassv,	   		PKG_SCHEME	},
{	"ASSQ",				xxassq,			PKG_SCHEME	},
{	"LIST-REF",			xlistref,		PKG_SCHEME	},
{	"LIST-TAIL",			xlisttail,		PKG_SCHEME	},

	/* destructive list functions */
{	"SET-CAR!",			xsetcar,		PKG_SCHEME	},
{	"SET-CDR!",			xsetcdr,		PKG_SCHEME	},
{	"APPEND!",			xnappend,		PKG_XLISP	},

	/* package functions */
{	"MAKE-PACKAGE",			xmkpackage,		PKG_XLISP	},
{	"FIND-PACKAGE",			xfindpackage,		PKG_XLISP	},
{	"LIST-ALL-PACKAGES",		xlistallpackages,	PKG_XLISP	},
{	"PACKAGE-NAME",			xpackagename,		PKG_XLISP	},
{	"PACKAGE-NICKNAMES",		xpkgnicknames,		PKG_XLISP	},
{	"IN-PACKAGE",			xinpackage,		PKG_XLISP	},
{	"USE-PACKAGE",			xusepackage,		PKG_XLISP	},
{	"PACKAGE-USE-LIST",		xpkguselist,		PKG_XLISP	},
{	"UNUSE-PACKAGE",		xunusepackage,		PKG_XLISP	},
{	"PACKAGE-USED-BY-LIST",		xpkgusedbylist,		PKG_XLISP	},
{	"EXPORT",			xexport,		PKG_XLISP	},
{	"UNEXPORT",			xunexport,		PKG_XLISP	},
{	"IMPORT",			ximport,		PKG_XLISP	},
{	"UNINTERN",			xunintern,		PKG_XLISP	},
{	"MAKE-SYMBOL",			xmksymbol,		PKG_XLISP	},

	/* symbol functions */
{	"BOUND?",			xboundp,		PKG_SCHEME	},
{	"SYMBOL-NAME",			xsymname,		PKG_XLISP	},
{	"SYMBOL-VALUE",			xsymvalue,		PKG_XLISP	},
{	"SET-SYMBOL-VALUE!",		xsetsymvalue,		PKG_SCHEME	},
{	"SYMBOL-PACKAGE",		xsympackage,		PKG_XLISP	},
{	"SYMBOL-PLIST",			xsymplist,		PKG_XLISP	},
{	"SET-SYMBOL-PLIST!",		xsetsymplist,		PKG_SCHEME	},
{	"GENSYM",			xgensym,		PKG_XLISP	},
{	"GET",				xget,			PKG_XLISP	},
{	"PUT",				xput,			PKG_SCHEME	},
{	"REMPROP",			xremprop,		PKG_XLISP	},

	/* environment functions */
{	"THE-ENVIRONMENT",		xtheenvironment,	PKG_SCHEME	},
{	"PROCEDURE-ENVIRONMENT",	xprocenvironment,	PKG_SCHEME	},
{	"ENVIRONMENT?",			xenvp,			PKG_SCHEME	},
{	"ENVIRONMENT-BINDINGS",		xenvbindings,		PKG_SCHEME	},
{	"ENVIRONMENT-PARENT",		xenvparent,		PKG_SCHEME	},

	/* object functions */
{	"OBJECT?",			xobjectp,		PKG_SCHEME	},

	/* vector functions */
{	"VECTOR",			xvector,		PKG_SCHEME	},
{	"MAKE-VECTOR",			xmakevector,		PKG_SCHEME	},
{	"VECTOR-LENGTH",		xvlength,		PKG_SCHEME	},
{	"VECTOR-REF",			xvref,			PKG_SCHEME	},
{	"VECTOR-SET!",			xvset,			PKG_SCHEME	},

	/* array functions */
{	"MAKE-ARRAY",			xmakearray,		PKG_SCHEME	},
{	"ARRAY-REF",			xaref,			PKG_SCHEME	},
{	"ARRAY-SET!",			xaset,			PKG_SCHEME	},

	/* array functions */
{       "TABLE?",                       xtablep,                PKG_XLISP       },
{	"MAKE-TABLE",			xmaketable,		PKG_XLISP	},
{	"TABLE-REF",			xtableref,		PKG_XLISP	},
{	"TABLE-SET!",			xtableset,		PKG_XLISP	},
{       "TABLE-REMOVE!",                xtableremove,           PKG_XLISP       },
{       "EMPTY-TABLE!",                 xemptytable,            PKG_XLISP       },
{       "MAP-OVER-TABLE-ENTRIES",       xmapovertableentries,   PKG_XLISP       },

	/* conversion functions */
{	"SYMBOL->STRING",		xsymstr,		PKG_SCHEME	},
{	"STRING->SYMBOL",		xstrsym,		PKG_SCHEME	},
{	"VECTOR->LIST",			xvectlist,		PKG_SCHEME	},
{	"LIST->VECTOR",			xlistvect,		PKG_SCHEME	},
{	"STRING->LIST",			xstrlist,		PKG_SCHEME	},
{	"LIST->STRING",			xliststring,		PKG_SCHEME	},
{	"CHAR->INTEGER",		xcharint,		PKG_SCHEME	},
{	"INTEGER->CHAR",		xintchar,		PKG_SCHEME	},

	/* predicate functions */
{	"NULL?",			xnull,			PKG_SCHEME	},
{	"NOT",				xnull,			PKG_SCHEME	},
{	"ATOM?",			xatom,			PKG_SCHEME	},
{	"LIST?",			xlistp,			PKG_SCHEME	},
{	"END?",				xendp,			PKG_XLISP	},
{	"NUMBER?",			xnumberp,		PKG_SCHEME	},
{	"BOOLEAN?",			xbooleanp,		PKG_SCHEME	},
{	"PAIR?",			xpairp,			PKG_SCHEME	},
{	"SYMBOL?",			xsymbolp,		PKG_SCHEME	},
{	"COMPLEX?",			xrealp,			PKG_SCHEME	}, /*(1)*/
{	"REAL?",			xrealp,			PKG_SCHEME	},
{	"RATIONAL?",			xintegerp,		PKG_SCHEME	}, /*(1)*/
{	"INTEGER?",			xintegerp,		PKG_SCHEME	},
{	"CHAR?",			xcharp,			PKG_SCHEME	},
{	"STRING?",			xstringp,		PKG_SCHEME	},
{	"VECTOR?",			xvectorp,		PKG_SCHEME	},
{	"PROCEDURE?",			xprocedurep,		PKG_SCHEME	},
{	"PORT?",			xportp,			PKG_SCHEME	},
{	"INPUT-PORT?",			xinputportp,		PKG_SCHEME	},
{	"OUTPUT-PORT?",			xoutputportp,		PKG_SCHEME	},
{	"EOF-OBJECT?",			xeofobjectp,		PKG_SCHEME	},
{	"DEFAULT-OBJECT?",		xdefaultobjectp,	PKG_SCHEME	},
{	"EQ?",				xeq,			PKG_SCHEME	},
{	"EQV?",				xeqv,			PKG_SCHEME	},
{	"EQUAL?",			xequal,			PKG_SCHEME	},

	/* arithmetic functions */
{	"ZERO?",			xzerop,			PKG_SCHEME	},
{	"POSITIVE?",			xpositivep,		PKG_SCHEME	},
{	"NEGATIVE?",			xnegativep,		PKG_SCHEME	},
{	"ODD?",				xoddp,			PKG_SCHEME	},
{	"EVEN?",			xevenp,			PKG_SCHEME	},
{	"EXACT?",			xexactp,		PKG_SCHEME	},
{	"INEXACT?",			xinexactp,		PKG_SCHEME	},
{	"TRUNCATE",			xtruncate,		PKG_SCHEME	},
{	"FLOOR",			xfloor,			PKG_SCHEME	},
{	"CEILING",			xceiling,		PKG_SCHEME	},
{	"ROUND",			xround,			PKG_SCHEME	},
{	"1+",				xadd1,			PKG_SCHEME	},
{	"-1+",				xsub1,			PKG_SCHEME	},
{	"ABS",				xabs,			PKG_SCHEME	},
{	"SET-RANDOM-SEED!",		xsetrandomseed,		PKG_XLISP	},
{	"RANDOM",			xrandom,		PKG_XLISP	},
{	"ASH",				xash,			PKG_XLISP	},
{	"LSH",				xlsh,			PKG_XLISP	},
{	"+",				xadd,			PKG_SCHEME	},
{	"-",				xsub,			PKG_SCHEME	},
{	"*",				xmul,			PKG_SCHEME	},
{	"/",				xdiv,			PKG_SCHEME	},
{	"QUOTIENT",			xquo,			PKG_SCHEME	},
{	"REMAINDER",			xrem,			PKG_SCHEME	},
{	"MODULO",			xmod,			PKG_SCHEME	},
{	"MIN",				xmin,			PKG_SCHEME	},
{	"MAX",				xmax,			PKG_SCHEME	},
{	"SIN",				xsin,			PKG_SCHEME	},
{	"COS",				xcos,			PKG_SCHEME	},
{	"TAN",				xtan,			PKG_SCHEME	},
{	"ASIN",				xasin,			PKG_SCHEME	},
{	"ACOS",				xacos,			PKG_SCHEME	},
{	"ATAN",				xatan,			PKG_SCHEME	},
{	"EXP",				xxexp,			PKG_SCHEME	},
{	"SQRT",				xsqrt,			PKG_SCHEME	},
{	"EXPT",				xexpt,			PKG_SCHEME	},
{	"LOG",				xxlog,			PKG_SCHEME	},

	/* bitwise logical functions */
{	"LOGAND",			xlogand,		PKG_XLISP	},
{	"LOGIOR",			xlogior,		PKG_XLISP	},
{	"LOGXOR",			xlogxor,		PKG_XLISP	},
{	"LOGNOT",			xlognot,		PKG_XLISP	},

	/* numeric comparison functions */
{	"<",				xlss,			PKG_SCHEME	},
{	"<=",				xleq,			PKG_SCHEME	},
{	"=",				xeql,			PKG_SCHEME	},
{	"/=",				xneq,			PKG_SCHEME	},
{	">=",				xgeq,			PKG_SCHEME	},
{	">",				xgtr,			PKG_SCHEME	},

	/* string functions */
{	"MAKE-STRING",			xmakestring,		PKG_SCHEME	},
{	"STRING-LENGTH",		xstrlen,		PKG_SCHEME	},
{	"STRING-NULL?",			xstrnullp,		PKG_SCHEME	},
{	"STRING-APPEND",		xstrappend,		PKG_SCHEME	},
{	"STRING-REF",			xstrref,		PKG_SCHEME	},
{	"STRING-SET!",			xstrset,		PKG_SCHEME	},
{	"SUBSTRING",			xsubstring,		PKG_SCHEME	},
{	"STRING-UPCASE",		xupcase,		PKG_XLISP  	},
{	"STRING-DOWNCASE",		xdowncase,		PKG_XLISP	},
{	"STRING-UPCASE!",		xnupcase,		PKG_XLISP	},
{	"STRING-DOWNCASE!",		xndowncase,		PKG_XLISP	},
{	"STRING-TRIM",			xtrim,			PKG_XLISP	},
{	"STRING-LEFT-TRIM",		xlefttrim,		PKG_XLISP	},
{	"STRING-RIGHT-TRIM",		xrighttrim,		PKG_XLISP	},
{	"STRING<?",			xstrlss,		PKG_SCHEME	},
{	"STRING<=?",			xstrleq,		PKG_SCHEME	},
{	"STRING=?",			xstreql,		PKG_SCHEME	},
{	"STRING/=?",			xstrneq,		PKG_SCHEME	},
{	"STRING>=?",			xstrgeq,		PKG_SCHEME	},
{	"STRING>?",			xstrgtr,		PKG_SCHEME	},
{	"STRING-CI<?",			xstrilss,		PKG_SCHEME	},
{	"STRING-CI<=?",			xstrileq,		PKG_SCHEME	},
{	"STRING-CI=?",			xstrieql,		PKG_SCHEME	},
{	"STRING-CI/=?",			xstrineq,		PKG_SCHEME	},
{	"STRING-CI>=?",			xstrigeq,		PKG_SCHEME	},
{	"STRING-CI>?",			xstrigtr,		PKG_SCHEME	},
{	"STRING-SEARCH",		xstrsearch,		PKG_SCHEME	},
{	"STRING-SEARCH-CI",		xstrisearch,		PKG_SCHEME	},
{	"NUMBER->STRING",		xnumstr,		PKG_SCHEME	},
{	"STRING->NUMBER",		xstrnum,		PKG_SCHEME	},

	/* character functions */
{	"CHAR<?",			xchrlss,		PKG_SCHEME	},
{	"CHAR<=?",			xchrleq,		PKG_SCHEME	},
{	"CHAR=?",			xchreql,		PKG_SCHEME	},
{	"CHAR/=?",			xchrneq,		PKG_SCHEME	},
{	"CHAR>=?",			xchrgeq,		PKG_SCHEME	},
{	"CHAR>?",			xchrgtr,		PKG_SCHEME	},
{	"CHAR-CI<?",			xchrilss,		PKG_SCHEME	},
{	"CHAR-CI<=?",			xchrileq,		PKG_SCHEME	},
{	"CHAR-CI=?",			xchrieql,		PKG_SCHEME	},
{	"CHAR-CI/=?",			xchrineq,		PKG_SCHEME	},
{	"CHAR-CI>=?",			xchrigeq,		PKG_SCHEME	},
{	"CHAR-CI>?",			xchrigtr,		PKG_SCHEME	},
{	"CHAR-UPPER-CASE?",		xuppercasep,		PKG_SCHEME	},
{	"CHAR-LOWER-CASE?",		xlowercasep,		PKG_SCHEME	},
{	"CHAR-ALPHABETIC?",		xbothcasep,		PKG_SCHEME	},
{	"CHAR-NUMERIC?",		xdigitp,		PKG_SCHEME	},
{	"CHAR-WHITESPACE?",		xwhitespacep,		PKG_SCHEME	},
{	"CHAR-ALPHANUMERIC?",		xalphanumericp,		PKG_SCHEME	},
{	"STRING",			xstring,		PKG_XLISP	},
{	"CHAR",				xchar,			PKG_XLISP	},
{	"CHAR-UPCASE",			xchupcase,		PKG_XLISP	},
{	"CHAR-DOWNCASE",		xchdowncase,		PKG_XLISP	},
{	"DIGIT->CHAR",			xdigitchar,		PKG_XLISP	},

	/* I/O functions */
{	"READ",				xread,			PKG_SCHEME	},
{	"READ-DELIMITED-LIST",		xreaddelimitedlist,	PKG_XLISP	},
{	"READ-LINE",			xreadline,		PKG_XLISP	},
{	"READ-CHAR",			xrdchar,		PKG_XLISP	},
{       "UNREAD-CHAR",                  xunreadchar,            PKG_XLISP        },
{	"PEEK-CHAR",			xpkchar,		PKG_XLISP	},
{	"CHAR-READY?",			xcharready,		PKG_SCHEME	},
{	"CLEAR-INPUT",			xclearinput,		PKG_XLISP	},
{	"READ-BYTE",			xrdbyte,		PKG_XLISP	},
{	"READ-SHORT",			xrdshort,		PKG_XLISP	},
{	"READ-SHORT-HIGH-FIRST",	xrdshorthf,		PKG_XLISP	},
{	"READ-SHORT-LOW-FIRST",	        xrdshortlf,		PKG_XLISP	},
{	"READ-LONG",			xrdlong,		PKG_XLISP	},
{	"READ-LONG-HIGH-FIRST",		xrdlonghf,		PKG_XLISP	},
{	"READ-LONG-LOW-FIRST",		xrdlonglf,		PKG_XLISP	},
{	"WRITE",			xwrite,			PKG_SCHEME	},
{	"WRITE-CHAR",			xwrchar,		PKG_XLISP	},
{	"WRITE-BYTE",			xwrbyte,		PKG_XLISP	},
{	"WRITE-SHORT",			xwrshort,		PKG_XLISP	},
{	"WRITE-SHORT-HIGH-FIRST",	xwrshorthf,		PKG_XLISP	},
{	"WRITE-SHORT-LOW-FIRST",	xwrshortlf,		PKG_XLISP	},
{	"WRITE-LONG",			xwrlong,		PKG_XLISP	},
{	"WRITE-LONG-HIGH-FIRST",	xwrlonghf,		PKG_XLISP	},
{	"WRITE-LONG-LOW-FIRST",	        xwrlonglf,		PKG_XLISP	},
{	"DISPLAY",			xdisplay,		PKG_SCHEME	},
{	"PRINT",			xprint,			PKG_XLISP	},
{	"WRITE-SIZE",			xwritesize,		PKG_XLISP	},
{	"DISPLAY-SIZE",			xdisplaysize,		PKG_XLISP	},
{	"NEWLINE",			xnewline,		PKG_SCHEME	},
{	"FRESH-LINE",			xfreshline,		PKG_XLISP	},
{	"FORMAT",			xformat,		PKG_XLISP	},

	/* print control functions */
{	"PRINT-BREADTH",		xprbreadth,		PKG_SCHEME	},
{	"PRINT-DEPTH",			xprdepth,		PKG_SCHEME	},

	/* file I/O functions */
{       "FILE-MODIFICATION-TIME",       xfilemodtime,           PKG_XLISP       },
{	"OPEN-INPUT-FILE",		xopeni,			PKG_SCHEME	},
{	"OPEN-OUTPUT-FILE",		xopeno,			PKG_SCHEME	},
{	"OPEN-APPEND-FILE",		xopena,			PKG_SCHEME	},
{	"OPEN-UPDATE-FILE",		xopenu,			PKG_SCHEME	},
{	"CLOSE-PORT",			xclose,			PKG_SCHEME	},
{	"CLOSE-INPUT-PORT",		xclosei,		PKG_SCHEME	},
{	"CLOSE-OUTPUT-PORT",		xcloseo,		PKG_SCHEME	},
{	"GET-FILE-POSITION",		xgetfposition,		PKG_SCHEME	},
{	"SET-FILE-POSITION!",		xsetfposition,		PKG_SCHEME	},
{	"CURRENT-INPUT-PORT",		xcurinput,		PKG_SCHEME	},
{	"CURRENT-OUTPUT-PORT",		xcuroutput,		PKG_SCHEME	},
{	"CURRENT-ERROR-PORT",		xcurerror,		PKG_SCHEME	},
{	"MAKE-STRING-INPUT-STREAM", 	xmkstrinput,		PKG_XLISP	},
{	"MAKE-STRING-OUTPUT-STREAM",	xmkstroutput,		PKG_XLISP	},
{	"GET-OUTPUT-STREAM-STRING",	xgetstroutput,		PKG_XLISP	},
{	"MAKE-OBJECT-STREAM",		xmkobjstream,		PKG_XLISP	},

	/* miscellaneous functions */
{	"IDENTITY",			xidentity,		PKG_XLISP	},

	/* utility functions */
{	"TRANSCRIPT-ON",		xtranson,		PKG_SYSTEM	},
{	"TRANSCRIPT-OFF",		xtransoff,		PKG_SYSTEM	},
{	"GETARG",			xgetarg,		PKG_SYSTEM	},
{	"GET-TIME",			xgettime,		PKG_SYSTEM	},
{	"EXIT",				xexit,			PKG_SYSTEM	},
{	"QUIT",				xexit,			PKG_SYSTEM	},
{	"COMPILE",			xcompile,		PKG_SYSTEM	},
{	"DECOMPILE",			xdecompile,		PKG_SYSTEM	},
{	"FASL-WRITE-PROCEDURE",		xfaslwriteprocedure,	PKG_SYSTEM	},
{	"FASL-READ-PROCEDURE",		xfaslreadprocedure,	PKG_SYSTEM	},
{	"GC",				xgc,			PKG_SYSTEM	},
{	"ROOM",				xroom,			PKG_SYSTEM	},
{	"SAVE",				xsave,			PKG_SYSTEM	},
{	"RESTORE",			xrestore,		PKG_SYSTEM	},
{	"ERROR",			xerror,			PKG_SYSTEM	},

	/* debugging functions */
{	"TRACE-ON",			xtraceon,		PKG_SYSTEM	},
{	"TRACE-OFF",			xtraceoff,		PKG_SYSTEM	},

	/* crecord functions */
{	"ALLOCATE-CMEMORY",		xalloccmemory,		PKG_SYSTEM	},
{	"FREE-CMEMORY",			xfreecmemory,		PKG_SYSTEM	},
{	"FOREIGN-POINTER?",		xforeignptrp,		PKG_SYSTEM	},
{	"FOREIGN-POINTER-TYPE",		xforeignptrtype,	PKG_SYSTEM	},
{	"SET-FOREIGN-POINTER-TYPE!",	xsetforeignptrtype,	PKG_SYSTEM	},
{	"FOREIGN-POINTER-TYPE?",	xforeignptrtypep,	PKG_SYSTEM	},
{	"FOREIGN-POINTER-EQ?",	        xforeignptreqp,	        PKG_SYSTEM	},
{	"GET-CRECORD-FIELD",		xgetcrecfield,		PKG_SYSTEM	},
{	"GET-CRECORD-FIELD-ADDRESS",	xgetcrecfieldaddr,	PKG_SYSTEM	},
{	"SET-CRECORD-FIELD!",		xsetcrecfield,		PKG_SYSTEM	},
{	"GET-CRECORD-STRING",		xgetcrecstring,		PKG_SYSTEM	},
{	"SET-CRECORD-STRING!",		xsetcrecstring,		PKG_SYSTEM	},
{	"GET-CRECORD-TYPE-SIZE",	xgetcrectypesize,	PKG_SYSTEM	},
{	"NULL-POINTER?",		xnullpointerp,		PKG_SYSTEM	},

	/* internal functions */
{	"%CAR",				xicar,			PKG_SYSTEM	},
{	"%CDR",				xicdr,			PKG_SYSTEM	},
{	"%SET-CAR!",			xisetcar,		PKG_SYSTEM	},
{	"%SET-CDR!",			xisetcdr,		PKG_SYSTEM	},
{	"%VECTOR-LENGTH",		xivlength,		PKG_SYSTEM	},
{	"%VECTOR-REF",			xivref,			PKG_SYSTEM	},
{	"%VECTOR-SET!",			xivset,			PKG_SYSTEM	},
{	"%VECTOR-BASE",			xivbase,		PKG_SYSTEM	},
{	"%ADDRESS-OF",			xiaddrof,		PKG_SYSTEM	},
{	"%FORMAT-ADDRESS",		xifmtaddr,		PKG_SYSTEM	},
{	"%HACK",			xhack,			PKG_SYSTEM	},

	/* methods */
{	"%CLASS-MAKE-INSTANCE",		clmakeinstance,	        PKG_SYSTEM	},
{	"%CLASS-INITIALIZE",		clinitialize,		PKG_SYSTEM	},
{	"%CLASS-ANSWER",		clanswer,		PKG_SYSTEM	},
{	"%CLASS-SHOW",			clshow,			PKG_SYSTEM	},
{	"%OBJECT-INITIALIZE",		obinitialize,		PKG_SYSTEM	},
{	"%OBJECT-CLASS",		obclass,		PKG_SYSTEM	},
{	"%OBJECT-GET-VARIABLE",		obgetvariable,		PKG_SYSTEM	},
{	"%OBJECT-SET-VARIABLE!",	obsetvariable,		PKG_SYSTEM	},
{	"%OBJECT-PRINT",		obprint,		PKG_SYSTEM	},
{	"%OBJECT-SHOW",			obshow,			PKG_SYSTEM	},

{0,0,0} /* end of table marker */
};

/* Notes:

   (1)	This version only supports integers and reals.

*/

/* xlfinit - initialize the built-in functions */
void xlfinit(void)
{
    FUNDEF *fdp;
    for (fdp = subrtab; fdp->fd_subr != NULL; ++fdp)
	xlsubr(getpackagebyid(fdp->fd_pkgid),SUBR,fdp);
    for (fdp = xsubrtab; fdp->fd_subr != NULL; ++fdp)
	xlsubr(getpackagebyid(fdp->fd_pkgid),XSUBR,fdp);
}

/* xlfindsubr - find a subr in the internal table */
FUNDEF *xlfindsubr(char *name,int *ptype)
{
    FUNDEF *fdp;
    for (fdp = subrtab; fdp->fd_name != NULL; ++fdp)
	if (strcmp(fdp->fd_name,name) == 0) {
	    *ptype = XSUBR;
	    return fdp;
	}
    for (fdp = xsubrtab; fdp->fd_name != NULL; ++fdp)
	if (strcmp(fdp->fd_name,name) == 0) {
	    *ptype = XSUBR;
	    return fdp;
	}
    return NULL;
}

