/* xlinit.c - xlisp initialization routines */
/*	Copyright (c) 1995, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xlisp.h"
#include "xlbcode.h"

/* macro to store a byte into a bytecode vector */
#define pb(x)	(*bcode++ = (x))

/* shorthand for FIRSTENV */
#define FE	FIRSTENV

/* global variables */
LVAL lk_optional,lk_rest,lk_key,lk_aux,lk_allow_other_keys,slk_optional,slk_rest;
LVAL packages,eof_object,default_object,s_unassigned,s_error;
LVAL s_readtable,s_nmacro,s_tmacro,s_wspace,s_const,s_sescape,s_mescape;
LVAL s_quote,s_function,s_quasiquote,s_unquote,s_unquotesplicing,s_dot;
LVAL s_package,s_eval,s_load,s_unbound,s_stdin,s_stdout,s_stderr;
LVAL s_print,s_printcase,k_upcase,k_downcase,s_eql;
LVAL k_internal,k_external,k_inherited,k_key,k_uses,k_test,k_testnot;
LVAL k_start,k_end,k_1start,k_1end,k_2start,k_2end,k_count;
LVAL s_fixfmt,s_flofmt,s_freeptr,s_backtrace;

/* external variables */
extern LVAL xlisppackage,schemepackage,systempackage;

/* local functions */
static LVAL getloadpath(void);

/* xlinitws - create an initial workspace */
void xlinitws(int ssize)
{
    unsigned char *bcode;
    LVAL code;

    /* allocate memory for the workspace */
    xlminit(ssize);

    /* initialize the packages */
    xlpinit();

    /* enter the eof object */
    eof_object = cons(internandexport("**EOF**",systempackage),v_nil);
    
    /* enter the default object */
    default_object = cons(internandexport("**DEFAULT**",systempackage),v_nil);

    /* initialize the error handlers */
    setvalue(internandexport("*ERROR-HANDLER*",systempackage),v_nil);
    setvalue(internandexport("*UNBOUND-HANDLER*",systempackage),v_nil);
    
    /* install the built-in functions and objects */
    xlfinit();
    xloinit();
    
    /* enter all of the symbols used by the runtime system */
    xlsymbols();

    /* enter all os specific symbols and functions */
    osenter();
    
    /* initialize the reader */
    xlrinit();
    
    /* set the initial values of the symbols T and NIL */
    setvalue(internandexport("T",schemepackage),v_true);
    setvalue(internandexport("NIL",schemepackage),v_nil);

    /* default to lowercase output of symbols */
    setvalue(s_printcase,k_downcase);

    /* setup the print formats for numbers */
    setvalue(s_fixfmt,cvcstring(IFMT));
    setvalue(s_flofmt,cvcstring(FFMT));

    /* disable backtrace */
    setvalue(s_backtrace,v_nil);
    
    /* build the 'eval' function */
    code = newcode(FIRSTLIT+1); cpush(code);
    setbcode(code,xlnewstring(0x0c));
    setcname(code,xlenter("EVAL"));
    setvnames(code,cons(xlenter("X"),v_nil));
    setelement(code,FIRSTLIT,xlenter("COMPILE"));
    drop(1);

    /* store the byte codes */
    bcode = getcodestr(code);

pb(OP_ARGSEQ);pb(0x01);		/* 0000 ARGSEQ 01		*/
pb(OP_EREF);pb(0x00);pb(FE+0);	/* 0002 EREF 00 +0 ; x		*/
pb(OP_PUSH);			/* 0005 PUSH			*/
pb(OP_GREF);pb(0x03);		/* 0006 GREF 03 ; compile	*/
pb(OP_CALL);pb(0x01);		/* 0008 CALL 01			*/
pb(OP_TCALL);pb(0x00);		/* 000a TCALL 00		*/

    setvalue(getelement(code,1),cvclosure(code,v_nil));

    /* setup the initialization code */
    code = newcode(FIRSTLIT+2); cpush(code);
    setbcode(code,xlnewstring(0x09));
    setcname(code,internandexport("*INITIALIZE*",systempackage));
    setvnames(code,v_nil);
    setelement(code,FIRSTLIT,cvcstring("xlisp.ini"));
    setelement(code,FIRSTLIT+1,xlenter("LOAD"));
    drop(1);

    /* store the byte codes */
    bcode = getcodestr(code);

pb(OP_ARGSEQ);pb(0x00);		/* 0000 ARGSEQ 00		*/
pb(OP_LIT);pb(0x03);		/* 0002 LIT 03 ; "xlisp.ini"	*/
pb(OP_PUSH);			/* 0004 PUSH			*/
pb(OP_GREF);pb(0x04);		/* 0005 GREF 04 ; load		*/
pb(OP_TCALL);pb(0x01);		/* 0007 TCALL 01		*/

    setvalue(getelement(code,1),cvclosure(code,v_nil));

    /* setup the main loop code */
    code = newcode(FIRSTLIT+6); cpush(code);
    setbcode(code,xlnewstring(0x1b));
    setcname(code,internandexport("*TOPLEVEL*",systempackage));
    setvnames(code,v_nil);
    setelement(code,FIRSTLIT,cvcstring("\n\n> "));
    setelement(code,FIRSTLIT+1,xlenter("DISPLAY"));
    setelement(code,FIRSTLIT+2,xlenter("READ"));
    setelement(code,FIRSTLIT+3,xlenter("EVAL"));
    setelement(code,FIRSTLIT+4,xlenter("PRINT"));
    setelement(code,FIRSTLIT+5,internandexport("*TOPLEVEL*",systempackage));
    drop(1);

    /* store the byte codes */
    bcode = getcodestr(code);

pb(OP_ARGSEQ);pb(0x00);		/* 0000 ARGSEQ 00		*/
pb(OP_LIT);pb(0x03);		/* 0002 LIT 03 ; "\n> "		*/
pb(OP_PUSH);			/* 0004 PUSH			*/
pb(OP_GREF);pb(0x04);		/* 0005 GREF 04 ; display	*/
pb(OP_CALL);pb(0x01);		/* 0007 CALL 01			*/
pb(OP_GREF);pb(0x05);		/* 0009 GREF 05 ; read		*/
pb(OP_CALL);pb(0x00);		/* 000b CALL 00			*/
pb(OP_PUSH);			/* 000d PUSH			*/
pb(OP_GREF);pb(0x06);		/* 000e GREF 06 ; eval		*/
pb(OP_CALL);pb(0x01);		/* 0010 CALL 01			*/
pb(OP_PUSH);			/* 0012 PUSH			*/
pb(OP_GREF);pb(0x07);		/* 0013 GREF 07 ; print		*/
pb(OP_CALL);pb(0x01);		/* 0015 CALL 01			*/
pb(OP_GREF);pb(0x08);		/* 0017 GREF 08 ; *toplevel*	*/
pb(OP_TCALL);pb(0x00);		/* 0019 TCALL 00		*/

    setvalue(getelement(code,1),cvclosure(code,v_nil));

    /* path to executable file */
    setvalue(xlenter("*LOAD-PATH*"),getloadpath());
}

/* getloadpath - get the load path */
static LVAL getloadpath(void)
{
    char *dir,*p = NULL;
    LVAL this,last;

    /* append each directory to the path */
    for (xlval = v_nil; (dir = osloadpath(&p)) != NULL; ) {
	this = cons(cvcstring(dir),v_nil);
	if (xlval == v_nil)
	    xlval = this;
        else
	    rplacd(last,this);
        last = this;
    }
    return xlval;
}

/* xlsymbols - lookup/enter all symbols used by the runtime system */
void xlsymbols(void)
{
    short portflags;
    LVAL sym;
    
    /* enter the unbound indicator */
    s_unbound = internandexport("*UNBOUND*",xlisppackage);
    setvalue(s_unbound,s_unbound);

    /* enter the #T symbol and set its value */
    v_true = internandexport("#T",schemepackage);
    setvalue(v_true,v_true);

    /* enter the symbols used by the system */
    s_eval = internandexport("EVAL",schemepackage);
    s_load = internandexport("LOAD",schemepackage);
    s_unassigned = internandexport("#!UNASSIGNED",schemepackage);
    s_package = internandexport("*PACKAGE*",xlisppackage);
    s_error = internandexport("ERROR",systempackage);

    /* enter the i/o symbols */
    s_stdin  = internandexport("*STANDARD-INPUT*",schemepackage);
    s_stdout = internandexport("*STANDARD-OUTPUT*",schemepackage);
    s_stderr = internandexport("*ERROR-OUTPUT*",schemepackage);
    
    /* enter the symbols used by the printer */
    s_fixfmt = internandexport("*FIXNUM-FORMAT*",schemepackage);
    s_flofmt = internandexport("*FLONUM-FORMAT*",schemepackage);

    /* property tag for foreign pointer free function */
    s_freeptr = internandexport("%FREE-POINTER",xlisppackage);

    /* scheme keywords */
    slk_optional 	= internandexport("#!OPTIONAL",schemepackage);
    slk_rest  	 	= internandexport("#!REST",schemepackage);

    /* enter the lambda list keywords */
    lk_optional  	= internandexport("&OPTIONAL",xlisppackage);
    lk_rest      	= internandexport("&REST",xlisppackage);
    lk_key       	= internandexport("&KEY",xlisppackage);
    lk_aux       	= internandexport("&AUX",xlisppackage);
    lk_allow_other_keys = internandexport("&ALLOW-OTHER-KEYS",xlisppackage);

    /* enter symbols needed by the reader */
    s_readtable		= internandexport("*READTABLE*",xlisppackage);
    s_nmacro		= internandexport("NON-TERMINATING-MACRO",xlisppackage);
    s_tmacro		= internandexport("TERMINATING-MACRO",xlisppackage);
    s_wspace		= internandexport("WHITE-SPACE",xlisppackage);
    s_const		= internandexport("CONSTITUENT",xlisppackage);
    s_sescape		= internandexport("SINGLE-ESCAPE",xlisppackage);
    s_mescape		= internandexport("MULTIPLE-ESCAPE",xlisppackage);
    s_quote	        = internandexport("QUOTE",xlisppackage);
    s_function	        = internandexport("FUNCTION",xlisppackage);
    s_quasiquote        = internandexport("QUASIQUOTE",xlisppackage);
    s_unquote	        = internandexport("UNQUOTE",xlisppackage);
    s_unquotesplicing   = internandexport("UNQUOTE-SPLICING",xlisppackage);
    s_dot	        = internandexport(".",xlisppackage);

    /* 'else' is a useful synonym for #t in cond clauses */
    sym = internandexport("ELSE",schemepackage);
    setvalue(sym,v_true);

    /* setup stdin/stdout/stderr */
    portflags = PF_INPUT | PF_OUTPUT | PF_TERMINAL;
    if (ostatbol()) portflags |= PF_BOL;
    setvalue(s_stdin,cvfstream(NULL,portflags));
    setvalue(s_stdout,getvalue(s_stdin));
    setvalue(s_stderr,getvalue(s_stdin));

    /* enter print, *print-case* and its keywords */
    s_print	= internandexport("PRINT",xlisppackage);
    s_printcase	= internandexport("*PRINT-CASE*",schemepackage);
    k_upcase	= internandexport("UPCASE",schemepackage);
    k_downcase	= internandexport("DOWNCASE",schemepackage);
    
    /* keywords used by intern and find-symbol */
    k_internal  = xlkenter("INTERNAL");
    k_external  = xlkenter("EXTERNAL");
    k_inherited = xlkenter("INHERITED");
    k_uses      = xlkenter("USES");
    
    /* other useful symbols */
    s_eql	= internandexport("EQL",xlisppackage);
    s_backtrace = internandexport("*BACKTRACE*",xlisppackage);

    /* other useful keywords */
    k_key	= xlkenter("KEY");
    k_test      = xlkenter("TEST");
    k_testnot   = xlkenter("TEST-NOT");
    k_start	= xlkenter("START");
    k_end	= xlkenter("END");
    k_1start	= xlkenter("START1");
    k_1end	= xlkenter("END1");
    k_2start	= xlkenter("START2");
    k_2end	= xlkenter("END2");
    k_count	= xlkenter("COUNT");
    
    /* initialize the object system symbols */
    obsymbols();
}

/* getpackagebyid - get a package by a package id */
LVAL getpackagebyid(int id)
{
    switch (id) {
    case PKG_XLISP:	return xlisppackage;
    case PKG_SCHEME:	return schemepackage;
    case PKG_SYSTEM:	return systempackage;
    default:		xlfmtabort("invalid package id");
    }
}
