#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include "xmsstuff.h"

int XMS_detect( void )
{
	int found;
	_asm
	{
		mov ax, 4300h
		int 2Fh
		cmp al, 80h
		jne noxms
		mov ax, 1
		mov found, ax
		jp done
	noxms:
		mov ax, 0
		mov found, ax
	done:
	}
	return found;
}

void XMS_ini( void )
{
	_asm
	{
		mov ax,4310h
		int 2Fh
		mov word ptr [XMSControl],bx
		mov word ptr [XMSControl+2],es

		mov ah, 00h
		call [XMSControl]
		mov XMSVersion, ax
	}
}

unsigned int XMS_largestavail( void )
{
	unsigned int free;
	_asm
	{
		mov ah, 08h
		call [XMSControl]
		mov free, ax
		mov error, bl;
	}
	return free;
}

unsigned int XMS_memavail( void )
{
	unsigned int free;
	_asm
	{
		mov ah, 08h
		call [XMSControl]
		mov free, dx
		mov error, bl;
	}
	return free;
}

unsigned int XMS_allocate_block( unsigned int amount )
{
	unsigned int handle;
	unsigned int sucsess;
	_asm
	{
		mov ah, 09h
		mov dx, amount
		call [XMSControl]
		mov sucsess, ax
		mov handle, dx
		mov error, bl;
	}
	return handle;
}

int XMS_free_block( unsigned int handle )
{
	unsigned int sucsess;
	_asm
	{
		mov ah, 0Ah
		mov dx, handle
		call [XMSControl]
		mov sucsess, ax
		mov error, bl;
	}
	return sucsess;
}

char XMS_handles_free( unsigned int handle )
{
	unsigned int sucsess;
	unsigned char handles;
	_asm
	{
		mov ah, 0Eh
		mov dx, handle
		call [XMSControl]
		mov sucsess, ax
		mov handles, bl
		mov error, bl;
	}
	if( sucsess )
		return handles;
	else
		return sucsess;
}


int XMS_move_block( struct ExtMemMoveStruct _far *structin )
{
	unsigned int sucsess;
	_asm
	{
		push ds
		push si
		mov ah, 0Bh
		lds si, structin
		call [XMSControl]
		mov sucsess, ax
		mov error, bl
		pop si
		pop ds
	}
	return sucsess;
}

char _far *XMS_lock_block( unsigned int handle )
{
	char _far *temp;
	unsigned int segpart;
	unsigned int offpart;
	unsigned int sucsess;
	_asm
	{
		mov ah, 0Ch
		mov dx, handle
		call [XMSControl]
		mov sucsess, ax
		mov segpart, dx
		mov offpart, bx
		mov error, bl;
	}

	FP_SEG(temp) = segpart;
	FP_OFF(temp) = offpart;
	if( sucsess )
		return temp;
	else
		return NULL;
}

int XMS_unlock_block( unsigned int handle )
{
	unsigned int sucsess;
	_asm
	{
		mov ah, 0Dh
		mov dx, handle
		call [XMSControl]
		mov sucsess, ax
		mov error, bl;
	}
	return sucsess;
}

int XMSE_xms_to_con( unsigned int handle, char _far *data, unsigned int length )
{
	struct ExtMemMoveStruct mystruct;
	mystruct.Length = length;
	mystruct.SourceHandle = handle;
	mystruct.SourceOffset = 0x00;
	mystruct.DestHandle = 0x00;
	mystruct.DestOffset = ((long)FP_SEG(data) << 16) + FP_OFF(data);

	return XMS_move_block( &mystruct );
}

int XMSE_con_to_xms( unsigned int handle, char _far *data, unsigned int length )
{
	struct ExtMemMoveStruct mystruct;
	mystruct.Length = length;
	mystruct.SourceHandle = 0x00;
	mystruct.SourceOffset = ((long)FP_SEG(data) << 16) + FP_OFF(data);
	mystruct.DestHandle = handle;
	mystruct.DestOffset = 0x00;

	return XMS_move_block( &mystruct );
}

int XMS_enable_A20( void )
{
	unsigned int sucsess;
	_asm
	{
		mov ah, 05h
		call [XMSControl]
		mov sucsess, ax
	}
	return sucsess;
}

int XMS_disable_A20( void )
{
	unsigned int sucsess;
	_asm
	{
		mov ah, 06h
		call [XMSControl]
		mov sucsess, ax
	}
	return sucsess;
}


