/* ARITHMETIC DECODING ALGORITHM. */

#include "arithcod.h"


/* CURRENT STATE OF THE DECODING. */

static code_value value;                /* Currently-seen code value        */
static code_value low, high;            /* Ends of current code region      */



/* START DECODING A STREAM OF SYMBOLS. */

start_decoding()
{
  register int i;
  value = 0;                            /* Input bits to fill the           */
  for (i=1; i<=Code_value_bits; i++) {  /* code value.                      */
    value += value + input_bit();
  }
  low = 0;                              /* Full code range.                 */
  high = Top_value;
}


/* DECODE THE NEXT SYMBOL. */

int decode_symbol(cum_freq)
int cum_freq[];                         /* Cumulative symbol frequencies.   */
{
  long range;                           /* Size of current code region.     */
  register int cum;                     /* Cumulative frequence calculated. */
  register int symbol;                  /* Symbol decoded.                  */
  range = (long) (high-low)+1;
  cum =                                 /* Find cum freq for the value.     */
    (((long)(value-low)+1)*cum_freq[0]-1)/range;
  for (symbol = 1; cum_freq[symbol]>cum; symbol++) ;  /* Then find symbol.  */
  high = low +                          /* Narrow the code region.          */
    (range*cum_freq[symbol-1])/cum_freq[0]-1;
  low = low +
    (range*cum_freq[symbol])/cum_freq[0];
  for (;;) {                            /* Loop to get rid of bits.         */
    if (high<Half) {
      /* Nothing */                     /* Expand low half.                 */
    }
    else if (low>=Half) {               /* Expand high half.                */
      value -= Half;
      low -= Half;                      /* Subtract offset to top.          */
      high -= Half;
    }
    else if (low>=First_qtr && high<Third_qtr) {  /* Expand middle half.    */
      value -= First_qtr;
      low -= First_qtr;                 /* Subtract offset to middle.       */
      high -= First_qtr;
    }
    else break;
    low += low;
    high += high+1;
    value += value + input_bit();
  }
  return symbol;
}

