/* ARITHMETIC ENCODING ALGORITHM. */

#include "arithcod.h"

static void bit_plus_follow();


/* CURRENT STATE OF THE ENCODING. */

static code_value low, high;            /* Ends of the current code region  */
static long bits_to_follow;             /* Number of opposite bits to       */
                                        /* output after the next bit.       */

/* START ENCODING A STREAM OF SYMBOLS. */

start_encoding()
{
  low = 0;                              /* Full code range.                 */
  high = Top_value;
  bits_to_follow = 0;                   /* No bits to follow next.          */
}



/* ENCODE A SYMBOL. */

encode_symbol(symbol,cum_freq)
register int symbol;                    /* Symbol to encode                 */
int cum_freq[];                         /* Cumulative symbol frequencies    */
{
  long range;                           /* Size of the current code region  */
  range = (long) (high-low)+1;
  high = low +                                  /* Narrow the code region   */
    (range*cum_freq[symbol-1])/cum_freq[0]-1;   /* to that alloted to this  */
  low = low +                                   /* symbol.                  */
    (range*cum_freq[symbol])/cum_freq[0];
  for (;;)  {                           /* Loop to output bits.             */
    if (high<Half)  {
      bit_plus_follow(0);               /* Output 0 if in low half.         */
    }
    else if (low>=Half) {               /* Output 1 if in high half.        */
      bit_plus_follow(1);
      low -= Half;
      high -= Half;                     /* Subtract offset to top.          */
    }
    else if (low>=First_qtr && high<Third_qtr) {  /* Output an opposite bit */
      bits_to_follow += 1;                        /* later if in middle half*/
      low -= First_qtr;                 /* Subtract offset to middle        */
      high -= First_qtr;
    }
    else break;                         /* Otherwise exit loop.             */
    low += low;
    high += high+1;                     /* Scale up code range.             */
  }
}


/* FINISH ENCODING THE STREAM. */

done_encoding()
{
  bits_to_follow += 1;                      /* Output two bits that select  */
  if (low<First_qtr) bit_plus_follow(0);    /* the quarter that the current */
  else bit_plus_follow(1);                  /* code range contains.         */
}


/* OUTPUT BITS PLUS FOLLOWING OPPOSITE BITS. */

static void bit_plus_follow(bit)
register int bit;
{
  output_bit(bit);                      /* Output the bit.                  */
  while (bits_to_follow>0) {
    output_bit(!bit);                   /* Output bits_to_follow opposite   */
    bits_to_follow -= 1;                /* bits. Set bits_to_follow to 0.   */
  }
}
