/* BIT INPUT ROUTINES. */

#include <stdio.h>
#include "arithcod.h"


/*  THE BIT BUFFFFER. */

static int buffer;                      /* Bits waiting to be input.        */
static int bits_to_go;                  /* Number of bits still in buffer.  */
static int garbage_bits;                /* Number of bits past end-of-file. */


/* INITIALIZE BIT INPUT. */

start_inputing_bits()
{
  bits_to_go = 0;                       /* Buffer starts out with no bits   */
  garbage_bits = 0;
}


/* INPUT A BIT. */

int input_bit()
{
  register int t;
  if (bits_to_go==0) {                  /* Read next byte if no bits are    */
    buffer = getc(stdin);               /* left in the buffer.              */
    if (buffer==EOF) {
      garbage_bits += 1;                /* Return arbitrary bits.           */
      if (garbage_bits>Code_value_bits-2) {
        fprintf(stderr,"Bad input file\n");
        exit(-1);
      }
    }
    bits_to_go = 8;
  }
  t = buffer&1;
  buffer >>= 1;
  bits_to_go -= 1;
  return t;
}
