/* MAIN PROGRAM FOR DECODING. */

#include <stdio.h>
#include <fcntl.h>
#include "model.h"

main()
{
  if (setmode(fileno(stdin), O_BINARY) == -1) {
    fprintf(stderr, "Cannot change mode for stdin\n");
    exit(1);
  }
  if (setmode(fileno(stdout), O_BINARY) == -1) {
    fprintf(stderr, "Cannot change mode for stdout\n");
    exit(1);
  }
  start_model();                        /* Set up other modules             */
  start_inputing_bits();
  start_decoding();
  for(;;) {                             /* Loop through characters.         */
    register int ch;
    register int symbol;
    symbol = decode_symbol(cum_freq);   /* Decode next symbol.              */
    if (symbol==EOF_symbol) break;      /* Exit loop if EOF symbol.         */
    ch = index_to_char[symbol];         /* Translate to a character.        */
    putc(ch,stdout);                    /* Write that character.            */
    update_model(symbol);               /* Update the model.                */
  }
  exit(0);
}
