// dir.CPP									 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "DIR"    // Name of module

typedef struct
{
	char list_order[50];
} DIR_INFO;

/**/
static int dir(AU *au, char *file_name)
{
	DIR_INFO *in = (DIR_INFO *)au->info;
	struct ffblk ffblk; 		  // directory entry structure
	int i;
	DATE date1, date2;
	date datep;
	char temp[FILE_SIZE];
	char disp_string[200];
	char piece[80];
	char *ptr;

	check_for_key();

	disp_string[0] = '\0';
	if (!findfirst(file_name, &ffblk, 0))
	{
		i=0;
		while (in->list_order[i] != '\0')
		{
			switch (in->list_order[i])
			{
			case '1':
				sprintf(piece, "%04x ", crc16(au, file_name));
				break;
			case '3':
				sprintf(piece, "%08lx ", crc32(au, file_name));
				break;
			case 'A':
				getdate(&datep);				  // Current date */
				date1.year	= datep.da_year - 1900;
				date1.month = datep.da_mon;
				date1.day	= datep.da_day;
				fdate_to_date(&date2, &ffblk);
				sprintf(piece, "%6ld ", days_diff(&date2, &date1));
				break;
			case 'D':
				fdate_to_date(&date1, &ffblk);
				sprintf(piece, "%s ", date_to_string(&date1));
				break;
			case 'E':
				ptr = strchr(file_name, '.');
				if (ptr != NULL)
					sprintf(piece, "%-*s ", FILE_EXT-1, ptr+1);
				break;
			case 'N':
				sprintf(piece, "%-*s ", FILE_SIZE-1, file_name);
				break;
			case 'P':
				strcpy(temp, file_name);
				ptr = strchr(temp, '.');
				if (ptr != NULL)
					*ptr = '\0';
				sprintf(piece, "%-*s ", FILE_PREF-1, temp);
				break;
			case 'S':
				sprintf(piece, "%11ld ", ffblk.ff_fsize);
				break;
			case 'T':
				sprintf(piece, "%02d:%02d:%02d ",
						 (ffblk.ff_ftime & 0xF800) >> 11,
						 (ffblk.ff_ftime & 0x07E0) >> 5,
						 (ffblk.ff_ftime & 0x001F) * 2);
				break;
			case '_':
				sprintf(piece, " ");
				break;
			default:
				au_printf_error(au, "Unknown list piece '%c'", in->list_order[i]);
				exit(1);
			}
			strcat(disp_string, piece);
			i++;
		}
		au_printf(au, "%s", disp_string);
		safe_string_copy(au->env_cont, disp_string, CLENGTH, FALSE);
		au_printf(au, "\n");
	}
	return 0;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];

	DIR_INFO *in = (DIR_INFO *)au->info;

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt,string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'LI':                                          // List_Order
				strcpy(in->list_order, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	DIR_INFO *in = (DIR_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'L':
			safe_string_copy(in->list_order, cur_argv, 30, FALSE);
			strupr(in->list_order);
			break;
		case '?':
			au_standard_opt_header(au, "DIr",
			   "@?3-L@?Dx@?H              @?3L@?Hist order, where @?Dx@?H = string of:\n"
			   "  @?D1@?H - @?D1@?H6 bit CRC\n"
			   "  @?D3@?H - @?D3@?H2 bit CRC\n"
			   "  @?DA@?H - @?DA@?Hge\n"
			   "  @?DD@?H - @?DD@?Hate\n"
			   "  @?DE@?H - file @?DE@?Hxtension\n"
			   "  @?DN@?H - file @?DN@?Hame\n"
			   "  @?DP@?H - file @?DP@?Hrefix\n"
			   "  @?DS@?H - @?DS@?Hize\n"
			   "  @?DT@?H - @?DT@?Hime\n"
			   "  @?D_@?H - Extra space\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_dir(AU *au, int argc, char *argv[])
{
	DIR_INFO *in;

	in = (DIR_INFO *)au_malloc(au, sizeof(DIR_INFO));
	memset(in, '\0', sizeof(DIR_INFO));
	au->info = in;
	strcpy(in->list_order, "NSDT3");

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, dir);

	return 0;
}

