#include "..\au.hpp"
#include "..\spawno\spawno.h"
#include <process.h>

/*********************************************************************/
BYTE is_stdout(void)
{
	_AH = 0x44;
	_BX = 1;
	_AL = 0;
	__int__(0x21);
	if (_DX & 0x01 && _DX & 0x80 && _DX & 0x40 && !(_DX & 0x04))
		return TRUE;
	else
		return FALSE;
}

/*********************************************************************/
void far interrupt newfunc(...)
{
   return;
}
/********************************************************************/
static enough_memory(AU *au, int k_needed)
{
	long memCurrent = farcoreleft();
	if (memCurrent > (long)k_needed * 1024)
		return 0;		 /* Enough so regular spawn can be used */
	else if (memCurrent > (long)k_needed * 1024 - IMAGE_MEMORY - au->memStart)
		return 1;		 /* Enough so spawno can still work */
	else
		return 2;		 /* Not enough memory period */
}
/********************************************************************/
int execute(AU *au, char *string, char *output, char *input, int k_needed)
{
	char *args[15];
	char c;
	int  ret;
	int  i=0;
	int  pos=0;
	int  old_stdout;
	int  old_stdin;
	int  show;
	int  temp;
	void (far interrupt *inter)(...);

	if (au->show_execute)
	{
		au_printf_c(au, 13, "%s", string);
		if (output != NULL && output[0] != '\0')
			au_printf_c(au, 13, ">> %s", output);
		if (input != NULL && input[0] != '\0')
			au_printf_c(au, 13, "< %s", input);
		au_printf(au, "\n");
	}

	for (EVER)
	{
		ltrim(string+pos);
		args[i++] = string+pos;
		for (EVER)
		{
			c = string[pos];
			if (c == ' ')
			{
				string[pos] = '\0';
				pos++;
				break;
			}
			if (c == '\0')
				goto out_loop;
			pos++;
		}
	}
 out_loop:
	args[i] = NULL;

	if (output != NULL && output[0] != '\0')
		old_stdout = dup(1);	   // duplicate handle of stdout

	if (input != NULL && input[0] != '\0')
		old_stdin = dup(0); 	   // duplicate handle of stdin

	if (output != NULL && output[0] != '\0')
	{
		close(1);				   // close stdout
		open(output, O_RDWR);	   // open output as stdout
	}
	if (input != NULL && input[0] != '\0')
	{
		close(0);				   // close stdin
		open(input, O_RDWR);	   // open input as stdin
	}


#if 0
	 _AH = 0x44;
	_BX = 1;
	_AL = 0;
	__int__(0x21);
	temp = _DX;
	if (temp & 0x02)
		show = TRUE;
	else
		show = FALSE;
#endif


#if 0
	inter = getvect(0x10);		  // save old
	if (!show)
		setvect(0x10, newfunc);
#endif

	switch (enough_memory(au, k_needed))
	{
	case 0:
		ret = spawnvp(P_WAIT, args[0], args);
		break;
	case 1:
		au_printf_c(au, 15, "Swapping AU\n");
		init_SPAWNO(".", SWAP_ANY) ;
		ret = spawnvpo(".", args[0], args);
		break;
	case 2:
		au_printf_error(au, "Insufficient memory to run: %s", string);
		exit(CANT_EXECUTE);
	}

#if 0
	setvect(0x10, inter);		  // restore old
#endif

	if (output != NULL && output[0] != '\0')
	{
		close(1);				   // reset old stdout
		dup(old_stdout);
		close(old_stdout);
	}
	if (input != NULL && input[0] != '\0')
	{
		close(0);				   // reset old stdin
		dup(old_stdin);
		close(old_stdin);
	}

	if (ret < 0)
	{
		au_printf_error(au, "Unable to Execute '%s'", string);
		exit(CANT_EXECUTE);
	}
	return ret;
}
