// ORPHAN.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

#define PROGRAM "ORPHAN"  // Name of module
/*********************************************************************/

typedef struct
{
	LISTPTR list;
	char source_directory[120];  /* hold so we can tell when it changes */
	int number_orphans;
} ORPHAN_INFO;

/**/
static void get_files(AU *au, LISTPTR *list)
{
	HANDLE file;
	char string[80];

	for (int fpos = 0 ; fpos < au->flist_pos; fpos++)
	{
		char *file_name = au->flist[fpos];

		if (file_name[0] == '\0')
			continue;

		file = au_open(au, file_name, O_RDWR|O_TEXT);

		if (file == -1)
		{
			au_printf_error(au, "\nFile Listing File '%s' not found", file_name);
			continue;
		}
		while (get_next_file_name(au, file, string, NULL) != EOF)
			add_to_list(au, list, string);
		close(file);
	}
	return;
}

/**/
static BYTE find_file(char *file_name, LISTPTR *list)
{
	LIST *el;
	for (el = list->head; el != NULL; el = el->next)
	{
		if (stricmp(el->data, file_name) == 0)
			return TRUE;
	}
	return FALSE;
}
/**/
static int orphan(AU *au, char *file_name)
{
	ORPHAN_INFO *in = (ORPHAN_INFO *)au->info;

	check_for_key();

	if (!ok_to_process(au, file_name))
		return FALSE;

	if (strcmp(au->source_directory, in->source_directory) != 0)
	{
		destroy_list(&in->list);
		get_files(au, &in->list);
		strcpy(in->source_directory, au->source_directory);
	}

	if (!find_file(file_name, &in->list))
	{
		au_printf(au, "@?6Orphan File: @?1%s@?H\n", file_name);
		in->number_orphans++;
	}
	au->number_processed++;
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);
	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_standard_opt_header(au, "Orphan", NULL);
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'DO':                                          // Dont_process
				add_to_list(au, &au->dont_touch, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
int main_orphan(AU *au, int argc, char *argv[])
{
	ORPHAN_INFO *in;

	in = (ORPHAN_INFO *)au_malloc(au, sizeof(ORPHAN_INFO));
	memset(in, '\0', sizeof(ORPHAN_INFO));
	au->info = in;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, orphan);

	if (!au->no_extra)
	{
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);
		au_printf_c(au, 15, "\nOrphans Found   = %d\n", in->number_orphans);
	}
	return 0;
}

